#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)bp_copy.c (TWG)  1.2     89/09/12 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include "sys/param.h"
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/inet.h"
#include "sys/debug.h"

/*
 * dup data 'len' byte from offset 'off'
 * return the new block if o.k, or NULL if failed
 * DO NOT cross to b_next message
 */
mblk_t *
bp_copy(mb, off, len)
	register mblk_t *mb;
	register int off;
	register int len;
{
	register mblk_t *mp, *mp1;

	ASSERT(mb && len > 0 && off >= 0);

	/*
	 * valid request?
	 */
	if (msgdsize(mb) < (off + len))
		return (NULL);

	/*
	 * find the offset in the original message
	 */
	while (off > 0)
	{
		if ((BLEN(mb) > 0) && (off < BLEN(mb)))
			break;
		off -= BLEN(mb);
		mb = mb->b_cont;
	}

	/*
	 * Dup first message block required.
	 */
	if ((mp = dupb(mb)) == NULL)
		return (NULL);
	mp->b_rptr += off;
	len -= BLEN(mp);
	mb = mb->b_cont;
	mp1 = mp;

	/*
	 * Dup all remaining blocks upto length.
 	 */
	while ((len > 0) && (mb != NULL))
	{
		if (BLEN(mb) == 0)		/* remove NULL buffers */
		{
			mb = mb->b_cont;
			continue;
		}
		if ((mp1 = dupb(mb)) == NULL)	/* duplicate next msg */
		{
			freemsg(mp);
			return (NULL);
		}
		linkb(mp, mp1);
		len -= BLEN(mp1);
		mb = mb->b_cont;
	}

	/*
	 * Clean up last mblk to have correct length.
	 */
	if (len < 0)
	{
		mp1->b_wptr = mp1->b_rptr + (BLEN(mp1) + len);
	}

	return (mp);
}

/*
 * Calculate the length of a string
 */
int
blen(s)
register char *s;
{
	char *p = s;

	while (*s++);
	return(s-p);
}
