#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)up.c (TWG)  1.1     89/05/19 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */
 
#include "sys/param.h"
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/debug.h"
#include "sys/ip.h"
#include "sys/tcp.h"

/*
 * send a T_ok_ack upstream
 * q is the downward q, bp holds the T_ok_ack, and prim is the request type
 * on input, bp points to some T_primitives, we check it here to see if
 * we can use it for reply. If not, free it and allocb a new one
 * return -1 if can't allocb, 0 if o.k.
 */
int
up_ok_ack(q, bp, prim)

	register queue_t *q;
	register mblk_t *bp;
	register long prim;
{
	register struct T_ok_ack *p;

	ASSERT(q && !(q->q_flag&QREADR) && bp);
	if (!REUSEABLE(bp, sizeof(struct T_ok_ack))) {
		freemsg(bp);
		if ((bp = allocb(sizeof(struct T_ok_ack), BPRI_MED)) == NULL)
			return(-1);
	}
	MTYPE(bp) = M_PCPROTO;
	p = (struct T_ok_ack *)bp->b_rptr;
	p->PRIM_type = T_OK_ACK;
	p->CORRECT_prim = prim;
	bp->b_wptr += sizeof(struct T_ok_ack);
	WQREPLY(q, bp);
	return(0);

}	/*  End of up_ok_ack()  */

/*
 * send an T_error_ack upstream
 */
int
up_error_ack(q, bp, prim, code)

	register queue_t *q;
	register mblk_t *bp;
	register long prim;
	register long code;
{
	register struct T_error_ack *p;

	ASSERT(q && !(q->q_flag&QREADR) && bp);
	if (!REUSEABLE(bp, sizeof(struct T_error_ack))) {
		freemsg(bp);
		if ((bp = allocb(sizeof(struct T_error_ack), BPRI_MED)) == NULL)
			return(-1);
	}
	MTYPE(bp) = M_PCPROTO;
	p = (struct T_error_ack *)bp->b_rptr;
	p->PRIM_type = T_ERROR_ACK;
	p->ERROR_prim = prim;
	p->TLI_error = code;
	bp->b_wptr += sizeof(struct T_error_ack);
	qreply(q, bp);
	return(0);

}	/*  End of up_error_ack()  */


/*
 * send M_FLUSH upstream to flush both the read and write queues
 * q is write q
 * return 0 if o.k. and -1 if failed
 */
int
upflush(q)

	register queue_t *q;
{

	ASSERT(q);
	q = RD(q);
	flushq(q, FLUSHALL);
	if (putctl1(q->q_next, M_FLUSH, FLUSHRW) == 0)
		return(-1);
	return(0);

}	/*  End of upflush()  */

