#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)if.c (TWG)  1.1     89/05/17 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/stream.h>
#include <sys/if.h>
#include <sys/in.h>
#include <sys/in_var.h>
#include <sys/stropts.h>
#include <sys/ip.h>
#include <sys/inetioctl.h>
#ifdef NCR
#include <sys/mee.h>
#endif /* NCR */
  
extern	int fdip;
extern	int tflag;
extern	int nflag;
extern	char *routename();
extern	char *index();

/*
 * Print a description of the network interfaces.
 */
#ifdef NCR
intpr(interval, ifnetaddr, ettaladdr)
	int interval;
	off_t ifnetaddr;
	off_t ettaladdr;
#else
intpr(interval, ifnetaddr)
  	int			interval; 
  	off_t			ifnetaddr; /* value from "ipbnext" */
#endif /* NCR */
{
	struct strioctl		strioctl;
	struct ifnet		ifnet;
	char			name[16];
	struct in_addr		my_inaddr;
	struct in_ifaddr	ia_entry;
#ifdef NCR
	struct et_tallies	ettal;
	unchar			*nameptr;
#endif /* NCR */

	if (interval) {
#ifdef NCR
		sidewaysintpr(interval, ifnetaddr, ettaladdr);
#else
  		sidewaysintpr(interval, ifnetaddr);
#endif /* NCR */
		return;
	}
	printf("%-5.5s %-5.5s %-11.11s %-14.14s %-7.7s %-5.5s %-7.7s %-5.5s",
		"Name", "Mtu", "Network", "Address", "Ipkts", "Ierrs",
		"Opkts", "Oerrs");
#ifdef NCR
	printf(" %-6.6s", "Collis");
#endif /* NCR */
#ifdef notdef
	if (tflag)
		printf(" %-6.6s", "Timer");
#endif /* notdef */
	putchar('\n');

	ifnet.if_next = (struct ifnet *)1; /* force start at head of list */
	while (ifnet.if_next)
	{
		struct sockaddr_in	sin;
		register char		*cp;
		struct in_addr		in, inet_makeaddr();

		strioctl.ic_cmd = IPIOC_GETIPB;
		strioctl.ic_timout = 0;
		strioctl.ic_len = sizeof (struct ifnet);
		strioctl.ic_dp  = (char *)&ifnet;
		if (ioctl(fdip, I_STR, &strioctl )<0) {
			if (errno != EADDRNOTAVAIL )
				perror( "netstat: ifnet" );
			return;		
		}
		cp = index(ifnet.if_name, '\0');
		if ((ifnet.if_flags&IFF_UP) == 0)
			*cp++ = '*';
		*cp = '\0';
#ifdef NCR
		klseek(kmem, ettaladdr, 0);
		kread(kmem, &ettal, sizeof(ettal));
#endif /* NCR */
		printf("%-5.5s %-5d ", ifnet.if_name, ifnet.if_mtu);

		ia_entry.ia_next = (struct in_ifaddr *)ifnet.if_addrlist;
		strioctl.ic_cmd = IPIOC_GETINADDR;
		strioctl.ic_timout = 0;
		strioctl.ic_len = sizeof ia_entry;
		strioctl.ic_dp  = (char *)&ia_entry;
		if (ioctl(fdip, I_STR, &strioctl )<0) {
			perror( "netstat: ia_entry" );
			continue;		
		}
		my_inaddr = IA_SIN(&ia_entry)->sin_addr;
		sin.sin_addr.s_addr = my_inaddr.s_addr;
		in = inet_makeaddr(inet_netof(my_inaddr), INADDR_ANY);
		printf("%-11.11s ",
			netname(htonl(ia_entry.ia_subnet),
				ia_entry.ia_subnetmask));
#ifdef NCR
		nameptr = &ifnet.if_name[0];
		if( (strncmp(nameptr,"lo",2)) != 0 ) {
			printf("%-14.14s %-7d %-5d %-7d %-5d %-7d",
			    routename(sin.sin_addr),
			    ettal.sb_rcnt, ettal.sb_recnt,
			    ettal.sb_xcnt, ettal.sb_xecnt,
			    ettal.sb_jam );
		} else {
			printf("%-14.14s %-7d %-5d %-7d %-5d %-7d",
			    routename(sin.sin_addr),
			    ifnet.if_ipackets, ifnet.if_ierrors,
			    ifnet.if_opackets, ifnet.if_oerrors,
			    /* ifnet.if_collisions */0);
		}
#else
		printf("%-14.14s %-7d %-5d %-7d %-5d",
  		    routename(sin.sin_addr),
  		    ifnet.if_ipackets, ifnet.if_ierrors,
		    ifnet.if_opackets, ifnet.if_oerrors,
		    /* ifnet.if_collisions */0);
#endif /* NCR */
#ifdef notdef
		if (tflag)
			printf(" %-6d", ifnet.if_timer);
#endif /* notdef */
		putchar('\n');
	}
}

#define	MAXIF	10
struct	iftot {
	char	ift_name[16];		/* interface name */
	int	ift_ip;			/* input packets */
	int	ift_ie;			/* input errors */
	int	ift_op;			/* output packets */
	int	ift_oe;			/* output errors */
	int	ift_co;			/* collisions */
} iftot[MAXIF];

/*
 * Print a running summary of interface statistics.
 * Repeat display every interval seconds, showing
 * statistics collected over that interval.  First
 * line printed at top of screen is always cumulative.
 */
#ifdef NCR
sidewaysintpr(interval, off, etoff)
	int interval;
	off_t off;
	off_t etoff;
#else
sidewaysintpr(interval, off)
	int			interval;
	off_t			off;	/* value from "ipbnext" */
#endif /* NCR */
{
	struct strioctl		strioctl;
	struct ifnet		ifnet;
	off_t			firstifnet;
	register struct iftot	*ip, 
				*total;
	struct iftot		*lastif, 
				*sum, 
				*interesting;
	register int		line;
	int			maxtraffic;
	char			*cp;
	extern char		_sobuf[];

	setbuf(stdout, _sobuf);
	ip     = iftot;
	sum    = iftot + MAXIF - 1;
	total  = sum - 1;
	ifnet.if_next = (struct ifnet *)1; /* force start at head of list */
	while (ifnet.if_next) {
		strioctl.ic_cmd = IPIOC_GETIPB;
		strioctl.ic_timout = 0;
		strioctl.ic_len = sizeof ifnet;
		strioctl.ic_dp  = (char *)&ifnet;
		if (ioctl(fdip, I_STR, &strioctl )<0) {
			if (errno != EADDRNOTAVAIL )
				perror( "netstat: sidewaysintpr" );
			break;		
		}
		ip->ift_name[0] = '(';
		memcpy(ip->ift_name + 1,ifnet.if_name, sizeof(ifnet.if_name)-2);
		ip->ift_name[15] = '\0';
		cp = index(ip->ift_name, '\0');
		sprintf(cp, "%d)", ifnet.if_unit);
		ip++;
		if (ip >= iftot + MAXIF - 2)
			break;
	}
	lastif = ip;
	interesting = iftot;
banner:
	printf("    input   %-6.6s    output       ", interesting->ift_name);
	if (lastif - iftot > 0)
		printf("    input   (Total)    output       ");
	for (ip = iftot; ip < iftot + MAXIF; ip++) {
		ip->ift_ip = 0;
		ip->ift_ie = 0;
		ip->ift_op = 0;
		ip->ift_oe = 0;
		ip->ift_co = 0;
	}
	putchar('\n');
	printf("%-7.7s %-5.5s %-7.7s %-5.5s %-5.5s ",
		"packets", "errs", "packets", "errs", "colls");
	if (lastif - iftot > 0)
		printf("%-7.7s %-5.5s %-7.7s %-5.5s %-5.5s ",
			"packets", "errs", "packets", "errs", "colls");
	putchar('\n');
	fflush(stdout);
	line = 0;
loop:
	sum->ift_ip = 0;
	sum->ift_ie = 0;
	sum->ift_op = 0;
	sum->ift_oe = 0;
	sum->ift_co = 0;
	ifnet.if_next = (struct ifnet *)1; /* force start at head of list */
	for ( ip = iftot; ifnet.if_next && ip < lastif; ip++) {
		strioctl.ic_cmd = IPIOC_GETIPB;
		strioctl.ic_timout = 0;
		strioctl.ic_len = sizeof ifnet;
		strioctl.ic_dp  = (char *)&ifnet;
		if (ioctl(fdip, I_STR, &strioctl )<0) {
			if (errno != EADDRNOTAVAIL )
				perror( "netstat: sidewaysintpr" );
			break;		
		}
		if (ip == interesting)
			printf("%-7d %-5d %-7d %-5d %-5d ",
				ifnet.if_ipackets - ip->ift_ip,
				ifnet.if_ierrors - ip->ift_ie,
				ifnet.if_opackets - ip->ift_op,
				ifnet.if_oerrors - ip->ift_oe,
				/*ifnet.if_collisions - ip->ift_co*/0);
		ip->ift_ip = ifnet.if_ipackets;
		ip->ift_ie = ifnet.if_ierrors;
		ip->ift_op = ifnet.if_opackets;
		ip->ift_oe = ifnet.if_oerrors;
		ip->ift_co = /*ifnet.if_collisions*/ 0;
		sum->ift_ip += ip->ift_ip;
		sum->ift_ie += ip->ift_ie;
		sum->ift_op += ip->ift_op;
		sum->ift_oe += ip->ift_oe;
		sum->ift_co += ip->ift_co;
	}
	if (lastif - iftot > 0)
		printf("%-7d %-5d %-7d %-5d %-5d\n",
			sum->ift_ip - total->ift_ip,
			sum->ift_ie - total->ift_ie,
			sum->ift_op - total->ift_op,
			sum->ift_oe - total->ift_oe,
			sum->ift_co - total->ift_co);
	*total = *sum;
	fflush(stdout);
	line++;
	if (interval)
		sleep(interval);
	if (line == 21)
		goto banner;
	goto loop;
	/*NOTREACHED*/
}
