#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)rlogin.c (TWG)  1.1     89/05/17 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/*
 * rlogin - remote login
 *
 * 02/14/91 changed writer and reader to check occasionally for chars from
 *	    stdin--permits DEL to get through when output is steady. (SPR4804)
 */
#include <sys/types.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/stream.h>
#include <sys/stropts.h>

#include <sys/in.h>
#include <sys/ip.h>
#include <sys/inetioctl.h>

#include <stdio.h>
#include <termio.h>
#include <sys/fcntl.h>
#include <sys/tiuser.h>
#define SUSPEND_CHAR 'z' /* Control z is supend */
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <netdb.h>

/****#define t_snd write **/
/****#define t_rcv read ***/
/****#define t_rcmd rcmd ***/
char	*index(), *rindex(), *malloc(), *getenv();
struct	passwd *getpwuid();
char	*name;
int	rem; int reader();
char	cmdchar = '~';
int	eight;
char	*speeds[] =
    { "0", "50", "75", "110", "134", "150", "200", "300",
      "600", "1200", "1800", "2400", "4800", "9600", "19200", "38400" };
char	term[64] = "network";
extern	int errno;
int	lostpeer();
int Parent, Child;
int	oobflag = 0;
int	stdinfl;

main(argc, argv)
	int argc;
	char **argv;
{
	char *host, *cp;
	struct termio ttyb;
	struct passwd *pwd;
	struct servent *sp;
	int uid, options = 0;

	host = rindex(argv[0], '/');
	if (host)
		host++;
	else
		host = argv[0];
	argv++, --argc;
	if (!strcmp(host, "rlogin"))
		host = *argv++, --argc;
another:
	if (argc > 0 && !strcmp(*argv, "-l")) {
		argv++, argc--;
		if (argc == 0)
			goto usage;
		name = *argv++; argc--;
		goto another;
	}
	if (argc > 0 && !strncmp(*argv, "-e", 2)) {
		cmdchar = argv[0][2];
		argv++, argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-8")) {
		eight = 1;
		argv++, argc--;
		goto another;
	}
	if (host == 0)
		goto usage;
	if (argc > 0)
		goto usage;
	pwd = getpwuid(getuid());
	if (pwd == 0) {
		fprintf(stderr, "Who are you?\n");
		exit(1);
	}
	sp = getservbyname("login", "tcp");
	if (sp == 0) {
		fprintf(stderr, "rlogin: login/tcp: unknown service\n");
		exit(2);
	}
	cp = getenv("TERM");
	if (cp)
		strcpy(term, cp);
	if (ioctl(0, TCGETA, &ttyb)==0) {
		strcat(term, "/");
		strcat(term, speeds[ttyb.c_cflag&CBAUD]);
	}
        rem = t_rcmd(&host, ntohs(sp->s_port), pwd->pw_name,
	    name ? name : pwd->pw_name, term, 0);
        if (rem < 0)
                exit(1);
	uid = getuid();
	if (setuid(uid) < 0) {
		perror("rlogin: setuid");
		exit(1);
	}
	doit();
	/*NOTREACHED*/
usage:
	fprintf(stderr,
	    "usage: rlogin host [ -ex ] [ -l username ] [ -8 ]\n");
	exit(1);
}

#define CRLF "\r\n"

int	child;
int	catchild();

struct termio defterm;
int tabflag;
struct termio noterm;

char	deferase, defkill;

doit()
{
	int reset();
	struct termio sb;

	ioctl(0,TCGETA,&sb);
	defterm = sb;
	tabflag = sb.c_oflag & TABDLY;
	deferase = sb.c_cc[VERASE];
	defkill = sb.c_cc[VKILL];
	noterm = sb;
	noterm.c_cc[VMIN] = 1;
	noterm.c_cc[VTIME] = -1;
	noterm.c_lflag = 0;
	noterm.c_oflag &= ~(ONLCR | OCRNL | ONOCR | ONLRET);
	noterm.c_iflag &= ~(ICRNL | INLCR | IGNCR);
	noterm.c_iflag |= IGNBRK;
	if (eight) {
		noterm.c_iflag &= ~(ISTRIP | INPCK);
		noterm.c_iflag |= IGNPAR;
		noterm.c_oflag &= ~OPOST;
		noterm.c_cflag &= ~(PARENB | CSIZE);
		noterm.c_cflag |= CS8;
	}
	/* Tabdelay is same as expand tabs */
	if ((noterm.c_oflag & TABDLY) == TAB3)
		noterm.c_oflag &= ~TAB3;
	noterm.c_cc[VERASE]=noterm.c_cc[VKILL]= -1;

	signal(SIGHUP, reset);
	signal(SIGQUIT, reset);
	signal(SIGINT, SIG_IGN);
#ifdef TWO_PROCS
	Parent = getpid();
	Child = fork();
	if (Child < 0){
		perror("fork");
		exit(1);
	}
	mode(1);
	if (Child == 0){
		/*
		 * Be a reader from remote
		 */
		
		reader();
		mode(0);
		(void)kill(Parent, SIGHUP);
		(void)printf(" Connection closed..\n");
		exit(1);
	}
#else
	/* -ac set up interrupt handler first before enabling the interrupt */
	(void)sigset(SIGPOLL, reader);
	(void)fcntl(rem, F_SETFL, O_NDELAY);
	(void)ioctl(rem, I_SETSIG, S_INPUT);
	(void)mode(1);
	(void)reader(SIGPOLL);	/* Pretend that we just got a signal */
#endif /* TWO_PROCS */
	(void)writer();
	(void)sleep(1);
	(void)prf("\007Connection closed.");
	done();
}

done()
{

	mode(0);
#ifdef TWO_PROCS
	if (Child) (void)kill(Child, SIGHUP);
	if (Parent) (void)kill(Parent, SIGHUP);
#endif /* TWO_PROCS */
	exit(0);
}

/*
 * writer: write to remote: 0 -> line.
 * ~.	terminate
 * System 5 ( No such luck ) as suspend
 * ~^Z	suspend rlogin process.
 * ~^Y  suspend rlogin process, but leave reader alone.
 */
writer()
{
	char c;
	register n;

	stdinfl = fcntl(0, F_GETFL, 0);
	for (;;) {

		n = read(0, &c, 1);
		if (n == 0)
			break;
		if (n < 0)
			if (errno == EINTR)
				continue;
			else {

				printf("Bad read from terminal..\n");
				break;
			}

		if (eight == 0)
			c &= 0177;
		wrtch(c);
	}
}

/* process a single char from the tty */
wrtch(ac)
char ac;
{	char c;
	static char b[600];
	static char *p = b;
	static int local;

	c = ac;
	/*
	 * If we're at the beginning of the line
	 * and recognize a command character, then
	 * we echo locally.  Otherwise, characters
	 * are echo'd remotely.  If the command
	 * character is doubled, this acts as a 
	 * force and local echo is suppressed.
	 */
	if (p == b)
		local = (c == cmdchar)?1:0;
	if ((p == (b + 1)) && *b == cmdchar)
		local = (c != cmdchar);
	if (!local) {
		if (t_snd(rem, &c, 1, 0) != 1) {
			prf("line gone");
			return;
		}
		if (eight == 0)
			c &= 0177;
	} else {
		if (c == '\r' || c == '\n') {
			char cmdc = b[1];

			if (cmdc == '.' || cmdc == defterm.c_cc[VEOF])
			{
				(void)write(0, CRLF, sizeof(CRLF));
				return;
			}
			/*
			 * Can't Send SIGTSTP in System 5
			 * So we will just creat a new shell
			 */
			if ( cmdc == SUSPEND_CHAR )
			{
				int pid, (*oldsig)(), (*osigint)();
				int (*osigquit)();
				(void)write(0, CRLF, sizeof(CRLF));
				(void)mode(0);
				oldsig = (int (*)())signal(SIGCLD,SIG_DFL);
				osigint = (int (*)())signal(SIGINT,SIG_IGN);
				osigquit = (int (*)())signal(SIGQUIT,SIG_IGN);
#ifndef TWO_PROCS
				(void)sighold(SIGPOLL);
#endif
				if ((pid = fork()) < 0){
					/*
					 * Can't fork()
					 */
					perror("Can't Fork");
				}
				else
				if (pid == 0){
					char *shell;
					int i;
					register char *cp;
					char *index();

					for ( i = 3 ; i < 10 ; i++)
						close(i);
					signal(SIGINT, SIG_DFL);
					signal(SIGQUIT, SIG_DFL);
					shell=(char *)getenv("SHELL");
					if (!shell) shell = "/bin/sh";
					cp = index(shell,'/');
					if (!cp) cp = shell;
					/*
					 * Rlogin is normally setuid
					 * so avoid giving user privs
					 */
					(void)setuid(getuid());
					(void)execl(shell?shell : 
						"/bin/sh", cp,0);
					exit(1);
					/* NOTREACHED */
				}
				else
					/*
					 * Wait for child to die
					 */
					while (pid != wait(0));
				(void)signal(SIGCLD,oldsig);
				(void)signal(SIGQUIT,osigquit);
				(void)signal(SIGINT,osigint);
#ifndef TWO_PROCS
				(void)sigrelse(SIGPOLL);
#endif
				(void)mode(1);
				/* goto top; */ p = b;
				return;
			}
			*p++ = c;
			/* write(rem, b, p - b, 0); */
			(void)t_snd(rem, b, p - b, 0);
			/* goto top; */ p = b;
			return;
		}
		(void)write(1, &c, 1);
	}
	*p++ = c;
	if (c == deferase) {
		p -= 2; 
		if (p < b)
			/* goto top; */ p = b;
	}
	if (c == defkill || c == defterm.c_cc[VEOF] ||
	    c == '\r' || c == '\n')
		/* goto top; */ p = b;
	else if (p >= &b[sizeof b])
		p--;
}

oob(buf)
	char *buf;
{


	ioctl(1,TCFLSH,1);
	if (!eight && (*buf & TIOCPKT_NOSTOP)) {
		noterm.c_cflag &= ~(PARENB | CSIZE);
		noterm.c_cflag |= CS8;
		noterm.c_iflag &= ~(IXON | INPCK | ISTRIP);
		noterm.c_iflag |= IGNPAR;
		noterm.c_oflag &= ~OPOST;
		(void)ioctl(0, TCSETAW,&noterm);
	}
	if (!eight && (*buf & TIOCPKT_DOSTOP)) {
		noterm.c_cflag &= ~CSIZE;
		noterm.c_cflag |= defterm.c_cflag & (PARENB | CSIZE);
		noterm.c_iflag &= ~IGNPAR;
		noterm.c_iflag |= IXON;
		noterm.c_iflag |= defterm.c_iflag & (IGNPAR | INPCK | ISTRIP);
		noterm.c_oflag |= defterm.c_cflag & OPOST;
		(void)ioctl(0, TCSETAW,&noterm);
	}
}

/*
 * Receive SIGPOLL from the remote file descriptor.
 */
/*ARGSUSED*/
#ifdef TWO_PROCS
reader()
#else
reader(sig)
#endif /* TWO_PROCS */
{
	char rb[BUFSIZ];
	register int cnt;
	int flags;
	extern t_errno, errno;
	int again, bcnt;

#ifndef TWO_PROCS
	sighold(SIGPOLL);
#endif
	bcnt = 0;
	for (;; t_errno = flags = 0, bcnt++) {
		again = 0;
Retry:		cnt = t_rcv(rem, rb, sizeof(rb), &flags);
		/*
		 * A zero length read with the expedited data indication
		 * signals that there is urgent data.
		 */
		if ((flags & T_EXPEDITED) && (cnt == 0)) {
			oobflag++;
			continue;
		}
#ifdef t_rcv
		if (cnt == 0 || (cnt < 0 && errno == EAGAIN))
#else
		if (cnt == 0 || (cnt < 0 && t_errno == TNODATA))
#endif /* t_rcv */
			break;
		if (cnt < 0) {
			if (again == 0) {
				again++;
				goto Retry;
			}
			prf("Connection closed..");
#ifdef TWO_PROCS
			break;
#else
			done();
#endif /* TWO_PROCS */
			/* NOTREACHED */
		}
		/*
		 * A non-zero length read with the expedited data indication
		 * set, signifies urgent data.  Note rlogin only sends one byte
		 * of urgent data at a time, but there may be several bytes
		 * buffered up by the time we see it.  Conceivably, there may
		 * be data preceding the byte we are interested in, and
		 * conceivably, there may be one or more buffers of data
		 * preceding the byte we want.  It the latter is true, we
		 * would be hard pressed to distinguish the case without
		 * doing local buffering of data and reading ahead in the
		 * next buffer.
		 */
		if (flags & T_EXPEDITED) {
			char	*oobptr = rb;

			if (cnt > oobflag) {
				(void)write(1, rb, cnt-oobflag);
				oobptr += cnt - oobflag;
				cnt = oobflag;
			}
			while ((oobflag) && (cnt)) {
				oob(oobptr);
				oobptr++;
				oobflag--;
				cnt--;
			}
		}
		else
			(void)write(1, rb, cnt);
		if (bcnt > 0) {	/* check for chars from tty */
			fcntl(0, F_SETFL, stdinfl+O_NDELAY);
			if (read(0, rb, 1) == 1)
				wrtch(rb[0]);
			fcntl(0, F_SETFL, stdinfl);
		}
	}
#ifndef TWO_PROCS
	(void)sigrelse(SIGPOLL);
#else /* TWO_PROCS */
	(void)kill(Parent, SIGHUP);
#endif
}

mode(f)
{
	struct termio sb;

	switch (f) {

	case 0:
		sb = defterm;
		break;

	case 1:
		sb = noterm;
		break;

	default:
		return;
	}
	ioctl(0,TCSETAW,&sb);
}

/*VARARGS*/
prf(f, a1, a2, a3)
	char *f;
{
	fprintf(stderr, f, a1, a2, a3);
	fprintf(stderr, CRLF);
}

lostpeer()
{
	signal(SIGPIPE, SIG_IGN);
	prf("\007Connection closed.");
	done();
}
reset(sig){
	defterm.c_lflag |= ECHO|ECHOE|ECHOK;
	ioctl(0,TCSETAW,&defterm);
	exit(sig);
}
