#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)tftp.c (TWG)  1.1     89/05/17 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/*
 * TFTP User Program -- Protocol Machines
 */
#include <sys/types.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/inet.h>
#include <sys/socket.h>

#include <sys/in.h>
#include <sys/ip.h>
#include <sys/udp.h>

#include <arpa/tftp.h>

#include <signal.h>
#include <stdio.h>
#include <errno.h>
#include <setjmp.h>
#include <tiuser.h>

extern	int errno;
extern	struct sockaddr_in sin;
extern	char mode[];
extern	int	f;
extern	int	trace;
extern	int	verbose;
extern	int	connected;
char	buf[SEGSIZE + 4];
extern	int	rexmtval;
extern	int	maxtimeout;
int	timeout;
extern	jmp_buf	toplevel;
jmp_buf	timeoutbuf;

timer()
{
	timeout += rexmtval;
	if (timeout >= maxtimeout) {
		printf("Transfer timed out.\n");
		longjmp(toplevel, -1);
	}
	signal(SIGALRM, timer);
	longjmp(timeoutbuf, 1);
}

/*
 * Send the requested file.
 */
sendfile(fptr, name)
	FILE *fptr;
	char *name;
{
	register struct tftphdr *tp = (struct tftphdr *)buf;
	register int block = 0, size, n, amount = 0;
	struct sockaddr_in from, to;
	time_t start = time(0), delta;
	int fromlen;
	struct t_unitdata unitdata;
	int flags;

	to = sin;
	unitdata.udata.buf = buf;
	unitdata.addr.len = UDP_BINDADDRLEN;
	unitdata.addr.maxlen = UDP_BINDADDRLEN;
	unitdata.opt.buf = (char *) 0;
	unitdata.opt.len = unitdata.opt.maxlen = 0;
	(void) signal(SIGALRM, timer);
	do {
		if (block == 0)
			size = makerequest(WRQ, name) - 4;
		else {
			size = nvtread(fptr, tp->th_data, SEGSIZE, mode);
			if (size < 0) {
				nak(errno + 100);
				break;
			}
			tp->th_opcode = htons((u_short)DATA);
			tp->th_block = htons((u_short)block);
		}
		timeout = 0;
		(void) setjmp (timeoutbuf);
		unitdata.udata.len = size+4;
		unitdata.addr.buf = (char *)&to;
		/* n = sendto(f, buf,size+4, 0, (caddr_t)&sin, sizeof (sin));*/
		n = t_sndudata (f, &unitdata);
		if ((n < 0) || (n = unitdata.udata.len) != size + 4) {
			perror("tftp: sendto");
			goto abort;
		}
		if (trace)
			tpacket("sent", tp, size + 4);
		do {
			(void) alarm(rexmtval);
			do {
				fromlen = sizeof (from);
				unitdata.addr.buf = (char *)&from;
				unitdata.addr.maxlen = fromlen;
				unitdata.udata.maxlen = sizeof(buf);
				if (t_rcvudata(f, &unitdata, &flags) < 0){
					WIN_error("t_rcvudata");
					alarm(0);
					goto abort;
				}
				n = unitdata.udata.len;
				/*n = recvfrom(f, buf, sizeof (buf), 0,
				    (caddr_t)&from, &fromlen); */
				if(from.sin_addr.s_addr != to.sin_addr.s_addr)
					n = 0;
			} while (n == 0);
			alarm(0);
			if (n < 0) {
				WIN_error("tftp: recvfrom");
				goto abort;
			}
			if (trace)
				tpacket("received", tp, n);
			/* 
			 * Verify that it came from the right port.
			 */
			if (block == 0)
				to.sin_port = from.sin_port;
			else if (to.sin_port != from.sin_port)
				continue;
			tp->th_opcode = ntohs(tp->th_opcode);
			tp->th_block = ntohs(tp->th_block);
			if (tp->th_opcode == ERROR) {
				printf("Error code %d: %s\n", tp->th_code,
					tp->th_msg);
				goto abort;
			}
		} while (tp->th_opcode != ACK || block != tp->th_block);
		if (block > 0)
			amount += size;
		block++;
	} while (size == SEGSIZE || block == 1);
abort:
	(void) fclose(fptr);
	if (verbose && amount > 0) {
		delta = time(0) - start;
		printf("Sent %d bytes in %d seconds.\n", amount, delta);
	}
}

/*
 * Receive a file.
 */
recvfile(fptr, name)
	FILE *fptr;
	char *name;
{
	register struct tftphdr *tp = (struct tftphdr *)buf;
	register int block = 1, n, size, amount = 0;
	struct sockaddr_in from, to;
	time_t start = time(0), delta;
	int fromlen, firsttrip = 1;
	struct t_unitdata unitdata;
	int flags;

	unitdata.udata.buf = buf;
	unitdata.addr.len = UDP_BINDADDRLEN;
	unitdata.addr.maxlen = UDP_BINDADDRLEN;
	unitdata.opt.buf = (char *) 0;
	unitdata.opt.len = unitdata.opt.maxlen = 0;
	to = sin;
	signal(SIGALRM, timer);
	do {
		if (firsttrip) {
			size = makerequest(RRQ, name);
			firsttrip = 0;
		} else {
			tp->th_opcode = htons((u_short)ACK);
			tp->th_block = htons((u_short)(block));
			size = 4;
			block++;
		}
		timeout = 0;
		(void) setjmp(timeoutbuf);
		/*if (sendto(f, buf, size, 0, (caddr_t)&sin,
		    sizeof (sin)) != size) */
		unitdata.udata.len = size;
		unitdata.addr.buf = (char *)&to;
		if (t_sndudata (f,  &unitdata) < 0 ||
		    unitdata.udata.len != size)
		{
			alarm(0);
			WIN_error("tftp: t_sndudata");
			goto abort;
		}
		if (trace)
			tpacket("sent", tp, size);
		do {
			alarm(rexmtval);
			do {
				fromlen = sizeof(from);
				unitdata.addr.buf = (char *)&from;
				unitdata.addr.maxlen = fromlen;
				unitdata.udata.maxlen = sizeof(buf);
				if (t_rcvudata(f, &unitdata, &flags) < 0) {
					WIN_error("t_rcvudata");
				}
				n = unitdata.udata.len;
				if (from.sin_addr.s_addr != to.sin_addr.s_addr)
					n = 0;
			} while (n == 0);
			alarm(0);
			if (n < 0) {
				perror("tftp: t_rcvudata");
				goto abort;
			}
			if (trace)
				tpacket("received", tp, n);
			/*
			 * Verify that the file transfer is taking
			 * place from the right port.
			 */
			if (block <= 1)
				to.sin_port = from.sin_port;
			else if (to.sin_port != from.sin_port)
				continue;
			tp->th_opcode = ntohs(tp->th_opcode);
			tp->th_block = ntohs(tp->th_block);
			if (tp->th_opcode == ERROR) {
				printf("Error code %d: %s\n", tp->th_code,
					tp->th_msg);
				goto abort;
			}
		} while (tp->th_opcode != DATA || block != tp->th_block);
		size = nvtwrite(fptr, tp->th_data, n - 4, mode);
		if (size < 0) {
			nak(errno + 100);
			break;
		}
		amount += size;
	} while (size == SEGSIZE);
abort:
	nvtwflush(fptr, mode);
	tp->th_opcode = htons((u_short)ACK);
	tp->th_block = htons((u_short)block);
	unitdata.udata.len = 4;
	unitdata.addr.buf = (char *)&to;
	t_sndudata(f, &unitdata);
	if (trace)
		tpacket("sent", tp, 4);
	(void) fclose(fptr);
	if (verbose && amount > 0) {
		delta = time(0) - start;
		printf("Received %d bytes in %d seconds.\n", amount, delta);
	}
}

makerequest(request, name)
	int request;
	char *name;
{
	register struct tftphdr *tp;
	int size;
	register char *cp;

	nvtinit();
	tp = (struct tftphdr *)buf;
	tp->th_opcode = htons((u_short)request);
#ifndef vax
	strcpy(((struct TFtphdr *)tp)->th_stuff, name);
	cp = ((struct TFtphdr *)tp)->th_stuff + strlen(name);
#else
	strcpy(tp->th_stuff, name);
	cp = tp->th_stuff + strlen(name);
#endif
	*cp++ = '\0';
	strcpy(cp, mode);
	cp += strlen (mode);
	*cp++ = '\0';
	return (cp - buf);
}

struct errmsg {
	int	e_code;
	char	*e_msg;
} errmsgs[] = {
	{ EUNDEF,	"Undefined error code" },
	{ ENOTFOUND,	"File not found" },
	{ EACCESS,	"Access violation" },
	{ ENOSPACE,	"Disk full or allocation exceeded" },
	{ EBADOP,	"Illegal TFTP operation" },
	{ EBADID,	"Unknown transfer ID" },
	{ EEXISTS,	"File already exists" },
	{ ENOUSER,	"No such user" },
	{ -1,		0 }
};

/*
 * Send a nak packet (error message).
 * Error code passed in is one of the
 * standard TFTP codes, or a UNIX errno
 * offset by 100.
 */
nak(error)
	int error;
{
	register struct tftphdr *tp;
	int length;
	register struct errmsg *pe;
	extern char *sys_errlist[];
	struct t_unitdata unitdata;

	tp = (struct tftphdr *)buf;
	tp->th_opcode = htons((u_short)ERROR);
	tp->th_code = htons((u_short)error);
	for (pe = errmsgs; pe->e_code >= 0; pe++)
		if (pe->e_code == error)
			break;
	if (pe->e_code < 0)
		pe->e_msg = sys_errlist[error - 100];
	strcpy(tp->th_msg, pe->e_msg);
	length = strlen(pe->e_msg) + 4;
	if (trace)
		tpacket("sent", tp, length);

	unitdata.udata.buf = buf;
	unitdata.udata.len = length;
	unitdata.opt.buf = (char *) 0;
	unitdata.opt.len = 0;
	unitdata.addr.len = UDP_BINDADDRLEN;
	unitdata.addr.buf = (char *)&sin;
	t_sndudata(f, &unitdata);
	/*if (send(f, &sin, buf, length) != length) */
	if (unitdata.udata.len != length)
		perror("nak");
}

tpacket(s, tp, n)
	struct tftphdr *tp; 
	int n;
{
	static char *opcodes[] =
	   { "#0", "RRQ", "WRQ", "DATA", "ACK", "ERROR" };
	register char *cp, *file;
	u_short op = ntohs(tp->th_opcode);
	char *index();
	tp = (struct tftphdr *)buf;

	if (op < RRQ || op > ERROR)
		printf("%s opcode=%x ", s, op);
	else
		printf("%s %s ", s, opcodes[op]);
	switch (op) {

	case RRQ:
	case WRQ:
		n -= 2;
#ifndef vax
		file = cp = ((struct TFtphdr *)tp)->th_stuff;
#else
		file = cp = tp->th_stuff;
#endif /* vax */
		cp = index(cp, '\0');
		printf("<file=%s, mode=%s>\n", file, cp + 1);
		break;

	case DATA:
		printf("<block=%d, %d bytes>\n", ntohs(tp->th_block), n - 4);
		break;

	case ACK:
		printf("<block=%d>\n", ntohs(tp->th_block));
		break;

	case ERROR:
		printf("<code=%d, msg=%s>\n", ntohs(tp->th_code), tp->th_msg);
		break;
	}
}
/*
 * Routines to convert ascii characters to standard NVT specifications.
 * LF is converted to CR LF when writing to the network, and vice versa.
 */
static	int nvtholdlf;	/*flag=1 if building CRLF for output and CR generated*/
static	int nvtcrseen;	/*flag=1 if last char rcvd is a CR */

nvtinit()
{
nvtholdlf = 0;
nvtcrseen = 0;
}

nvtread(fdes, buffr, bsize, xfrmode)
	FILE *fdes;	/* file descriptor to read from */
	char *buffr;	/* buffer into which the data is to be placed */
	int bsize;	/* buffer size in bytes, must be > 0 */
	char *xfrmode;	/* type of transfer, netascii or octet */
{
	if (strcmp(xfrmode, "octet") == 0) {
		return fread(buffr, sizeof (char), bsize, fdes);
	} else {
		register char *bp, *ebp;
		register char c;
		bp = buffr;
		ebp = bp + bsize;
		while (bp != ebp) {
			if (nvtholdlf != 0) {
				nvtholdlf = 0;
				*bp++ = '\n';
			} else {
				c = getc(fdes);
				if (feof(fdes) || ferror(fdes))
					return (int)(bp-buffr);
				if (c == '\n') {
					*bp++ = '\r';
					nvtholdlf = 1;
				} else *bp++ = c;
			}
		}
		return bsize;
	}
}

nvtwflush(fdes, xfrmode)
FILE *fdes;	/* file descriptor to write to */
char *xfrmode;	/* type of transfer, netascii or octet */
{
	if ((nvtcrseen == 1) && (strcmp(xfrmode, "octet") != 0))
		putc('\r', fdes);
}

nvtwrite(fdes, buffr, bsize, xfrmode)
FILE *fdes;	/* file descriptor to write to */
char *buffr;	/* buffer from which the data is to be taken */
int bsize;	/* buffer size in bytes, must be > 0 */
char *xfrmode;	/* type of transfer, netascii or octet */
{
	if (strcmp(xfrmode, "octet") == 0) {
		fwrite(buffr, sizeof (char), bsize, fdes);
		return bsize;
	} else {
		register char *bp, *ebp;
		register char c;
		bp = buffr;
		ebp = bp + bsize;
		while (bp != ebp) {
			c = *bp++;
			switch (c) {
			case '\n':
				nvtcrseen = 0;
				putc('\n', fdes);
				break;
			case '\r':
				if (nvtcrseen != 0) putc('\r', fdes);
				   else nvtcrseen = 1;
				break;
			default:
				if (nvtcrseen != 0) {
					nvtcrseen = 0;
					putc('\r', fdes);
				}
				putc(c, fdes);
			}
		}
		return bsize;
	}
}
