#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)shpasswd.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 *	COMMKIT(TM) Software - Datakit(R) VCS Interface Release
 *			Copyright 1984 AT&T
 *			All Rights Reserved
 *
 *	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
 *     The copyright notice above does not evidence any actual
 *          or intended publication of such source code.
 */
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include	<sys/types.h>
#include	<pwd.h>
#include	<stdio.h>
#include	<sys/stat.h>

#ifdef	SHADOW
#undef	SHADOW
#include	<shadow.h>
#endif

#ifdef	SHADOW
static	time_t		now;
extern	long		timezone;
static	struct	spwd	*spent;
#endif
static	struct	passwd	*pwent;

#define	WEEK	(24L*7*60*60)	/* 1 week in seconds */

struct passwd	*getpwnam();
struct passwd	*getpwuid();

	struct	passwd	*
shgetpwnam(name)
	char	*name;
{
#ifdef	SHADOW
	if (isshadow()) {
		if ( ( (pwent = getpwnam(name) ) == NULL) || 
		     ( (spent = getspnam(name) ) == NULL) )
	    		return(NULL);

		pwent->pw_passwd = spent->sp_pwdp;
		return(pwent);
	} else
#endif
		return(getpwnam(name));
}

	struct	passwd	*
shgetpwuid(uid)
	int	uid;
{
#ifdef	SHADOW
	if (isshadow()) {
		if ( ( (pwent = getpwuid(uid) ) == NULL) || 
		     ( (spent = getspnam(pwent->pw_name) ) == NULL) )
	    		return(NULL);

		pwent->pw_passwd = spent->sp_pwdp;
		return(pwent);
	} else
#endif
		return(getpwuid(uid));
}

shpwexpired(pwent)
	struct passwd	*pwent;
{
	int		len;

	len = strlen(pwent->pw_passwd);

	if(len != 0 && len != 13)
		return(1);		/* fake password */

#ifdef	SHADOW
	if (isshadow()) {
		now = DAY_NOW;
		if ( (spent->sp_lstchg == 0) ||
		     (spent->sp_lstchg > now) ||
		     ( (spent->sp_max >= 0) &&
		       (now > (spent->sp_lstchg + spent->sp_max)) &&
		       (spent->sp_max >= spent->sp_min))) {
			return(1);
		}
	} else 
#endif
		if (*pwent->pw_age){
			long	time(), a64l();
			long	when, now, minweeks, maxweeks;

			when = a64l(pwent->pw_age);
			maxweeks = when & 077;
			minweeks = (when >> 6) & 077;
			when >>= 12;
			now = time((long *)0)/WEEK;

			if ((now > when + maxweeks) && (maxweeks >= minweeks))
				return(1);
		}

	return(0);
}

#ifdef	SHADOW
	static
isshadow()
{
	static	int	shadow = -1;
	struct	stat	statbuf;

	if (shadow < 0) {
		return(shadow = stat(SHADOW, &statbuf) == 0);
	} else
		return(shadow);
}
#endif
