#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)rlogind.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */
/* Fix Log
 *
 * TWU	04/29/91	Change process type to INIT_PROCESS instead of 
 *			EMPTY when doing utmp log.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/inet.h>
#include <sys/stat.h>
#include <sys/tty_pty.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/tiuser.h>
#include <sys/socket.h>

#include <sys/in.h>

#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <fcntl.h>
#include <termio.h>
#include <sys/inetioctl.h>
#include <stdio.h>
#include <netdb.h>
#include <utmp.h>
#include <syslog.h>

/* External Declarations */
extern char *sys_errlist[];

/* Forward Procedure Declarations */
char	*ntoa();
int	cleanup();

/* Global ints and pointers */

int	net_fd;
int	pty_fd;
char	*line;
int	catch_flag = 0;

#ifdef DEBUG
FILE	*file;
#define trace(x,y,z)  {fprintf(x,y,z);fflush(x);}
#else
#define trace(x,y,z)  {}
#endif /* DEBUG */

/*
 * remote login server:
 *	remuser\0
 *	locuser\0
 *	terminal type\0
 *	data
 */
main(argc, argv)
	int argc;
	char **argv;
{
	struct sockaddr_in from;
	int fromlen = sizeof(from);

#ifdef DEBUG
	file = fopen("/tmp/rloglog", "a+");
	fprintf(file,"main: af opening /tmp/rloglog, file=0x%x\n",file);
	fflush(file);
#endif /* DEBUG */
	setpgrp();
	getpeername(0, &from, &fromlen);
	doit(0, &from);
}

/*
 * We got an ASYNC notification of data available on the network.
 */
void
sig_poll(sig)
	int		sig;
{
	int		cc;
	int		flags;
	int		fcc = 0;
	static char	*fbp;
	static char	fibuf[1024];

	sighold(SIGPOLL);
	/*
	 * Read from the FD.
	 */
	for(;;){
try_again:
		fcc = read(net_fd, fibuf, sizeof (fibuf));
		if (fcc < 0 && errno == EAGAIN)
			break;
		else if (fcc < 0 && errno == EINTR)
			goto try_again;
		else {
			if (fcc == 0 || (fcc <0 && errno == ENXIO)){
				WIN_error("Lost Remote.");
				cleanup();
				/* NOTREACHED */
			}
			fbp = fibuf;
		}
#ifdef DEBUG
		{ 
		int	i; 
		char	*cp;

		fprintf( file, "writing to master pty: ");
		for ( i = 0, cp = fbp; i < fcc; i++, cp++) 
			fprintf(file,"%x ", *cp);
		fprintf( file, "\n");
		fflush( file);
		}
#endif /* DEBUG */
		cc = write(pty_fd, fbp, fcc);
		if (cc > 0) {
			fcc -= cc;
			fbp += cc;
		}
	}
	sigrelse(SIGPOLL);
}

rlogind( f, p )
	int f;
	int p;
{
	int		cc;
	int		pcc = 0;
	char		*pbp;
	static char	pibuf[1024];

	signal(SIGCLD, cleanup);
	fcntl(f, F_SETFL, O_NDELAY);
	ioctl(f, I_SETSIG, S_INPUT);
	net_fd = f;
	pty_fd = p;
	sigset(SIGPOLL, sig_poll);
	trace(file, "Reading from net..\n",0);
	sig_poll(SIGPOLL);	/* Pretend that we just got a signal */

	trace(file, "Reading from PTY..\n",0);
	for (;;) {
		pcc = read(p, pibuf, sizeof (pibuf));
		trace(file, "read %d \n", pcc);
		pbp = pibuf;
		if (pcc < 0 && errno == EINTR)
			pcc = 0;
		else if (pcc <= 0){
			/* We should go away. */
			
			pcc = -1;
			break;
		}
#ifdef notdef
		else if (pibuf[0] == 0)
			pbp++, pcc--;
		else {
			if (pibuf[0]&(TIOCPKT_FLUSHWRITE|
				      TIOCPKT_NOSTOP| TIOCPKT_DOSTOP)) {
				int nstop = pibuf[0] &
				    (TIOCPKT_NOSTOP| TIOCPKT_DOSTOP);
				if (nstop)
					stop = nstop;
				pibuf[0] |= nstop;
				t_snd(f, &pibuf[0], 1, T_EXPEDITED);
			}
			pcc = 0;
		}
#endif
		if (pcc > 0){
try_write_again:
			if ((cc = write(f, pbp, pcc)) < 0) {
				if (errno == EINTR)
					goto try_write_again;
				if (errno != EAGAIN)
					cleanup();
				else {
					sleep (1);
					goto try_write_again;
				}
			}
			
		}
		if (cc > 0) {
			pcc -= cc;
			pbp += cc;
		}
	}
	cleanup();

}

doit(f, fromp)
	int f;
	struct sockaddr_in *fromp;
{
	char	c;
	int	i;
	int	p;
	int	t;
	int	pid;
	int	stop = TIOCPKT_DOSTOP;
	struct hostent *hp;
	struct termio b;
	void catch();

	alarm(60);
	read(f, &c, 1);
	if (c != 0){
		exit(1);
	}
	alarm(0);
	hp = gethostbyaddr(&fromp->sin_addr, sizeof (struct in_addr),
		fromp->sin_family);
	if (hp == 0) {
		char *cp = (char *)&fromp->sin_addr;
		char buf[BUFSIZ];

		(void) sprintf(buf, "Host name for your address (%s) unknown",
			ntoa(fromp->sin_addr.s_addr));
		fatal(f, buf);
	}
	if ( ntohs(fromp->sin_port) >= IPPORT_RESERVED)
		fatal(f, "Permission denied");
	write(f, "", 1);
	for (i = 0 ; i <= 999 ; i++) {
		struct stat stb;
		line = "/dev/ptypXXX";
		sprintf(&line[9], "%.3d", i);
#ifdef DEBUG
		syslog(LOG_DEBUG, "trying %s\n", line);
#endif
		if (stat(line, &stb) < 0)
			break;
#ifdef DEBUG
		syslog(LOG_DEBUG, "trying to open %s\n", line);
#endif
		p = open(line, O_RDWR /*|O_NDELAY*/);
		if (p >= 0)
			goto gotpty;
	}
	fatal(f, "All network pseudo-tty ports in use");
	/*NOTREACHED*/
gotpty:
	/* dup2(f, 0); */
	line[5] = 't';	/* /dev/ptyp0 ==> /dev/ttyp0 */

	signal(SIGINT,SIG_IGN);	/* Ignore Keyboard signals */
	signal(SIGQUIT,SIG_IGN);

	sigset(SIGUSR1, catch);
	sighold(SIGUSR1);
	pid = fork();

	if (pid < 0)
		fatalperror(f, "", errno);
	if (pid) {
		while (!catch_flag) 
			sigpause(SIGUSR1);
		rlogind( f, p );
	}

	/*
	 * In the child, exec netlogin or /bin/login
	 */
	setpgrp();
	t = open(line, O_RDWR/*|O_NDELAY*/);
	if (t < 0)
		fatalperror(f, line, errno);

	ioctl(t,TCGETA,&b);
#ifdef DEBUG
	fprintf(file,"c_iflag %o\n", b.c_iflag);
	fprintf(file,"c_oflag %o\n", b.c_oflag);
	fprintf(file,"c_cflag %o\n", b.c_cflag);
	fprintf(file,"c_lflag %o\n", b.c_lflag);
	fprintf(file,"c_line %o\n", b.c_line);
	fflush(file);
#endif /* DEBUG */
	/* b.c_cc[VMIN]=1; b.c_cc[VTIME]= -1;*/
	b.c_iflag = IGNPAR|ISTRIP;
	b.c_lflag = 0;
	b.c_cflag = EXTB|HUPCL|CS8;
	ioctl(t,TCSETA,&b);

	close(f);	/* Close socket */
	close(p);	/* ptyp0 */
	dup2(t, 0);	/* ttyp0 */
	dup2(t, 1);
	dup2(t, 2);
	close(t);

	signal(SIGCLD,SIG_DFL);
	kill(getppid(), SIGUSR1);
#ifdef DEBUG
	fprintf(file,"main: b4 exec/usr/etc/netlogin\n");
	fflush(file);
#endif /* DEBUG */
	execl("/usr/etc/netlogin","login","-r",hp->h_name,0);
	execl("/bin/login", "login", "-r", hp->h_name, 0);
	fatalperror(2, "login", errno);
	/*NOTREACHED*/
}

cleanup()
{

	rmut();
	/*
	 * Instead of vhangup(), just send SIGHUP to
	 * my process group
	 */
	kill(0,SIGHUP);
	kill(-getpid(), SIGHUP);
	wait(0);	/* So that the Zombie will go away */
	exit(1);
}

fatal(f, msg)
	int f;
	char *msg;
{
	char buf[BUFSIZ];

	buf[0] = '\01';		/* error indicator */
	(void) sprintf(buf + 1, "rlogind: %s.\r\n", msg);
	(void) write(f, buf, strlen(buf));
	exit(1);
}

fatalperror(f, msg, errno)
	int f;
	char *msg;
	int errno;
{
	char buf[BUFSIZ];

	(void) sprintf(buf, "%s: %s", msg, sys_errlist[errno]);
	fatal(f, buf);
}


struct	utmp wtmp;

#ifdef SYSTEM5
char	wtmpf[]	= WTMP_FILE;
#else
#ifdef USG
char	wtmpf[]	= "/etc/wtmp";
#else
char	wtmpf[]	= "/usr/adm/wtmp";
#endif /* USG */
#endif /* SYSTEM5 */

#ifdef SYSTEM5
char	utmpf[] = UTMP_FILE;
#else
char	utmp[] = "/etc/utmp";
#endif /* SYSTEM5 */

#define SCPYN(a, b)	strncpy(a, b, sizeof(a))
#define SCMPN(a, b)	strncmp(a, b, sizeof(a))

rmut()
{
	register f;
	int found = 0;

	f = open(utmpf, O_RDWR );
	if (f >= 0) {
		while(read(f, (char *)&wtmp, sizeof(wtmp)) == sizeof(wtmp)) {
#if defined(SYSTEM5) && !defined(ARIX)
			if (strncmp(wtmp.ut_line, line+5,7) || wtmp.ut_name[0]==0)
#else
			if (SCMPN(wtmp.ut_line, line+5) || wtmp.ut_name[0]==0)
#endif /* SYSTEM5 */
				continue;
			lseek(f, -(long)sizeof(wtmp), 1);
			SCPYN(wtmp.ut_name, "");
#ifdef BSD
			SCPYN(wtmp.ut_host, "");
#endif /* BSD */
#ifdef SYSTEM5
/* TWU 04/29/91	Changing type to INIT_PROCESS instead of EMPTY to make
   login util happy
			wtmp.ut_type = EMPTY;
*/
			wtmp.ut_type = INIT_PROCESS;
#endif /* SYSTEM5 */
			time(&wtmp.ut_time);
			write(f, (char *)&wtmp, sizeof(wtmp));
			found++;
		}
		close(f);
	}
	if (found) {
		f = open(wtmpf, O_WRONLY );
		if (f >= 0) {
			SCPYN(wtmp.ut_line, line+5);
			SCPYN(wtmp.ut_name, "");
#ifdef BSD
			SCPYN(wtmp.ut_host, "");
#endif /* BSD */
			time(&wtmp.ut_time);
			lseek(f, (long)0, 2);
			write(f, (char *)&wtmp, sizeof(wtmp));
			close(f);
		}
	}
	chmod(line, 0666);
	chown(line, 0, 0);
	line[strlen("/dev/")] = 'p';
	chmod(line, 0666);
	chown(line, 0, 0);
}

/*
 * Convert network-format internet address
 * to base 256 d.d.d.d representation.
 */
char *
ntoa(in)
	struct in_addr in;
{
	static char b[18];
	register char *p;

	p = (char *)&in;
#define	UC(b)	(((int)b)&0xff)
	sprintf(b, "%d.%d.%d.%d", UC(p[0]), UC(p[1]), UC(p[2]), UC(p[3]));
	return (b);
}

void
catch(sig)
{
	catch_flag = 1;
}
