#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)sysv_glue.c (TWG)  1.2     89/06/29 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/* sysv_glue.c - taken from ../lib/nsyslog.c, unsetenv written by vixie
 * vix 23dec87 [written]
 */

#ifdef SYSTEM5

#include <stdio.h>
#include <syslog.h>
#include <sys/types.h>
#include <fcntl.h>

#define LOG_TO_STDOUT 0
#define VIXDBG 0

#ifdef notdef
/*
 * Not needed in WIN/TCP 4.0
 */

/*
**  SYSLOG -- print message on log file
**
**	This routine looks a lot like printf, except that it
**	outputs to the log file instead of the standard output.
**	Also, it prints the module name in front of lines,
**	and has some other formatting types (or will sometime).
**	Also, it adds a newline on the end of messages.
**
**	Parameters:
**		pri -- the message priority.
**		fmt -- the format string.
**		p0 -- the first of many parameters.
**
**	Returns:
**		none
**
**	Side Effects:
**		output to log.
*/

#define MAXLINE		1000		/* maximum line length */
#define BUFSLOP		20		/* space to allow for "extra stuff" */
#define NULL		0		/* manifest */

static int	SyslogFile	= -1;		/* fd for log */
static int	SyslogStat	= 0;		/* status bits; see below */
static char	*SyslogTag	= NULL;		/* tag for each entry */

syslog(pri, fmt, p0, p1, p2, p3, p4)
	int pri;
	char *fmt;
{
	char buf[MAXLINE+BUFSLOP];
	register char *b;
	char *f;
	int prec;
	int len;
	register char c;
	register char *p;
	int i;
	extern int errno;
	extern int sys_nerr;
	extern char *sys_errlist[];
	extern char *logcvt();
	char outline[MAXLINE + 1];
	char *timestr, *ctime();
	long ltime;

	/* if we have no log, open it */
	if (SyslogFile < 0)
		openlog(0, 0);

	f = fmt;

	while (*f != '\0')
	{
		/* beginning of line */
		b = buf;

		/* time stamp */
		time(&ltime);
		timestr = ctime(&ltime);
		timestr[19] = '\0';
		b += sprintf(b, "%s ", &timestr[4]);

		/* output current process ID */
		if ((SyslogStat & LOG_PID) != 0)
			b += sprintf(b, "[%d] ", getpid());

		while ((c = *f++) != '\0' && c != '\n')
		{
			/* output character directly if not interpolated */
			if (c != '%')
			{
				*b++ = c;
				continue;
			}
			c = *f++;
			switch (c)
			{
			  case 'm':	/* output error code */
				if (errno < 0 || errno > sys_nerr)
					b += sprintf(b, "error %d", errno);
				else
					b += sprintf(b, "%s", sys_errlist[errno]);
				break;

			  default:
				*b++ = '%';
				*b++ = c;
				*b = '\0';
				break;
			}
			if (b >= &buf[MAXLINE])
				break;
		}
		if (c == '\0')
			f--;

		/* add trailing newline */
		*b++ = '\n';
		*b = '\0';
		
		/* output string */
		sprintf(outline, buf, p0, p1, p2, p3, p4);
		write(SyslogFile, outline, strlen(outline));
	}
}
/*
**  OPENLOG -- open system log
**
**	This happens automatically with reasonable defaults if you
**	do nothing.
**
**	Parameters:
**		ident -- the name to be printed as a header for
**			all messages.
**		logstat -- a status word, interpreted as follows:
**			LOG_PID -- log the pid with each message.
**
**	Returns:
**		0 -- success.
**		-1 -- failure; logging on /dev/console instead.
**
**	Side Effects:
**		Several global variables get set.
*/

openlog(ident, logstat)
	char *ident;
	int logstat;
{
	register int i;
	register int fd;

	SyslogTag = ident;
	SyslogStat = logstat;

	if (SyslogFile >= 0)
		return;
#if LOG_TO_STDOUT
	SyslogFile = 1;
	return;
#endif
	SyslogFile = open("/usr/spool/mqueue/syslog",
			O_WRONLY|O_APPEND|O_CREAT, 0666);
	if (SyslogFile < 0)
	{
	  nolog:
		SyslogFile = open("/dev/console", 1);
		if (SyslogFile < 0)
		{
			perror("syslog: cannot open /dev/console");
			SyslogFile = 2;
		}
	}
}
/*
**  CLOSELOG -- close the system log
**
**	Parameters:
**		none.
**
**	Returns:
**		none.
**
**	Side Effects:
**		The system log is closed.
*/

closelog()
{
	(void) close(SyslogFile);
	SyslogFile = -1;
}
#endif

#if !VIXDBG
# define printenv(foo)
#else
static void
printenv(label)
	char *label;
{
	extern char **environ;
	char **p;

	fprintf(stderr, "printenv(%s)...\n", label);
	for (p = environ;  *p;  p++)
		fprintf(stderr, "\t%s\n", *p);
}
#endif

void
unsetenv(v)
	char *v;
{
	extern char **environ;
	char **p, **q;

	printenv("before unsetenv");
	for (p = q = environ;  *p;  p++) {
		if (strtcmp(*p, v, '=')) {
			*q++ = *p;
		}
	}
	*q = (char *) 0;
	printenv("after unsetenv");
}

static int
strtcmp(l, r, t)
	char *l, *r;
	char t;
{
	while (*l && *r && *l != t && *r != t && *l == *r)
		l++, r++;
	if (*l == t) *l = '\0';
	if (*r == t) *r = '\0';
	if (*l < *r)
		return -1;
	if (*l > *r)
		return 1;
	return 0;
}

#endif /* SYSTEM5 */
