#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)tcplisten.c (TWG)  1.8     89/09/26 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/*
 * General Purpose listener For TCP
 */
#include <sys/types.h>
#include <sys/param.h> /* This has NOFILE in it */
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/ip.h>
/*#include <sys/tcp.h>	/* Pull in TCP_BINDADDRLEN */
#include <sys/signal.h>
#include <sys/errno.h>
#include <sys/in.h>
#include <stdio.h>
#include <fcntl.h>
#include <termio.h>
#include <tiuser.h>
#include <netdb.h>
#include <sys/poll.h>
#include <syslog.h>

extern	int errno, t_errno;
struct	sockaddr_in sin;
char *ntoa();

struct cind {
	struct cind *next;
	struct t_call *call;
};

/*
 * Fire up a listen on a bunch of ports
 * Use TLI up to a certain point.
 * When we get a async notification of connect
 * Then accept it. Dup 0 1 2 and fire up the daemon
 */
struct Listen {
	char	*L_service;
	int	L_fds;
	int     L_flags;
	int     L_pos;
	struct	cind *L_cind;
} Listen[15];
#define L_ADD_SERVICE 1
#define L_ALARM_TIME  45
int alarm_time = L_ALARM_TIME;
struct Listen *Lptr[NOFILE];
int pushrdwr = 1;
struct cind *alloc_cind();
void free_cind();
void add_cind();
void del_cind();


main(argc, argv)
     char *argv[];
{
    register int s, pid, options;
    struct servent *sp;
    struct t_bind req;
    register struct Listen *Lp = &Listen[0];
    int c, errflg;
    extern char *optarg;
    extern int optind;

    while ((c=getopt(argc, argv, "pt:")) != -1)
	switch (c) {
	  case 'p':
	    pushrdwr = 0;
	    break;
	  case 't':
	    if ((alarm_time = atoi(optarg)) <= 0) {
		fprintf (stderr, "tcplisten: invalid time %s\n", optarg);
		errflg++;
		}
	    break;
	  case '?':
	    errflg++;
	    }
    if (errflg || optind == argc) {
	fprintf(stderr, "usage: tcplisten [-t alrm] service1 [service2] ..\n");
	exit(1);
	}
    if (fork())
	exit(0);
    for (s = 0; s < 10; s++)
	(void) close(s);
    /*
     * Save File Descpritors 0 1 2
     */
    /*
     * Reserve 0, 1 and 2 for children
     */
    openlog("tcplisten",LOG_PID|LOG_NDELAY,LOG_USER);
    (void) dup2(0, 1);
    (void) dup2(0, 2);
    (void) setpgrp();
    (void) signal(SIGCLD,SIG_IGN); /* The Zombies will then go away */
    (void) signal(SIGINT, SIG_IGN);
    (void) signal(SIGQUIT, SIG_IGN);
    for (;optind < argc; optind++) {
	/*
	 * Add the service requested.
	 */
	if (add_service (Lp, argv[optind]))
	    Lp++;
	}
    Pollfds();
}
/*ARGSUSED*/
gotconnect(Lp) 
	register struct Listen *Lp;
{
	struct sockaddr_in from;
	int s2, fromlen = sizeof (from);
	register int s = Lp->L_fds, pid;
	char Execb[200];
	register struct hostent *hp;
	char *host;
	char Dname[40];
	struct cind *cind = Lp->L_cind, *tmp_cind;

	/*
	 * Accept all pending connection indications for this 
	 * service. If anything goes wrong while accepting a
	 * connection request, the connection indication will
	 * be dropped.  
	 */
	while (cind) 
	{	
		if((s2 = t_open(DEV_TCP, 2, 0)) < 0) {
			syslog(LOG_ERR, "t_open2 failed, t_errno=%d errno=%d",
				t_errno, errno);
dropit:
			tmp_cind = cind->next;
			del_cind(Lp, cind);
			free_cind(cind);
			cind = tmp_cind;
			continue;
		}
		/*
		 * The TLI Spec's tell that the second
		 * endpoint must be bound ( BARF..).
		 */
		if (t_bind(s2, 0, 0) < 0){
			syslog(LOG_ERR, "t_bind2 failed, t_errno=%d errno=%d",
				t_errno, errno);
			t_close(s2);
			goto dropit;
		}
		if (t_accept(s, s2, cind->call) < 0) {

			/**
			 ** check for connection indications coming up to
			 ** the user at the same time
			 ** grab these and accept them later.
			 **/

			if (t_errno == TLOOK){
				if ((tmp_cind = alloc_cind(s)) == NULL) 
					goto dropit;
				if (t_listen(s, tmp_cind->call) < 0) {
					free_cind (tmp_cind);
					syslog (LOG_ERR, 
					"t_listen2 failed t_errno=%d errno=%d",
					t_errno, errno);
					goto dropit;
				}
				add_cind(Lp, tmp_cind);
				/*
				 * try to accept it again 
				 */
				(void)t_close(s2);	/* overkill */
				continue;
			}
			else {
				/*
				 * If we are out of State, TOUTSTATE,
				 * This is a fatal ERROR. Then this
				 * Interface needs to be restarted.
				 * get rid of all pending conn indications.
				 */
				syslog(LOG_ERR, 
				      "t_accept failed, t_errno=%d, errno=%d",
				       t_errno, errno);
				for (cind=Lp->L_cind; cind ; cind=cind->next) {
					del_cind(Lp, cind);
					free_cind(cind);
				}
				(void)t_close(s2);
				return -1;
			}
		}
		if (pid = fork()){
			/*
			 * Remove (drop) this connection request 
			 * from the list, and accept any remaining 
			 * connection requests.
			 */
			(void)t_close(s2);
			goto dropit;
		}
		/*
		 * In the child.
		 */
		closelog();
		dup2(s2, 0); dup2(s2, 1); dup2(s2, 2);
#ifdef notdef
		/*
		 * We set the close on exec flag, so they ought to be closed
		 */
		for (s = 3; s < NOFILE; s++)
			(void)close(s);
#else
		if (s2 > 2) (void) close (s2);
#endif /* notdef */
		openlog("tcplisten",LOG_PID|LOG_NDELAY,LOG_USER);
		/*
		 * POP the TIMOD module from the path
		 * and push in the TIRDWR module.
		 */
		if (pushrdwr){
			if (ioctl(0, I_POP, 0) < 0){
				syslog(LOG_ERR,"Can't I_POP timod(%d)",errno);
				exit(1);
			}
			if (ioctl(0, I_PUSH, "tirdwr") < 0){
				syslog(LOG_ERR,"Can't I_PUSH tirdwr(%d)",errno);
				exit(1);
			}
		}
		getpeername(0, &from, &fromlen);
		from.sin_family = AF_INET;
		hp = gethostbyaddr(&from.sin_addr, sizeof (struct in_addr),
			from.sin_family);
		if (hp)
			host = hp->h_name;
		else
			host = (char *)ntoa(from.sin_addr.s_addr);
		syslog(LOG_INFO,"Connected from %s(%s)",host, Lp->L_service);
		/*
		 * Exec the Daemon associtate with the service.
		 */
		setpgrp();	/* Don't let me send signals to tcplisten */
		strcpy(Dname,Lp->L_service);
		strcat(Dname, "d");
		strcpy(Execb, "/usr/etc/");
		strcat(Execb, Dname);
		execl(Execb, Dname, host, 0);
		/*
		 * Try /etc now
		 */
		strcpy(Execb, "/etc/");
		strcat(Execb, Dname);
		execl(Execb, Dname, host, 0);
		/*
		 * Try /usr/win-etc
		 */
		strcpy(Execb, "/usr/win-etc/");
		strcat(Execb, Dname);
		execl(Execb, Dname, host, 0);
		strcat(Execb, Dname);
		execlp(Execb, Dname, host, 0);
		/*
		 * Can't Find the pgm.
		 */
		syslog(LOG_ERR,"No exec %s", Lp->L_service);
		exit(1);
		/* NOTREACHED */
	}
	return 1;
}

struct pollfd pollfd[NOFILE];

Pollfds()
{
	register int nfds, i, retval;
	register struct Listen *Lp = &Listen[0];
	register struct cind *cind;

	/*
	 * Poll the fds.
	 * When we get a msg (Conn IND) we will return.
	 */
	for (nfds = 0; Lp->L_service; nfds++, Lp++){
		pollfd[nfds].fd = Lp->L_fds;
		pollfd[nfds].events = POLLIN;
	}
	for(;;) {
		if ((retval = poll(pollfd, nfds, -1)) < 0){
			/*
			 * This may be from an ALARM.
			 */
			if (errno == EINTR)
				continue;
			syslog(LOG_ERR,"poll error(%d)", errno);
			sleep(1);
			continue;
		}
		if (retval == 0){
			syslog(LOG_ERR,"Poll returned expired time..");
			sleep(1);
			continue;
		}
		for (i = 0; i < nfds; i++) {
			Lp = &Listen[i];
			if (pollfd[i].revents & POLLIN) {
				/*
				 * Connection Just came in on this baby,
				 * grab the indication.
				 */
				int s = Lp->L_fds;

				if ((cind = alloc_cind(s)) == NULL) {
					pollfd[i].revents = 0;
					pollfd[i].events = POLLIN;
					continue;
				}
				if (t_listen(s, cind->call) < 0) {
					syslog (LOG_ERR, 
					"t_listen failed t_errno=%d errno=%d",
					t_errno, errno);
					free_cind (cind);
					pollfd[i].revents = 0;
					pollfd[i].events = POLLIN;
					continue;
				}
				add_cind(Lp, cind);

				if (gotconnect(Lp) < 0) {
					syslog (LOG_ERR,"%s Reactivating Service",
						Lp->L_service);
					reactivate_service (Lp, i);
				} else {
					pollfd[i].revents = 0;
					pollfd[i].events = POLLIN;
				}
			}
			else if (pollfd[i].revents & POLLERR) {
				pollfd[i].revents &= ~POLLERR;
				syslog(LOG_ERR,
				       "%s poll error reactivating service",
				        Lp->L_service);
				reactivate_service (Lp, i);
				
			}
		}
	}			
}
/*
 * Convert network-format internet address
 * to base 256 d.d.d.d representation.
 */
char *
ntoa(in)
	struct in_addr in;
{
	static char b[18];
	register char *p;

	p = (char *)&in;
#define	UC(b)	(((int)b)&0xff)
	sprintf(b, "%d.%d.%d.%d", UC(p[0]), UC(p[1]), UC(p[2]), UC(p[3]));
	return (b);
}
add_service (Lp, serv)
	char *serv;
	register struct Listen *Lp;
{
	register int s, pid, options;
	struct servent *sp;
	struct t_bind req;

	sp = getservbyname(serv, "tcp");
	if (sp == 0) {
		syslog(LOG_ERR,"%s: unknown service", serv);
		return 0;
	}
	sin.sin_port = sp->s_port;
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	Lp->L_service = serv;
	if((s = t_open(DEV_TCP, O_RDWR, 0)) < 0) {
		syslog (LOG_ERR,"Can't open TCP device");
		return 0;
	}
	req.addr.buf = (char *)&sin;
	req.addr.len = sizeof(sin);
	req.qlen = 12;
	if (t_bind(s, (caddr_t)&req, 0) < 0) {
		syslog (LOG_ERR,"Can't bind to requested service %s", serv);
		(void) t_close (s);
		return 0;
	}
	Lp->L_fds = s;
	Lptr[s] = Lp;
	/*
	 * Set The close on exec flag.
	 */
	(void) fcntl (s, F_SETFD, 1);
	return 1;
}
/*
 * This comes off the alarm clock. It just scans all the L_Service
 * structures, and figures which have to be activated.
 */
/* ARGSUSED */
redo_services (signo)
{
	register struct Listen *Lp;

	for (Lp= &Listen[0]; Lp->L_service; Lp++) {
		if (!(Lp->L_flags & L_ADD_SERVICE))
			continue;
		/*
		 * Try to add this service.
		 */
		reactivate_service (Lp, Lp->L_pos);
	}
	/*
	 * Since this was from a signal, the poll system call
	 * would have returned with EINTR.
	 * In this case the poll structure has already been
	 * set up by reactivate_service.
	 */
}
reactivate_service (Lp, pos)
	register struct Listen *Lp;
{
	if (Lp->L_fds >= 0) {
		(void) t_close (Lp->L_fds);
		Lp->L_fds = -1;
	}
	if (add_service (Lp, Lp->L_service)) {
		pollfd[pos].fd = Lp->L_fds;
		pollfd[pos].events = POLLIN;
		Lp->L_flags &= ~L_ADD_SERVICE;
		syslog (LOG_ERR,"%s service reactivated", Lp->L_service);
		return;
	}

	pollfd [pos].fd = 0;
	pollfd [pos].events &= ~POLLIN;
	syslog (LOG_ERR,"%s Can't reactiate service, Will try later", Lp->L_service);
	Lp->L_flags |= L_ADD_SERVICE;
	Lp->L_pos = pos;
	(void) signal (SIGALRM, redo_services);
	(void) alarm (alarm_time);
}

struct cind *
alloc_cind(s)
{
	register struct cind *cind;
	
	if ((cind = (struct cind *)calloc(1, sizeof(struct cind))) == NULL) {
		syslog(LOG_ERR, "calloc failed");
		return (struct cind *)NULL;
	}
	
	if((cind->call = (struct t_call *)t_alloc(s, T_CALL, T_ADDR)) < 0) {
		free((char *)cind);
		syslog (LOG_ERR,"t_alloc failed");
		return NULL;
	}
	return cind;
}

void
free_cind(cind)
struct cind *cind;
{
	(void)t_free(cind->call, T_CALL);
	free((char *)cind);
}
	
/*
 * add the new cind structure to the end
 * of the list pointed to by Lp->L_cind
 */
void
add_cind(Lp, cind)
	register struct Listen *Lp;
	register struct cind *cind;
{
	register struct cind *p;

	if(!Lp->L_cind) {
		Lp->L_cind = cind;
		return;
	}
	p = Lp->L_cind;	
	while (p->next)
		p = p->next;	
	p->next = cind;
}

/*
 * delete a cind node from the Lp->L_cind list
 */
void
del_cind(Lp, cind)
	register struct Listen *Lp;
	register struct cind *cind;
{
	register struct cind *p;

	p = Lp->L_cind;
	if (!p)
		return;
	
	if (p == cind) {
		Lp->L_cind = p->next;
		return;
	}

	while (p->next && (p->next != cind))
		p = p->next;

	if (p->next) 
		p->next = cind->next;
}	
