/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)fcntl.c (TWG)        1.4      17:26:24 - 89/06/30"

/* LINTLIBRARY */

/*
 * This is the interface into the BSD
 * Networking systm calls. These are invoked
 * as ioctl's.
 */
#include <sys/types.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <fcntl.h>
#include <sys/tihdr.h>
#include <sys/inet.h>
#include <errno.h>
#include <sys/somod.h>

/* ARGSUSED */
fcntl (fd, cmd, arg)
{
	register int flags, retval;

	if (cmd != F_SETFL) 
		return (_win_do_fcntl(fd, cmd, arg));

	/* record the current flags */
	if ((flags = _win_do_fcntl(fd, F_GETFL, 0)) < 0)
		return -1;
	
	/* now set the new flags */
	if ((retval = _win_do_fcntl(fd, cmd, arg)) < 0)
		return -1;

	/* XXXX This is driver dependant! Need to fix later XXXX */
	/* inform somod if appropriate */
	if (ioctl(fd, I_FIND, "somod") != 1)
		return (retval);

	if (!_s_ioctl(fd, &arg, sizeof(arg), SIOC_NBIO, 0)) 
		goto undo;
	else
		return (retval);

undo:
	(void)_win_do_fcntl(fd, F_SETFL, flags);
	errno = EIO;
	return -1;
}
