/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)getsockopt.c (TWG)        1.3      11:00:27 - 89/09/08"

/* LINTLIBRARY */
#include <sys/types.h>
#include <sys/param.h>
#include <errno.h>
#include <stdio.h>
#include <sys/tiuser.h>
#include <sys/stropts.h>
#include <sys/stream.h>

#include <sys/ip.h>
#include <sys/inetioctl.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/in.h>
#include <sys/timod.h>
#include <win_hook.h>

/*
 * Send an I_STR ioctl down to the kernel.
 *
 * Generally we leave it to the underlying
 * protocol to accept or reject an option.
 */

int
getsockopt(s, level, optname, optval, optlen)
	int  s, level, optname;
	char *optval;
	int  *optlen;
{
	struct winsopt *winsopt;
	struct strioctl ioc;
	char *request;		/* temporary buffer for request */
	int size;		/* size of request */
	caddr_t saved_sp;
	extern caddr_t _ssp();
	extern void _rsp();
	extern char *alloca();

	saved_sp = _ssp();

	if (level == IPPROTO_RAW || level == IPPROTO_TCP
		|| level == IPPROTO_UDP || level == SOL_SOCKET) {

		/* We handle SO_TYPE at the user level */
		if (optname == SO_TYPE) {
			if (*optlen != sizeof(int)) {
				errno = EINVAL;
				goto err_ret;
			}
			*((int *)optval) = AF_INET;
			goto ok_ret;
		}

		/*
		 * SO_DEBUG is not supported in the kernel but we don't want
		 * to give the user an error so just return zero.
		 */
		if (optname == SO_DEBUG)
			goto ok_ret;
	}

	/* only these levels are supported at this point */
	if (level != IPPROTO_IP && level != IPPROTO_TCP
				&& level != SOL_SOCKET) {
		errno = EINVAL;
		goto err_ret;
	}

	size = sizeof(struct winsopt) + *optlen; /* size of request */

	request = alloca(size);
	if (request == NULL)
		goto err_ret;

	/*
	 * Set up request information for ioctl()
	 */
	bzero((caddr_t)request, size);
	winsopt = (struct winsopt *)request;
	winsopt->level = level;
	winsopt->name  = optname;
	winsopt->flags = T_DEFAULT;
	bcopy((caddr_t)optval, (caddr_t)(request + sizeof(struct winsopt)),
								*optlen);

	ioc.ic_cmd = TCPIOC_SOCKOPT;
	ioc.ic_timout = 60;
	ioc.ic_len = size;
	ioc.ic_dp = (caddr_t)request;
	if (ioctl(s, I_STR, &ioc) < 0)
		goto err_ret;

	bcopy((caddr_t)(ioc.ic_dp), (caddr_t)optval, ioc.ic_len);

	*optlen = ioc.ic_len;

ok_ret:
	_rsp(saved_sp);
	return 0;

err_ret:
	_rsp(saved_sp);
	return -1;

}	/*  End of getsockopt()  */
