/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)sl_util.c        1.1      17:03:06 - 89/06/26"

#include "sys/types.h"
#include "sys/stropts.h"
#include "sys/stream.h"
#include "sys/errno.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/inetioctl.h"
#include "sys/somod.h"

extern int errno;
extern int t_errno;
extern int slmsgsz;

/*
 * somod ioctl
 */
_s_ioctl(fd, buf, size, cmd, retlen)
char *buf;
int *retlen;
{
	struct strioctl strioc;
	int retval;

	strioc.ic_cmd = cmd;
	strioc.ic_timout = -1;
	strioc.ic_len = size;
	strioc.ic_dp = buf;

	if ((retval = ioctl(fd, I_STR, &strioc)) < 0) {
		if (errno == ENOTTY)
			errno = ENOTSOCK;
		return(0);
	}

	if (retval) {
		errno = retval & 0xff;
		t_errno = (retval >> 8) & 0xff;
		return(0);
	}

	if (retlen)
		*retlen = strioc.ic_len;
	return(1);
}



_s_setmsgsz(fd)
{
	struct s_info info;

	if (!_s_ioctl(fd, (caddr_t)&info, sizeof(info), SIOC_GETINFO, 0))
		return 0;

	slmsgsz = info.somsgsz;
	return (slmsgsz);
}
