/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)in.c (TWG)  1.2     89/07/10 "

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 *	@(#)in.c	7.7 (Berkeley) 4/3/88
 */

#include "sys/param.h"
#include "sys/types.h"
#include "sys/inline.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/debug.h"
#include "sys/strlog.h"
#include "sys/lihdr.h"

#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/if.h"
#include "sys/in.h"
#include "sys/in_var.h"
#include "sys/ip.h"
#include "sys/ip_var.h"

inet_netmatch(sin1, sin2)
	struct sockaddr_in *sin1, *sin2;
{

	return (in_netof(sin1->sin_addr) == in_netof(sin2->sin_addr));
}

/*
 * Formulate an Internet address from network + host.
 */
struct in_addr
in_makeaddr(net, host)
	u_long net, host;
{
	register struct in_ifaddr *ia;
	register u_long mask;
	u_long addr;

	if (IN_CLASSA(net))
		mask = IN_CLASSA_HOST;
	else if (IN_CLASSB(net))
		mask = IN_CLASSB_HOST;
	else
		mask = IN_CLASSC_HOST;
	for (ia = in_ifaddr; ia; ia = ia->ia_next)
		if ((ia->ia_netmask & net) == ia->ia_net) {
			mask = ~ia->ia_subnetmask;
			break;
		}
	addr = htonl(net | (host & mask));
	return (*(struct in_addr *)&addr);
}

/*
 * Return the network number from an internet address.
 */
u_long
in_netof(in)
	struct in_addr in;
{
	register struct in_ifaddr *ia;
	register u_long net;
	register u_long i = ntohl(in.s_addr);

	if (IN_CLASSA(i))
		net = i & IN_CLASSA_NET;
	else if (IN_CLASSB(i))
		net = i & IN_CLASSB_NET;
	else if (IN_CLASSC(i))
		net = i & IN_CLASSC_NET;
	else
		return (0);

	/*
	 * Check whether network is a subnet;
	 * if so, return subnet number.
	 */
	for (ia = in_ifaddr; ia; ia = ia->ia_next)
		if (net == ia->ia_net)
			return (i & ia->ia_subnetmask);
	return (net);
}

/*
 * Return the host portion of an internet address.
 */
u_long
in_lnaof(in)
	struct in_addr in;
{
	register struct in_ifaddr *ia;
	register u_long net, host;
	register u_long i = ntohl(in.s_addr);

	if (IN_CLASSA(i)) {
		net = i & IN_CLASSA_NET;
		host = i & IN_CLASSA_HOST;
	} else if (IN_CLASSB(i)) {
		net = i & IN_CLASSB_NET;
		host = i & IN_CLASSB_HOST;
	} else if (IN_CLASSC(i)) {
		net = i & IN_CLASSC_NET;
		host = i & IN_CLASSC_HOST;
	} else
		return (i);

	/*
	 * Check whether network is a subnet;
	 * if so, use the modified interpretation of `host'.
	 */
	for (ia = in_ifaddr; ia; ia = ia->ia_next)
		if (net == ia->ia_net)
			return (host &~ ia->ia_subnetmask);
	return (host);
}

#ifndef SUBNETSARELOCAL
#define	SUBNETSARELOCAL	1
#endif
int subnetsarelocal = SUBNETSARELOCAL;
/*
 * Return 1 if an internet address is for a ``local'' host
 * (one to which we have a connection).  If subnetsarelocal
 * is true, this includes other subnets of the local net.
 * Otherwise, it includes only the directly-connected (sub)nets.
 */
in_localaddr(in)
	struct in_addr in;
{
	register struct in_ifaddr *ia;
	register u_long i = ntohl(in.s_addr);

	if (subnetsarelocal) {
		for (ia = in_ifaddr; ia; ia = ia->ia_next)
			if ((i & ia->ia_netmask) == ia->ia_net)
				return (1);
	} else {
		for (ia = in_ifaddr; ia; ia = ia->ia_next)
			if ((i & ia->ia_subnetmask) == ia->ia_subnet)
				return (1);
	}
	return (0);
}

/*
 * Return 1 if an internet address is for one of our local addresses
 */
in_ouraddr(in)
	struct in_addr in;
{
	register struct in_ifaddr *ia;

	for (ia = in_ifaddr; ia; ia = ia->ia_next)
		if (satosaddr(ia->ia_addr) == in.s_addr)
		     return (1);
	return (0);
}

/*
 * Determine whether an IP address is in a reserved set of addresses
 * that may not be forwarded, or whether datagrams to that destination
 * may be forwarded.
 */
in_canforward(in)
	struct in_addr in;
{
	register u_long i = ntohl(in.s_addr);
	register u_long net;

	if (IN_EXPERIMENTAL(i))
		return (0);
	if (IN_CLASSA(i)) {
		net = i & IN_CLASSA_NET;
		if (net == 0 || net == IN_LOOPBACKNET)
			return (0);
	}
	return (1);
}

/*
 * Return address info for specified internet network.
 */
struct in_ifaddr *
in_iaonnetof(net)
	u_long net;
{
	register struct in_ifaddr *ia;

	for (ia = in_ifaddr; ia; ia = ia->ia_next)
		if (ia->ia_subnet == net)
			return (ia);
	return ((struct in_ifaddr *)0);
}

/*
 * Return 1 if the address might be a local broadcast address.
 */
in_broadcast(in)
	struct in_addr in;
{
	register struct in_ifaddr *ia;
	register u_long host = in.s_addr;
	u_long t;

	/*
	 * Look through the list of addresses for a match
	 * with a broadcast address.
	 */
	for (ia = in_ifaddr; ia; ia = ia->ia_next) {
	    if (ia->ia_ifp->if_flags & IFF_BROADCAST) {
		if (satosaddr(ia->ia_broadaddr) == host)
		     return (1);
		/*
		 * Check for old-style (host 0) broadcast.
		 */
		if (((t = ntohl(host)) == ia->ia_subnet) || (t == ia->ia_net))
		    return (1);
	    }
	}
	if ((host == INADDR_BROADCAST) || (host == INADDR_ANY))
		return (1);
	return (0);
}

struct in_ifaddr *in_ifaddr;
extern int in_cnt;
extern struct in_ifaddr in_addr[];

struct in_ifaddr *
get_inaddr()
{
	register struct in_ifaddr *ia;

	for (ia = &in_addr[0]; ia < &in_addr[in_cnt]; ia++) {
		if (ia->ia_ifp == (struct ifnet *)NULL)
			break;
	}
	if (ia - &in_addr[0] >= in_cnt)
		return ((struct in_ifaddr *)0);
	else
		return (ia);
}

void 
free_inaddr(inp)
struct in_ifaddr *inp;
{
	register struct in_ifaddr **ia;
	register int found = 0;

	/* remove the address from in_ifaddr chain */
	for (ia = &in_ifaddr; *ia; ia = &((*ia)->ia_next)) { 
		if (*ia == inp) {
			*ia = inp->ia_next;
			found = 1;
			break;
		}
	}
	if (found)
		bzero((caddr_t)inp, sizeof(struct in_ifaddr));
	else 
		STRLOG(IP_ID, -1, DPRI_LO, SL_TRACE,
			"free_inaddr: could not find interface address %x",
			inp);
}
