/* LINTLIBRARY */
/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)tcp_ioc.c (TWG)  1.5     89/09/06 "

/* Fix Log
 *
 * TWU	05/03/91	Change KEEPALIVE timer to 75 secs if setting KEEPALIVE
 *			option.
 * TWU  05/20/91	To support TCP_NODELAY
 */
/*
 * tcp tli multiplexor
 */

#include "sys/param.h"
#include "sys/types.h"
#ifndef XENIX
#include "sys/inline.h"
#endif
#include "sys/errno.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/tiuser.h"
#include "sys/strlog.h"
#include "sys/debug.h"
#ifdef XENIX
#include "sys/assert.h"
#endif
#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/if.h"
#include "sys/in.h"
#include "sys/in_var.h"
#include "sys/ip.h"
#include "sys/ip_var.h"
#include "sys/tcp.h"
#include "sys/ip_icmp.h"
#include "sys/inetioctl.h"

extern struct tcpb tcpb;


/***********************
 *  Table of Contents  *
 ***********************/

void		tcp_ioctl();
int		tcp_sockopt();
int		tcp_ipoptions();

/***** End of TOC *****/

#define fill_in_msg( msg, source, count ) \
/*	register mblk_t	*msg;		/* first block of target message */ \
/*	char		*source;	/* source data structure */	\
/*	int		count;		/* bytes to copy from source */ \
{	bcopy( (char *)(source), (msg)->b_rptr, count ); \
	(msg)->b_wptr = (msg)->b_rptr + count ; }


void
tcp_ioctl (tdp, q, bp)

	struct tcpd *tdp;
	register queue_t *q;
	register mblk_t *bp;
{
	struct iocblk *ip;
	struct linkblk *lp;
	queue_t *bq;
	mblk_t *bp1;
	struct tcpb *tbp;
	extern void tcpmuxnotify();

	ip = mtod (bp, struct iocblk *);

	/*
	 * Check to see if the User has the permision
	 * If doing a Link.
	 * ALso since there is only one bottom
	 * This stuff knows about that.
	 */
	tbp = (struct tcpb *)&tcpb;
	if (TCPCHAN (tdp) != TCPCTLCHAN)
		goto tcpdioctl;

	/*
	 * Only the Super user is allowed to do these
	 * privileged operations.
	 */
	if (ip->ioc_uid) {
		ip->ioc_error = EPERM;
		MTYPE(bp) = M_IOCNAK;
		ip->ioc_count = 0;
		qreply(q, bp);
		return;
	}
	/*
	 * These are all on the control channel.
	 */
	switch (ip->ioc_cmd) {

	case I_LINK:
		/*
		 * there is only one bottom q, i.e. for ip
		 */

		lp = (struct linkblk *)bp->b_cont->b_rptr;
		if (tbp->tb_wrq) 
			goto nack;
		bq = lp->l_qbot;
		bq->q_ptr = RD(bq)->q_ptr = (caddr_t)tbp;
		tbp->tb_wrq = bq;
		tbp->tb_qtop = /*lp->l_qtop; */ q;
		tbp->tb_cookie = lp->l_index;
		tbp->tb_mstate = IPIF_LINKING;
		/*
		 * keep the M_IOCTL block and change to M_IOCACK
		 * when the M_CTL is acked
		 * actually the only thing needed to be saved is
		 * ioc_id. Saving the block to save time (don't need
		 * freemsg here and allocb later).
		 * Remember to free it when the chan is closing
		 */
		tbp->tb_iocblk = bp;
		(void)tcpmuxnotify();
		break;

	case I_UNLINK:

		if (tbp->tb_wrq == NULL)
			goto nack;
		tbp->tb_mstate = IPIF_UNLINKING;
		tbp->tb_iocblk = bp;
		tcpmuxnotify();
		tbp->tb_wrq = NULL;
		break;

	case TCPIOC_GETTCPSTAT:
	{
		if ((bp1 = bp->b_cont) == NULL
		|| ip->ioc_count < sizeof tcpstat
		|| ! pullupmsg(bp1, sizeof tcpstat ) ) {
			ip->ioc_error = EINVAL;
			goto nack;
		}
		ip->ioc_count = sizeof tcpstat;
		fill_in_msg( bp1, &tcpstat, sizeof tcpstat);
		ip->ioc_error = 0;
		goto Reply;
	}

	case TCPIOC_GETTCB:
	{
		register mblk_t	*tcbp;
		register mblk_t	*usertcbp;
		struct tcpcb	*tp;
		struct tcpglob	*userglob;

		if ((bp1 = bp->b_cont) == NULL
		|| ip->ioc_count < sizeof(struct tcpglob) 
		|| ! pullupmsg(bp1, sizeof(struct tcpglob) ) ) {
			ip->ioc_error = EINVAL;
			goto nack;
		}
		userglob = (struct tcpglob *)bp1->b_rptr;
		usertcbp = userglob->tcb.b_next;
		/* if user passed in an invalid tcb address, then
		 * return the tcb at the list head 
		 * Since TCBs are just mblks, and not all mblks are valid tcbs,
		 * we must run the chain of tcbs to see if the address the user
		 * has requested is valid.
		 */
		if (usertcbp == (mblk_t *)&tcpcb) { 
			ip->ioc_error = EADDRNOTAVAIL; 
			goto nack;
		}
		bp1->b_wptr = bp1->b_rptr + sizeof(*userglob);
		bzero(        bp1->b_rptr,  sizeof(*userglob));
		ip->ioc_count             = sizeof(*userglob);
		ip->ioc_error             = 0;
		for (tcbp = ((mblk_t *)&tcpcb)->b_next; 
		     tcbp != (mblk_t *)&tcpcb && tcbp != usertcbp;
		     tcbp = tcbp->b_next) 
			;
		if (tcbp == (mblk_t *)&tcpcb)  {
			/* If the tcpcb chain is empty, return an all zero
			 * tcb to the caller, who will detect this by seeing
			 * tcb.b_cont == 0
			 */
			if ( tcbp == ((mblk_t *)&tcpcb)->b_next ) 
				goto Reply;
			tcbp = ((mblk_t *)&tcpcb)->b_next; 
		}
		tp = (struct tcpcb *)tcbp->b_rptr;
		userglob->tcb   = *tcbp;
		userglob->tcpcb = *tp;
		if (tp->t_tdp)
		    userglob->tcpd  = *tp->t_tdp;
		/* put the value of &tcpcb into the tcb we give to the user,
		 * so user's program can tell when it has come to the end of
		 * the chain, and thus avoid the EADDRNOTAVAIL error.
		 */
		userglob->tcb.b_cont = (mblk_t *)&tcpcb;
		goto Reply;
	}

	default:
		STRlog(TCP_ID, TCPCHAN(tdp), DPRI_HI, SL_te,
		  "tcp_ioctl: unknown ioctl %x on cntl chan\n", ip->ioc_cmd);
		goto nack;
	}
	return;

	/*
	 * ioctl to individual tcp channels
	 */
	tcpdioctl: switch (ip->ioc_cmd) {

	  case TCPIOC_DORDWR:
	    tdp->td_flags |= TD_RDWR;
  Ack:
	    ip->ioc_count = ip->ioc_error = 0;
  Reply:
	    MTYPE(bp) = M_IOCACK;
	    qreply (q, bp);
	    return;
	
	  case TCPIOC_NEWPORT:
	    tdp->td_flags |= TD_NEWPORT;
	    goto Ack;
	    
	  case TCPIOC_NORDWR:
	    tdp->td_flags &= ~TD_RDWR;
	    goto Ack;
	    
	  case TCPIOC_GETMYSTATE:
	    {
	    struct tcpcb *tcp;
	    mblk_t *bp1;
	    /*
	     * Return my TCP state.
	     */
	    if (tdp->td_tcpcb == NULL) {
		printf ("TCPIOC_GETMYSTATE no PCB\n");
		goto nack;
		}
	    tcp = mtod (tdp->td_tcpcb, struct tcpcb *);
	    if (bp->b_cont == (mblk_t *)NULL) {
		bp1 = allocb (sizeof (long), BPRI_LO);
		if (bp1 == (mblk_t *)NULL) goto nack;
		bp->b_cont = bp1;
	    } else 
		bp1 = bp->b_cont;
	    bp1->b_wptr = bp1->b_rptr + sizeof (long);
	    ip->ioc_count = sizeof (long);
		*(mtod (bp1, long *)) = tcp->t_state;
	    ip->ioc_error = 0;
	    goto Reply;
	    }

	  case TCPIOC_DATAPEND:
	    {
	    mblk_t *bp1;
	    /*
	     * Return the amount of data pending.
	     */
	    if (bp->b_cont == (mblk_t *)NULL) {
		bp1 = allocb (sizeof (long), BPRI_LO);
		if (bp1 == (mblk_t *)NULL) goto nack;
		bp->b_cont = bp1;
	    } else 
		bp1 = bp->b_cont;
	    bp1->b_wptr = bp1->b_rptr + sizeof (long);
	    ip->ioc_count = sizeof (long);
	    *(mtod (bp1, long *)) = t_wcc (tdp);
	    ip->ioc_error = 0;
	    goto Reply;
	    }
	  case TCPIOC_GETSOCKNAME:
	  case TCPIOC_GETPEERNAME:
	    {
	    struct tsap *tp;
	    struct tcpcb *tcp;
	    mblk_t *bp1;
	    
	    /*
	     * Return My port that I am bound to
	     */
	    if (bp->b_cont == NULL)
		goto nack;
	    if (tdp->td_tcpcb == NULL) {
		/* we're not bound */
		ip->ioc_error = EADDRNOTAVAIL;
		goto nack;
		}
	    bp1  = bp->b_cont;
	    tp = (struct tsap *)bp1->b_rptr;
	    tcp = (struct tcpcb *)tdp->td_tcpcb->b_rptr;
	    *tp = ip->ioc_cmd == TCPIOC_GETSOCKNAME ? tcp->t_la : tcp->t_fa;
	    tp->ta_family = AF_INET;
	    bp1->b_wptr = bp1->b_rptr + BINDLEN;
	    bzero((char *)bp1->b_wptr, 8);
	    bp1->b_wptr += 8;
	    ip->ioc_count = TCP_ADDRLEN;
	    ip->ioc_error = 0;
	    goto Reply;

	    }

	  case TCPIOC_SETQLENGTH:
	    {
	    /*
	     * Set the connection queue length.
	     */
	    register int qlen;
	    
	    if (bp->b_cont == NULL || (BLEN(bp->b_cont) 
				       < sizeof(int)) || tdp->td_tcpcb == NULL)
		goto nack;
	    qlen = min(TCP_MAXCONIND, *(int *)bp->b_cont->b_rptr);
	    ((struct tcpcb *)tdp->td_tcpcb->b_rptr)->t_maxcon =	qlen;
	    goto Ack;
	    }

	  case TCPIOC_SOCKOPT:
	    /* handle all the socket options that have been sent to us */
	    if ((ip->ioc_error = tcp_sockopt(ip, tdp, q, bp)) == 0)
		goto Reply;
	    else
		goto nack;

	  case TCPIOC_GETFAMILY:	{	/* Get address family. */
	      ip->ioc_error = 0;
	      if (ip->ioc_count != sizeof(ushort))
		  goto nack;
	      *(ushort *)bp->b_cont->b_rptr = AF_INET;
	      goto Reply;
	      }

	  case TCPIOC_SETTOS:	/* Set Type of service */
	    ip->ioc_error = 0;
	    if (ip->ioc_count != sizeof(unsigned char))
		goto nack;
	    tdp->td_tos = *(unsigned char *)bp->b_cont->b_rptr;
	    goto Ack;

	  case TCPIOC_GETTOS:	/* Get Type of service */
	    ip->ioc_error = 0;
	    if (ip->ioc_count != sizeof(unsigned char))
		goto nack;
	    *(unsigned char *)bp->b_cont->b_rptr = tdp->td_tos;
	    goto Reply;

	  case TCPIOC_SETTTL:	/* Set Time to live */
	    ip->ioc_error = 0;
	    if (ip->ioc_count != sizeof(unsigned char))
		goto nack;
	    tdp->td_ttl = *(unsigned char *)bp->b_cont->b_rptr;
	    goto Ack;

	  case TCPIOC_GETTTL:	/* Get Time to live */
	    ip->ioc_error = 0;
	    if (ip->ioc_count != sizeof(unsigned char))
		goto nack;
	    *(unsigned char *)bp->b_cont->b_rptr = tdp->td_ttl;
	    goto Reply;
	    
	  default:
nack:
	    MTYPE(bp) = M_IOCNAK;
	    if (ip->ioc_error == 0)
		ip->ioc_error = EINVAL;
	    qreply(q, bp);
	    }

	return;

}	/*  End of tcp_ioctl()  */


/*
 *	tcp_sockopt() allows users to set or get various "socket" options.
 *
 *	The beginning of bp->cont is expected to contain a winsopt 
 *	structure which comprises the following members:
 *
 *		1. level - this is the protocol level
 *		2. name  - this is the option name
 *		3. flags - this indicates the action to take (i.e. get or set)
 */
int
tcp_sockopt(ip, tdp, q, bp)
	register struct iocblk *ip;
	register struct tcpd *tdp;
	register queue_t *q;
	register mblk_t *bp;
{
	register mblk_t *bp1 = bp->b_cont;
	register struct winsopt *winsopt;
	int *tmp;
	int ans = EINVAL;
	int len;
	int ret;
	extern int tcp_maxrcvwin,  tcp_minrcvwin; /* see /etc/master.d/tcp */

	if (bp1 == NULL || BLEN(bp1) < sizeof(struct winsopt))
		goto nonfatal;

	winsopt = (struct winsopt *)bp1->b_rptr;

	/*
	 * Let's see if the option level is really for us. We'll
	 * accept SOCKET level and TCP level options.   IP level
	 * options will be sent down to IP using a M_CTL message.
	 */
	if (winsopt->level == IPPROTO_IP) {
		if ((ans = tcp_ipoptions(bp, tdp, winsopt->flags)) == 0) {
			bp1 = bp->b_cont;
			if (bp1)
				ip->ioc_count = BLEN(bp1);
			else
				ip->ioc_count = 0;
			return ans;
		}
		goto nonfatal;
	} else if (winsopt->level != IPPROTO_TCP &&
						winsopt->level != SOL_SOCKET) {
		/* reject option */
		ans = ENOPROTOOPT;
		goto nonfatal;
	}
/* TWU 05/20/91 Add new code support TCP level option and new NO DELAY option */
	if ( winsopt->level == IPPROTO_TCP ) {
		if ((ans = tcp_tcpoptions(ip, bp, tdp, winsopt)) == 0)
			return 0;
		else
			goto nonfatal;
	
	} 
			
			
	/* Except for SO_LINGER we expect integer. */
	len = BLEN(bp1) - sizeof(struct winsopt);

	if ((winsopt->name == SO_LINGER) && (len < sizeof(int)))
		goto nonfatal;

	else if (len != sizeof(int))
		goto nonfatal;

	if (winsopt->flags == T_NEGOTIATE) {
		/* set option */
		STRLOG(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_TRACE, 
			"tcp_sockopt: set options");

		tmp = (int *)(bp1->b_rptr + sizeof(struct winsopt));

		switch (winsopt->name) {

		case SO_RCVBUF:
			/*
			 * What we're trying to set is the hi water mark
			 * of TCP's top read queue.  TCP's receive window
			 * is based on this value.
			 *
			 * First check here that q_hiwat is not being
			 * set too large or too small.
			 */
			if (*tmp > tcp_maxrcvwin || *tmp < tcp_minrcvwin)
				goto nonfatal;

			RD(q)->q_hiwat = (ushort)*tmp;
			break;

		case SO_LINGER:
			if (*tmp)
				tdp->td_flags &= ~TD_NOLINGER;
			else
				tdp->td_flags |= TD_NOLINGER;
			break;

		case SO_KEEPALIVE:
		{
			struct tcpcb *tp;
		      if (tdp->td_tcpcb) {
			tp = (struct tcpcb *)tdp->td_tcpcb->b_rptr;
		      	if (*tmp)
				tp->t_timer[TCPT_KEEP] = tcp_keepintvl;
		      	else
				tp->t_timer[TCPT_KEEP] = tcp_keepidle;
		     }
		}
		/* FALL THROUGH */
		case SO_REUSEADDR:
		case SO_DONTROUTE:
			/*
			 * Turn option on or off.
			 */

			if (*tmp)
			    tdp->td_sockflags |= winsopt->name; /* set flag   */
			else
			    tdp->td_sockflags &= ~winsopt->name;/* reset flag */

			break;

		default:
			ans = ENOPROTOOPT;
			goto nonfatal;
		}

	} else if (winsopt->flags == T_DEFAULT) {
		/* get option */
		STRLOG(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_TRACE, 
			"tcp_sockopt: get options");

		switch (winsopt->name) {

		case SO_LINGER:
			if (tdp->td_flags & TD_NOLINGER)
				tdp->td_sockflags &= ~SO_LINGER;
			else
				tdp->td_sockflags |= SO_LINGER;
			/* DROP THROUGH */
		case SO_RCVBUF:
		case SO_KEEPALIVE:
		case SO_REUSEADDR:
		case SO_DONTROUTE:
			/*
			 * Return option setting or option value.
			 */
			if (winsopt->name == SO_RCVBUF)
				ret = (int)RD(q)->q_hiwat;
			else
				ret = (int)(winsopt->name & tdp->td_sockflags);

			tmp = &ret;
			break;

		default:
			ans = ENOPROTOOPT;
			goto nonfatal;
		}

	} else
		/* unknown request */
		goto nonfatal;

	bcopy((caddr_t)tmp, (caddr_t)bp1->b_rptr, len);
	ip->ioc_count = len;
	bp1->b_wptr = bp1->b_rptr + len;
	return 0;

nonfatal:
	STRlog(TCP_ID, -1, DPRI_LO, SL_te,
			"tcp_sockopt: nonfatal error %0x\n", ans);
	return ans;

}	/* End of tcp_sockopt() */


/*
 * Options meant for IP - send them downstream.
 */
int
tcp_ipoptions(bp, tdp, flags)
	register mblk_t *bp;
	register struct tcpd *tdp;
{
	register mblk_t *ifbp;
	register mblk_t *bp1 = bp->b_cont;
	ipfcmd *iftype;
	int ans = 0;
	extern char tcpopt_out; /* see /etc/master.d/tcp */

	if ((ifbp = allocb(sizeof(ipfcmd), BPRI_MED)) == NULL) {
		STRlog(TCP_ID, -1, DPRI_HI, SL_te,
			"tcp_sendipopts: out of buffer\n");
		return -1;
	}

	bp->b_cont = NULL;

	/*
	 * ifbp's continuation will tell IP what to do with the sent options.
	 * It contains the winsopt structure and data as sent down by the user.
	 */
	ifbp->b_cont = bp1;

	/*
	 * bp1's continuation pointer will point to the ip options message
	 * block. This could be NULL if there are currently no options set.
	 *
	 * If tcpopt_out is set then get the outgoing IP options
	 * else get the incoming IP options.
	 */
	if ((tcpopt_out) || flags == T_NEGOTIATE)
		bp1->b_cont = tdp->td_ipopt; /* set (or get) outgoing options */
	else
		bp1->b_cont = tdp->td_ipoptin; /* get incoming options */

	iftype = (ipfcmd *)ifbp->b_wptr;
	*iftype = IPIF_OPTIONS;
	ifbp->b_wptr += sizeof(ipfcmd);

	MTYPE(ifbp) = M_CTL;

	if (tcpsend(ifbp) == 0) { 
		/* iftype indicates success or failure on return */
		iftype = (ipfcmd *)ifbp->b_rptr;
		if (*iftype == 0) {
			if (flags == T_NEGOTIATE) {
				/* setting - update tdp's option pointer */
				if (!tdp->td_ipopt)
					tdp->td_ipopt = ifbp->b_cont;
			} else {
				/* getting - update b_cont for user */
				bp->b_cont = ifbp->b_cont;
			}
		} else {
			STRlog(TCP_ID, -1, DPRI_HI, SL_te,
				"tcp_ipoptions: error 0x%x from ip", *iftype);
			ans = (int)*iftype;
		}
	} else {
		ans = ENOPROTOOPT;
		STRlog(TCP_ID, -1, DPRI_HI, SL_te,
			"tcp_ipoptions: tcpsend failed");
	}

	freeb(ifbp);
	return ans;

}	/* End of tcp_ipoptions() */

/* 05/20/91 TWU To support sock option in tcp level */
tcp_tcpoptions (ip, bp, tdp, winsopt)
register struct iocblk *ip;
register mblk_t *bp;
register struct tcpd *tdp;
register struct winsopt *winsopt;
{
	int *tmp, ret, len;
	mblk_t *bp1 = bp->b_cont;
	struct tcpcb *tp = (struct tcpcb *)tdp->td_tcpcb->b_rptr;

	len = BLEN(bp1) - sizeof(struct winsopt);

	if (bp1 == NULL || BLEN(bp1) < sizeof(struct winsopt))
		return (EINVAL);

	if (len != sizeof(int))
		return (EINVAL);
	
	if (winsopt->flags == T_NEGOTIATE) {
		/* set option */
		STRLOG(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_TRACE, 
			"tcp_sockopt: set tcp options");
		tmp = (int *)(bp1->b_rptr + sizeof(struct winsopt));

		switch (winsopt->name) {

		case TCP_NODELAY:
			if (tp == NULL)
				return EINVAL;
			if (*tmp)
				tp->t_flags |= TF_NODELAY;
			else
				tp->t_flags &= ~TF_NODELAY;
			break;
		default:
			return ENOPROTOOPT;
		}
			
	} else if (winsopt->flags == T_DEFAULT) {
		switch (winsopt->name) {

		case TCP_NODELAY:
			if (tp == NULL)
				return EINVAL;
			if (tp->t_flags & TF_NODELAY)
				ret = winsopt->name;
			else
				ret = winsopt->name & ~TF_NODELAY;	
			tmp = &ret;
			break;
		default:
			return ENOPROTOOPT;
		}
		
	}
	bcopy((caddr_t)tmp, (caddr_t)bp1->b_rptr, len);
	ip->ioc_count = len;
	bp1->b_wptr = bp1->b_rptr + len;
	return 0;
}
