#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)endflush.c (TWG)  1.1     89/05/19 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include "sys/param.h"
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/inet.h"
#include "sys/debug.h"

/*
 * driver end receives a M_FLUSH, q is the write q
 */

void
endflush(q, bp)

	queue_t *q;
	register mblk_t *bp;
{
	ASSERT(q && bp && MTYPE(bp) == M_FLUSH);

	if (*bp->b_rptr & FLUSHW)
		flushq(q, 0);

	if (*bp->b_rptr & FLUSHR) {
		flushq(OTHERQ(q), 0);
		*bp->b_rptr &= ~FLUSHW;
		qreply(q, bp);
	} else
		freemsg(bp);

}	/*  End of endflush()  */

