#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)tcpfinger.c (TWG)  1.1     89/05/17 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include <sys/types.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <netdb.h>
#include <sys/in.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/ip.h>
#include <sys/tcp.h>
#include <sys/fcntl.h>
#include <tiuser.h>

#ifdef vax
#define	htons(x)	((((x) >> 8) & 0xff) | (((x) & 0xff) << 8))
#else
#define htons(x)	(x)
#endif /* vax */
struct sockaddr_in sin;
extern t_errno, errno;

tcpfinger(argc,argv)
char *argv[];
{
	register int i;
	int net_fd, flag, n, Status;
	char buf [1024];

	static char User[100] = {0};
	static char Host[100] = {0};
	struct hostent *host, *gethostbyname();
	struct servent *sp;
	u_long inet_addr();
	struct t_call scall,  *sndcall = &scall;

	/*
	 *	Verify that we have enough args
	 */
	if(argc < 2) {printf("Bad arg\n");exit(0);}
	/*
	 *	There had better be an "@" in the spec. at this point
	 *		(local stuff is handled by vmsfinger code)
	 */
	i = index(argv[1],'@');
	if (i == 0) {printf("Bad arg\n");exit(0);}
	/*
	 *	Divvy the spec into user name and host name
	 */
	strncpy(User,argv[1],i-(int)argv[1]);
	strcpy(Host,i+1);
	/*
	 *	The specified host's net address
	 */
	host = gethostbyname(Host);
	if(host) {
		sin.sin_family = host->h_addrtype;
		bcopy(host->h_addr, (caddr_t)&sin.sin_addr, host->h_length);
	} else {
		sin.sin_family = AF_INET;
		sin.sin_addr.s_addr = inet_addr(Host);
		if ((int)sin.sin_addr.s_addr == -1) {
			printf("Host %s not in host table\n",Host);
			exit(0);
		}
	}
	sp = getservbyname("finger","tcp");
	sin.sin_port = sp->s_port;
	if((net_fd = t_open(DEV_TCP,O_RDWR,0)) < 0) {
		t_error("t_open");
		exit (1);
	}
	if(t_bind(net_fd, 0, 0) < 0) {
		t_error("t_bind");
		exit (1);
	}
	sndcall->addr.buf = (char *)&sin;
	sndcall->addr.len = TCP_BINDADDRLEN;
	sndcall->udata.len = sndcall->opt.len = 0;
	if (t_connect(net_fd, sndcall, 0) < 0) {
	    errno &= 0xff;
		if (t_errno == TSYSERR)
			perror("Can't connect");
		else
			t_error("t_connect");
		exit (1);
	}
	/*
	 *	Send the Command line to the Host
	 */
	if (User[0] != 0) (void) t_snd (net_fd, User,strlen(User), 0);
	(void) t_snd (net_fd, "\r\n", 2, 0);
	/*
	 *	Read back the results and print them
	 */
	while((n = t_rcv(net_fd, buf, 1024, &flag)) > 0) {
		(void) write(1,buf,n);
	}
	(void) t_close (net_fd);
	/*
	 *	And exit
	 */
	exit(0);
	/* NOTREACHED */
}
