#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)remsh.c (TWG)  1.5     89/09/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include <sys/types.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/file.h>

#include <sys/in.h>

#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <pwd.h>
#include <netdb.h>
#include <tiuser.h>
#include <sys/poll.h>
#include <sys/fcntl.h>

/*
 * rsh - remote shell
 */
/* VARARGS */
int	error(); int sig_poll();
char	*index(), *rindex(), *malloc(), *getpass()/* , *sprintf(), *strcpy()*/;

struct	passwd *getpwuid();

extern errno, t_errno;
int 	remote,first;
int	options;
int	rfd2;
int	rem;
int	Parent, Child;
int	sendsig();
char	*cmdname;
int read_bits;
extern exit();

#define	mask(s)	(1 << ((s) - 1))


main(argc, argv0)
	int argc;
	char **argv0;
{
	int  pid;
	char *host, *cp, **ap, buf[BUFSIZ], *args, **argv = argv0, *user = 0;
	register int cc;
	int asrsh = 0;
	struct passwd *pwd;
	int readfrom, ready;
	int one = 1;
	struct servent *sp;
	int omask;
	cmdname = argv[0];
	host = rindex(argv[0], '/');
	if (host)
		host++;
	else
		host = argv[0];
	argv++, --argc;
	if (!strcmp(host, "remsh") || !strcmp(host, "rsh")) {
		host = *argv++, --argc;
		asrsh = 1;
	}
another:
	if (argc > 0 && !strcmp(*argv, "-l")) {
		argv++, argc--;
		if (argc > 0)
			user = *argv++, argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-n")) {
		argv++, argc--;
		(void) close(0);
		(void) open("/dev/null", 0);
		goto another;
	}

	/*
	 * Ignore the -e flag to allow aliases with rlogin
	 * to work
	 */
	if (argc > 0 && !strncmp(*argv, "-e", 2)) {
		argv++, argc--;
		goto another;
	}
	if (host == 0)
		goto usage;
	if (argv[0] == 0) {
		if (asrsh)
			*argv0 = "rlogin";
		execv("/usr/bin/rlogin", argv0);
		execvp("/usr/lbin/rlogin", argv0);
		execvp("rlogin", argv0);
		perror("rlogin");
		exit(1);
	}
	pwd = getpwuid(getuid());
	if (pwd == 0) {
		fprintf(stderr, "who are you?\n");
		exit(1);
	}
	cc = 0;
	for (ap = argv; *ap; ap++)
		cc += strlen(*ap) + 1;
	cp = args = malloc(cc);
	for (ap = argv; *ap; ap++) {
		(void) strcpy(cp, *ap);
		while (*cp)
			cp++;
		if (ap[1])
			*cp++ = ' ';
	}
	sp = getservbyname("shell", "tcp");
	if (sp == 0) {
		fprintf(stderr, "%s: shell/tcp: unknown service\n",cmdname);
		exit(1);
	}
	sp->s_port = ntohs(sp->s_port);
	/*
	 * Use t_rcmd() so that timod is still in the
	 * path.
	 */
        rem = t_rcmd(&host, sp->s_port, pwd->pw_name,
	    user ? user : pwd->pw_name, args, &rfd2);
        if (rem < 0)
                exit(1);
	if (rfd2 < 0) {
		fprintf(stderr, "%s: can't establish stderr\n",cmdname);
		exit(2);
	}
	t_sync(rem);
	t_sync(rfd2);
	(void) setuid(getuid());
#ifdef BSD
	omask = sigblock(mask(SIGINT)|mask(SIGQUIT)|mask(SIGTERM));
#endif /* BSD */
	signal(SIGINT, sendsig);
	signal(SIGQUIT, sendsig);
	signal(SIGTERM, sendsig);
	/*
	 * Set the network FD's to receive ASYNC
	 * Notifications.
	 */
#ifdef TWO_PROCS
	Parent = getpid();
	Child = fork();
	if (Child < 0){
		perror("fork");
		exit(1);
	}
	if (Child == 0){
		sig_poll(SIGPOLL);
		/* kill(Parent, SIGKILL); */
		exit(1);
	}
#else
	fcntl(rem, F_SETFL, O_NDELAY | fcntl(rem, F_GETFL, 0));
	fcntl(rfd2, F_SETFL, O_NDELAY | fcntl(rfd2, F_GETFL, 0));
	sigset(SIGPOLL, sig_poll);
	ioctl(rem, I_SETSIG, S_INPUT);
	ioctl(rfd2, I_SETSIG, S_INPUT);
	read_bits = (1<<rem) | (1<<rfd2)| (1<<0);
	sig_poll(SIGPOLL);	/* Pretend that we just got a signal */
	sigset (SIGALRM, sig_poll);
	alarm (1);
#endif /* TWO_PROCS */
	{
		/*
		 * Read from STDIN and write to net
		 */
		char *bp; int  wc;

		reread:
		errno = 0;
		if (first == 0 && remote )
			goto again;
#ifndef TWO_PROCS
		if (read_bits & ((1<<rem) | (1<<rfd2)))
			cc = read(0, buf, sizeof(buf));
		else exit (0);
#else
		cc = read(0, buf, sizeof(buf));
#endif /* TWO_PROCS */
		if (cc < 0 && errno == EINTR)
			goto reread;
		if (cc <= 0){
			/*
			 * The user has closed STDIN.
			 */
again:
			read_bits &= ~ (1<<0);
			t_errno = 0;
			sighold(SIGPOLL);
			cc = t_sndrel(rem); sleep(1); /* For things to cool down */
			sigrelse(SIGPOLL);
			if ( cc <0 && t_errno == TFLOW){
				sleep(1);
				sig_poll(SIGPOLL);
				goto again;
			}
#ifndef TWO_PROCS
			for(;read_bits;) /* What about stderr **/
				sig_poll(SIGPOLL);
			
			t_sndrel(rem);
			t_close(rem);
			t_sndrel(rfd2);
			t_close(rfd2);
/*			_nolinger_tclose(rem);
			_nolinger_tclose(rfd2);*/
			exit (0);
#else
			exit(0);
#endif /* TWO_PROCS */
		}
		first = 1;
		bp = buf;
	rewrite:
		sighold(SIGPOLL);
		wc = t_snd(rem, bp, cc, 0);
		if (wc < 0) {
			if (errno == EAGAIN) {
				sigrelse(SIGPOLL);
				sleep (2);
				goto rewrite;
			}
			goto Done;
		}
		cc -= wc; bp += wc;
		sigrelse(SIGPOLL);
		if (cc == 0) {
			sig_poll(SIGPOLL);
			goto reread;
		}
		goto rewrite;
	}
Done:
#ifdef TWO_PROCS
	kill(Child, SIGKILL);
#endif
	t_sndrel(rem);/* sleep(1);*/
	t_close(rem);
/*	_nolinger_tclose(rem);*/
	exit(0);
usage:
	fprintf(stderr,
	    "usage: %s host [ -l login ] [ -n ] command\n",cmdname);
	exit(1);
}

sendsig(signo)
	int signo;
{
	unsigned char c=signo;
	int cc;

	cc =t_snd(rfd2, &c, 1, 0);
	if (signo == SIGINT){
	    t_sndrel(rem);
	    t_close(rem);
/*		_nolinger_tclose(rem);*/
	    }
	exit(0);
}

sig_poll(sig)
{
	register int cc;
	char buf[1024];
	int cc1= 0;
	struct pollfd pollfd[2];
	register int rval;
	int flags = 0;


#ifndef TWO_PROCS
	  sighold(SIGPOLL); 
	  sighold(SIGALRM); 
#endif
	errno = 0;
	/*
	 * Poll the error and the input streams
	 */
#ifndef TWO_PROCS
	if (read_bits & (1<<rem)) {
		pollfd[0].fd = rem; pollfd[0].events = POLLIN;
	} else pollfd[0].fd = -1;
	if (read_bits & (1<<rfd2)) {
		pollfd[1].fd = rfd2; pollfd[1].events = POLLIN;
	} else pollfd[1].fd = -1;
#else
		pollfd[0].fd = rem; pollfd[0].events = POLLIN;
		pollfd[1].fd = rfd2; pollfd[1].events = POLLIN;
#endif
	for(;;){
		errno = 0;
#ifdef TWO_PROCS
		if ((rval = poll(pollfd, 2, -1)) < 0)
#else
		if ((rval = poll(pollfd, 2, 0)) < 0)
#endif
		{
			if (errno == EINTR)
				continue; 
			exit (0);
		}
		if (rval == 0)
#ifdef TWO_PROCS
			continue;
#else
			goto Out;
#endif
		if (pollfd[0].revents & POLLIN) {
reread1:
			errno = 0;
			t_errno = 0;
			cc = t_rcv (rem, buf, sizeof (buf), &flags);
			if (cc < 0 && ((t_errno == TNODATA)||(errno == EINTR)))
				goto Next;
			else {
				if (cc < 0 && (t_errno == TLOOK) ) {
					cc1 = t_look(rem);
					if (cc1 == T_ORDREL) 
						goto Next;
				}
				if (cc <= 0){
					/*
					 *  Generated by M_HANGUP from TCP
					 */
					read_bits &= ~(1<<rem);
					pollfd[0].fd = -1;
					goto Next;
				}
			}
			if (first == 0)
				remote = 1;
			write(1, buf, cc);
			pollfd[0].revents &= ~POLLIN;
		}
Next:
		if (pollfd[1].revents & POLLIN) {
			cc = t_rcv (rfd2, buf, sizeof (buf), &flags);
			if (cc < 0 && ((t_errno == TNODATA)||(errno == EINTR)))
#ifdef TWO_PROCS
				continue;
#else
				goto Out;
#endif
			else {
				if (cc <= 0) {
					read_bits &= ~(1<<rfd2);
					pollfd[1].fd = -1;
					goto Nowrite;
				}
			}
			write(2, buf, cc);
			pollfd[1].revents &= ~POLLIN;
		}
		if (pollfd[1].revents > 0) {
			read_bits &= ~(1<<rfd2);
			pollfd[1].fd = -1; /* Ignore next poll */
		}
Nowrite:
		if (pollfd[0].revents> 0  && cc1 == T_ORDREL) {
			read_bits &= ~(1<<rem);
			pollfd[0].fd = -1; /* Ignore next poll */
		}
		if (pollfd[0].fd == -1 && pollfd[1].fd == -1) {
			/*
			 * Hangup or error on both.
			 */
/*
			_nolinger_tclose(rem);
			_nolinger_tclose(rfd2);
			exit(0);
*/
		}
	}
Out:
#ifndef TWO_PROCS
	sigrelse(SIGALRM);
	sigrelse(SIGPOLL);
	if (!(read_bits &((1<<rem) | (1<<rfd2))))
		exit (0);
#endif /* TWO_PROCS */
}
