#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)inetinit.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/signal.h>
#include <sys/fcntl.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/if.h>
#include <sys/in.h>
#include <sys/in_var.h>
#include <sys/ip.h>
#include <sys/arp.h>
#include <sys/inetioctl.h>
#include <netdb.h>

#define CONFIGFILE	"/usr/etc/inetinit.cf" /* streams config. file */


/*
 * table of combinations of stream configuration
 */
struct confent {
	char *str_name;		/* stream name */
	char *dev_1;		/* lower driver */
	char *dev_2;		/* upper driver */
	char *myname;		/* local host name */
};

static struct confent co;
static FILE *configf = NULL;
static char line[BUFSIZ+1];
static int stayopen = 0;
static int fd_top_dev;
static ulong myinaddr = 0;
static ulong hisinaddr = 0;
static char *progname;
static int loglvl = 0;		/* default debug level */
static int confline = 0;
static int fdip = -1;
static int fdarp = -1;
static int fd_dev1, fd_dev2, fd_dev3;
static struct strioctl ioc;
static struct ifreq ifr;
static arpioctl aio;

extern char *optarg;
extern int optind;

main(argc, argv)
char *argv[];
{
	int i;

	progname = argv[0];

	while ((i = getopt(argc, argv, "l:")) != EOF) {

		switch(i) {

		case 'l':	/* logging level */
			loglvl = atoi(optarg);
			break;

		default:
			usage();
			break;
		}
	}

	/* process file name */
	setconfent(0, argv[optind]);
	if (configf == NULL) {
		perror ("open configfile");
		usage();
	}

	/*
	 * build the stream
	 */
	while (readconfline() != -1) {

		if (loglvl >= 5)
			(void)printarg();

		if (co.dev_2[0] == '/') {	/* Do I_LINK */

			if (link_dev() < 0) {
				Perror("link", "Failed to link",0);
				exit (2);
			}

			if (loglvl)
				printf ("%s: linked device %s on top of device %s\n", progname, co.dev_2, co.dev_1);

		} else {	/* push a module using I_STR ioctl */

			if (push_module() <0) {
				Perror("push","Failed to push module",1);
				exit (3);
			}

			if (loglvl)
				printf ("%s: pushed module %s on top of device %s\n", progname, co.dev_2, co.dev_1);

		}
	}
	if (confline == 0) {
		Perror("cmd","Empty inetinit.cf file",0);
		exit (4);
	}

	/*
	 *  Close stream configuration file
	 */
	endconfent();

	/*
	 * Put myself in the back-ground.
	 */
	if (fork())
		exit (0);
	setpgrp();
	signal (SIGINT, SIG_IGN);
	signal (SIGQUIT, SIG_IGN);
	signal (SIGHUP, SIG_IGN);

	for (;;) {
		/* stay alive forever */
		pause ();
	}

} /* end of main */


push_module()
{
	register int fd_dev1;

	if ((fd_dev1 = open (co.dev_1, O_RDWR)) < 0) {
		perror ("open co.dev_1");
		return -1;
	}

	if (ioctl(fd_dev1, I_PUSH, co.dev_2) < 0) {
		fprintf(stderr,"%s: push %s failed\n", progname,co.dev_2);
		perror("push");
		close(fd_dev1);
		return(-1);
	}

	if (loglvl >= 1)
		fprintf(stderr,"%s: push_module: %s above %s\n", progname, co.dev_2, co.dev_1);

	return(1);

} /* end of push_module */


/*
 * Link a specified device, and set its name and address if required.
 */
link_dev()
{
	int ifa_flag = 1;	/* set the interface address by default */

	if (strncmp(co.dev_1, "/dev/arp", 8) == 0 && fdarp != -1 ) {
		fd_dev1 = fdarp;
	} else if ((fd_dev1 = open(co.dev_1, O_RDWR)) < 0) {
		perror (co.dev_1);
		return -1;
	}

	if (strcmp(co.dev_2, "/dev/ip0") == 0) {
		if (fdip == -1) {
			if ((fdip = fd_dev2 = open(co.dev_2, O_RDWR)) < 0) {
				perror(co.dev_2);
				return -1;
			}
		} else {
			fd_dev2 = fdip;
		}
	} else if (strncmp(co.dev_2, "/dev/arp", 8 ) == 0) {
		if (fdarp != -1) {
			fprintf(stderr,"%s: must link %s to /dev/ip0 before reopening\n", progname, co.dev_2 );
			return -1;
		}
		if ((fdarp = fd_dev2 = open(co.dev_2, O_RDWR)) < 0) {
			perror(co.dev_2);
			return -1;
		}
	} else {
		if ((fd_dev2 = open(co.dev_2, O_RDWR)) < 0) {
			perror(co.dev_2);
			return -1;
		}
	}

	/*
	 * we need to set the top queue up in the arp driver now!
	 */
	if (strcmp(co.dev_1, "/dev/arp") == 0)
	{
		/* insert TOP queue ARP info */
		aio.at_in = myinaddr;
		ioc.ic_cmd = (int)ARP_INTOP;
		ioc.ic_timout = 60;
		ioc.ic_len = sizeof(aio);
		ioc.ic_dp = (char *)&aio;
		if (ioctl(fd_dev1, I_STR, &ioc) < 0) {
			perror("ARP_INTOP failed");
			return(-1);
		}
		ifa_flag = 0;
	}

	/*
	 * link co.dev_1 to co.dev_2
	 */
	if ((ifr.ifr_cookie = ioctl(fd_dev2, I_LINK, fd_dev1)) < 0) {
		perror("I_LINK bottom");
		return -1;
	}

	/* need to get the internet address */
	if ((myinaddr = getinaddr(co.myname)) == -1) {
		fprintf(stderr, "%s: can't determine my internet address\n", progname);
		return -1;
	} else if (myinaddr == 0)
		ifa_flag = 0;

	/*
	 * we need to double link the arp driver on top of the bottom driver
	 * and set up the inet/ethernet addresses in the kernel
	 */
	if (strncmp(co.dev_2, "/dev/arp", 8) == 0)
		if (arpsetup() == -1)
			return -1;
	
	/*
	 * If we're linking IP on top of something then
	 * we'll have to set it's name and interface address.
	 */
	if (strncmp(co.dev_2, "/dev/ip", 7) == 0)
		if (ipsetup(ifa_flag) == -1)
			return -1;
	close(fd_dev1); /* close the lower driver */
	if ( fd_dev1 == fdarp ) {
		fdarp = -1;
	}
	return 0;

} /* end of link_dev */


Perror(cmd,message,flag)
char *cmd;
char *message;
int flag;
{
	extern int errno;

	fprintf(stderr, "%s: config line #%d: ",progname,confline);
	fprintf(stderr, "%s\n",message);

	if (flag) {

		switch (errno) {

		default:
			perror(cmd);
			break;
		}
	}

	exit(1);

} /* end of Perror */


setconfent(f, file)
char *file;
int f;
{

	if (file == NULL)
		file = CONFIGFILE;

	if (configf == NULL)
		configf = fopen(file, "r" );
	else
		rewind(configf);

	stayopen |= f;

} /* end of setconfent */


endconfent()
{
	if (configf && !stayopen) {
		fclose(configf);
		configf = NULL;
	}

} /* end of endconfent */


readconfline()
{
	char *cp;
	char *p;
	int i;

again:
	if ((p = fgets(line, 128, configf)) == NULL) {
		return(-1);
	}

	confline++;

	if (loglvl >= 5) {
		printf(">>>>>>>>>>>next line<<<<<<<<<<<\n");
	}

	if (*p == '#')
		goto again;

	cp = p;

	/* THIS STUFF IS SPECIFIC */
	/*
	 * There are only 4 elements in the inetinit.cf file.
	 * Leaving this at 8 will dump core on AT&T 3b2/4000
	 */
	for (i = 1; i < 5; i++) {
		while (*cp == ' ' || *cp == '\t')
			cp++;
		if (*cp == '\n' || *cp == '#') goto again;
		p = cp;
		while (*cp != ' ' && *cp != '\t' && *cp != '\n') {
			cp++;
		}
		*cp = '\0';
		cp++;

		switch(i) {

		case 1:
			co.str_name = p;
			break;
		case 2:
			co.dev_1 = p;
			break;
		case 3:
			co.dev_2 = p;
			break;
		case 4:
			co.myname = p;
			break;
		}

	}

	return(0);

} /* end of readconfline */


usage()
{
	fprintf(stderr, "usage: %s %s\n", progname, 
		"[-l loglvl] [configfile]");
	exit(1);

} /* end of usage */


printarg()
{
	printf("%s<<\n", co.str_name);
	printf("%s<<\n", co.dev_1);
	printf("%s<<\n", co.dev_2);
	printf("%s<<\n", co.myname);
	fflush(stdout);

} /* end of printarg */


static
getinaddr(name)
char *name;
{
	struct hostent *hp;
	ulong inaddr;
	struct utsname un;
	struct hostent *_gethtbyname();

	/*
	 * if we're passed a null name then use the official host name
	 */
	if (strcmp(name, "0") == 0) {
		uname(&un);
		name = un.nodename;
	} else if (strcmp(name, "-") == 0) 
		return 0;

	hp = _gethtbyname(name);

	if (hp == (struct hostent *)0) {
		fprintf(stderr, "%s: unknown host %s\n", progname, name);
		return(-1);
	}

	bcopy(hp->h_addr, &inaddr, sizeof(ulong));

	if (loglvl > 10)
		fprintf(stdout, "%s: getinaddr returned %x for %s\n", progname, inaddr, name);

	return(inaddr);

} /* end of getinaddr */


static
arpsetup()
{
	int dlpi;

	/* fake DLPI PPA for now (WD8003E) */
	dlpi = 0x1 + ((co.str_name[2] - '0') << 8); 

	/* insert bottom queue ARP info */
	aio.at_time = ifr.ifr_cookie;
	aio.at_in = myinaddr;
	ioc.ic_cmd = (int)ARP_INSRC;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSRC failed");
		return(-1);
	}
#ifdef DLPI
	/* insert bottom queue PPA info */
	aio.at_in = dlpi;		/* need to add to inetinit.cf? */
	ioc.ic_cmd = (int)ARP_INPPA;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSRC failed");
		return(-1);
	}
#endif
	aio.at_in = ETHERPUP_ARPTYPE;
	ioc.ic_cmd = (int)ARP_INSAP;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSAP failed");
		return(-1);
	}

	/* open another stream to the bottom driver */
	if ((fd_dev3 = open(co.dev_1, O_RDWR)) < 0) {
		perror(co.dev_2);
		return(-1);
	}

	/* now do the second link */
	if ((aio.at_time = ioctl(fd_dev2, I_LINK, fd_dev3)) < 0) {
		perror("I_LINK bottom");
		return(-1);
	}

	/* insert bottom queue IP info */
	aio.at_in = myinaddr;
	ioc.ic_cmd = (int)ARP_INSRC;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSRC failed");
		return(-1);
	}
#ifdef DLPI
	/* insert bottom queue PPA info */
	aio.at_in = dlpi;		/* need to add to inetinit.cf? */
	ioc.ic_cmd = (int)ARP_INPPA;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSRC failed");
		return(-1);
	}
#endif
	aio.at_in = ETHERPUP_IPTYPE;
	ioc.ic_cmd = (int)ARP_INSAP;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSAP failed");
		return(-1);
	}
	close(fd_dev3);

	/* open another stream to the bottom driver */
	if ((fd_dev3 = open(co.dev_1, O_RDWR)) < 0) {
		perror(co.dev_2);
		return(-1);
	}

	/* now do the third link */
	if ((aio.at_time = ioctl(fd_dev2, I_LINK, fd_dev3)) < 0) {
		perror("I_LINK bottom");
		return(-1);
	}

	/* insert bottom queue IP info */
	aio.at_in = myinaddr;
	ioc.ic_cmd = (int)ARP_INSRC;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSRC failed");
		return(-1);
	}
#ifdef DLPI
	/* insert bottom queue PPA info */
	aio.at_in = dlpi;		/* need to add to inetinit.cf? */
	ioc.ic_cmd = (int)ARP_INPPA;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSRC failed");
		return(-1);
	}
#endif
	aio.at_in = ETHERPUP_RARPTYPE;
	ioc.ic_cmd = (int)ARP_INSAP;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(aio);
	ioc.ic_dp = (char *)&aio;
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("ARP_INSAP failed");
		return(-1);
	}
	close(fd_dev3);

#ifdef IEEESNAP
	/* Only attach SNAP if requested */
	if (strncmp(co.str_name, "el", 2) == 0)
	{
		/* open another stream to the bottom driver */
		if ((fd_dev3 = open(co.dev_1, O_RDWR)) < 0) {
			perror(co.dev_2);
			return(-1);
		}

		/* now do the third link */
		if ((aio.at_time = ioctl(fd_dev2, I_LINK, fd_dev3)) < 0) {
			perror("I_LINK bottom");
			return(-1);
		}

		/* insert bottom queue IP info */
		aio.at_in = myinaddr;
		ioc.ic_cmd = (int)ARP_INSRC;
		ioc.ic_timout = 60;
		ioc.ic_len = sizeof(aio);
		ioc.ic_dp = (char *)&aio;
		if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
			perror("ARP_INSRC failed");
			return(-1);
		}
#ifdef DLPI
		/* insert bottom queue PPA info */
		aio.at_in = dlpi;	/* need to add to inetinit.cf? */
		ioc.ic_cmd = (int)ARP_INPPA;
		ioc.ic_timout = 60;
		ioc.ic_len = sizeof(aio);
		ioc.ic_dp = (char *)&aio;
		if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
			perror("ARP_INSRC failed");
			return(-1);
		}
#endif
		aio.at_in = SNAP_SAP;
		ioc.ic_cmd = (int)ARP_INSAP;
		ioc.ic_timout = 60;
		ioc.ic_len = sizeof(aio);
		ioc.ic_dp = (char *)&aio;
		if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
			perror("ARP_INSAP failed");
			return(-1);
		}
		close(fd_dev3);
	}
#endif

	return (0);
} /* end of arpsetup */


static
ipsetup(flag)
{
	/*
	 * set its name so that it can be used by other programs.
	 */
	ioc.ic_cmd = IPIOC_SETNAME;
	ioc.ic_timout = 60;
	ioc.ic_len = sizeof(struct ifreq);
	ioc.ic_dp = (char *) &ifr;
	memcpy(ifr.ifr_name, co.str_name, strlen(co.str_name)+1);
	if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
		perror("IPIOC_SETNAME failed");
		return(-1);
	}
	
	/*
	 * set the interface address
	 */
	if (flag)
	{
		ioc.ic_cmd = IPIOC_SETIFADDR;
		ioc.ic_timout = 60;
		ioc.ic_len = sizeof(struct ifreq);
		ioc.ic_dp = (char *) &ifr;
		ifr.ifr_addr.sa_family = AF_INET;
		satosaddr(ifr.ifr_addr) = myinaddr;
		memcpy(ifr.ifr_name, co.str_name, strlen(co.str_name)+1);
		if (ioctl(fd_dev2, I_STR, &ioc) < 0) {
			perror("IPIOC_SETIFADDR Failed");
			return(-1);
		}
	}

	return (0);

} /* end of ipsetup */
