#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)netlogin.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * login [ name ]
 * login -r hostname (for rlogind)
 * login -h hostname (for telnetd, etc.)
 */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#ifdef BSD_42
#include <sys/quota.h>
#include <sys/resource.h>
#endif /* BSD_42 */

#ifdef SYSTEM5
#include <sys/stream.h>
#include <sys/ip.h>
#include <termio.h>
#include <fcntl.h>
#define TIOCGETP TCGETA
#define TIOCSETP TCSETA
#else
#include <sgtty.h>
#endif /* SYSTEM5 */
#include <sys/inet.h>
#include <sys/inetioctl.h>
#include <utmp.h>
#include <signal.h>
#include <pwd.h>
#include <stdio.h>
#include <lastlog.h>
#include <errno.h>
#include <syslog.h>

FILE *fp;

#define	SCPYN(a, b)	strncpy(a, b, sizeof(a))

#define NMAX	sizeof(utmp.ut_name)

#define	FALSE	0
#define	TRUE	-1

#define NETLGNTRC	"/tmp/netlgntrc"
char	nolog[] =	"/etc/nologin";
char	qlog[]  =	".hushlogin";
char	securetty[] =	"/etc/securetty";
#ifdef SYSTEM5
char	maildir[30] =	"/usr/mail/";
#else
char	maildir[30] =	"/usr/spool/mail/";
#endif /* SYSTEM5 */
char	lastlog[] =	"/usr/adm/lastlog";
struct	passwd nouser = {"", "nope", -1, -1, "", "", "", "", "" };
#ifdef SYSTEM5
struct termio ttyb;
#else
struct	sgttyb ttyb;
#ifdef BSD_42
struct	tchars tc = {
	CINTR, CQUIT, CSTART, CSTOP, CEOT, CBRK
};
struct	ltchars ltc = {
	CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT
};
#endif /* BSD_42 */
#endif /* SYSTEM5 */
struct	utmp utmp;
char	minusnam[16] = "-";

char	homedir[64] = "HOME=";
char	shell[64] = "SHELL=";
char	term[64] = "TERM=";
char	user[20] = "USER=";
#ifdef SYSTEM5
char s5logname[25] = "LOGNAME=";
#endif /* SYSTEM5 */

#ifdef BSD_42
char	*envinit[] =
    { homedir, shell, "PATH=:/usr/ucb:/bin:/usr/bin", term, user,s5logname, 0 };
#else
char	*envinit[] =
    { homedir, shell, "PATH=:/bin:/usr/bin", term, user,s5logname, 0 };
#endif /* BSD_42 */

struct	passwd *pwd;
struct	passwd *getpwnam();
char	*strcat(), *rindex(), *index();
char	*ttyname();
char	*crypt();
char	*getpass();
char	*stypeof();
extern	char **environ;
extern	int errno;


int	rflag;
char	rusername[NMAX+1], lusername[NMAX+1];
char	name[NMAX+1];
char	*rhost;
#define doremotelogin DoRemoteLogin

main(argc, argv)
	char *argv[];
{
	register char *namep;
	int t, f, c;
	int invalid, quietlog;
	FILE *nlfd;
	char *ttyn;
	int ldisc = 0, zero = 0;

#ifdef DEBUG
	if ( (fp = fopen(NETLGNTRC,"a+")) < 0 ) {
		printf("rlogind: failed opening trace file\n");
		fflush(stdout);
		exit (1);
	}
#endif /* DEBUG */
	signal(SIGQUIT, SIG_IGN);
	signal(SIGINT, SIG_IGN);
#ifdef BSD_42
	setpriority(PRIO_PROCESS, 0, 0);
	quota(Q_SETUID, 0, 0, 0);
#endif /* BSD_42 */
	SCPYN(lusername, "");
	/*
	 * Initialize utmp structure (he says, wishing for an initializer
	 * syntax for presetting structure members by name...).
	 * This mirrors the role of init, except that writing the utmp
	 * structure is postponed to avoid unnecessary writes.
	 */
	SCPYN(utmp.ut_name, "LOGIN");
#ifdef SYSTEM5
	utmp.ut_pid = getpid();
	utmp.ut_type = LOGIN_PROCESS;
#endif /* SYSTEM5 */
	/*
	 * -r is used by rlogind to cause the autologin protocol;
	 * -h is used by other servers to pass the name of the
	 * remote host to login so that it may be placed in utmp and wtmp
	 */
	if (argc > 1) {
		if (strcmp(argv[1], "-r") == 0) {
			rflag = 1;
#ifdef SYSTEM5
			strncpy(&utmp.ut_line[6], argv[2],6);
#else
			strncpy(&utmp.ut_line[3], argv[2],5);
#endif
			getstr(rusername, sizeof (rusername), "remuser");
			getstr(lusername, sizeof (lusername), "locuser");
			getstr(term+5, sizeof(term)-5, "Terminal type");
#ifdef DEBUG
			fprintf(fp,
				"rusername = %s, lusername = %s, term = %s\n",
				rusername, lusername, term);
			fflush(fp);
#endif /* DEBUG */
			argc = 0;
		}
		if (strcmp(argv[1], "-h") == 0 && getuid() == 0) {
#ifdef SYSTEM5
			strncpy(&utmp.ut_line[6], argv[2],6);
#else
			strncpy(&utmp.ut_line[3], argv[2],5);
#endif
			argc = 0;
		}
	}
	/*
	 * Initialize the pseudo tty.  This mirrors the role of getty.
	 */
#ifdef SYSTEM5
#else
	ioctl(0, TIOCLSET, &zero);
	ioctl(0, TIOCNXCL, 0);
#endif /* SYSTEM5 */
	ioctl(0, FIONBIO, &zero);
	ioctl(0, FIOASYNC, &zero);
	ioctl(0, TIOCGETP, &ttyb);
#ifdef DEBUG
	fprintf(fp,"main: af getting pty modes\n");
	fprintf(fp,"c_iflag %o\n", ttyb.c_iflag);
	fprintf(fp,"c_oflag %o\n", ttyb.c_oflag);
	fprintf(fp,"c_cflag %o\n", ttyb.c_cflag);
	fprintf(fp,"c_lflag %o\n", ttyb.c_lflag);
	fprintf(fp,"c_line %o\n", ttyb.c_line);
	fflush(fp);
#endif /* DEBUG */
#ifdef SYSTEM5
	ttyb.c_lflag |= ECHOE|ISIG|ICANON|ECHO|ECHONL;
#endif /* SYSTEM5 */
	/*
	 * If talking to an rlogin process,
	 * propagate the terminal type and
	 * baud rate across the network.
	 */
	if (rflag)
		doremoteterm(term, &ttyb);
#ifdef DEBUG
	fprintf(fp,"main: af doremoteterm\n");
	fprintf(fp,"c_iflag %o\n", ttyb.c_iflag);
	fprintf(fp,"c_oflag %o\n", ttyb.c_oflag);
	fprintf(fp,"c_cflag %o\n", ttyb.c_cflag);
	fprintf(fp,"c_lflag %o\n", ttyb.c_lflag);
	fprintf(fp,"c_line %o\n", ttyb.c_line);
	fflush(fp);
#endif /* DEBUG */
#ifdef BSD_42
	ioctl(0, TIOCSLTC, &ltc);
	ioctl(0, TIOCSETC, &tc);
#endif /* BSD_42 */
	ioctl(0, TIOCSETP, &ttyb);
#ifdef DEBUG
	ioctl(0, TIOCGETP, &ttyb);
	fprintf(fp,"main: af setting pty modes\n");
	fprintf(fp,"c_iflag %o\n", ttyb.c_iflag);
	fprintf(fp,"c_oflag %o\n", ttyb.c_oflag);
	fprintf(fp,"c_cflag %o\n", ttyb.c_cflag);
	fprintf(fp,"c_lflag %o\n", ttyb.c_lflag);
	fprintf(fp,"c_line %o\n", ttyb.c_line);
	fflush(fp);
#endif /* DEBUG */
#ifdef BSD_42
	for (t = getdtablesize(); t > 3; t--)
		close(t);
#endif /* BSD_42 */
	ttyn = ttyname(0);
	if (ttyn==(char *)0)
		ttyn = "/dev/tty??";
#ifdef BSD_42
	ldisc = 0;
	ioctl(0, TIOCSETD, &ldisc);
#endif /* BSD_42 */
	invalid = FALSE;
	/*
	 * Name specified, take it.
	 */
	if (argc > 1) {
		SCPYN(lusername, argv[1]);
		lusername[NMAX] = 0;
		argc = 0;
	}
#ifdef BSD_42
	if (!strcmp(pwd->pw_shell, "/bin/csh")) {
		ldisc = NTTYDISC;
		ioctl(0, TIOCSETD, &ldisc);
	}
#endif /* BSD_42 */
	/*
	 * This site may wish to exert different login controls.
	 * To accomodate this, we look for an executable
	 * /etc/bypasswin file and turn over complete control
	 * if found.  Local user name, remote host name, and
	 * remote user name, and are passed on for /etc/bypasswin's
	 * use.  Remote host name is passed in the form "RHOST=x"
	 * and remote user name in the form "RLOGNAME=y" so that
	 * /etc/bypasswin can be simply linked to /bin/login to
	 * disable autologin, with the side effect of including the
	 * RHOST and RLOGNAME values in the environment.  For a
	 * non-rlogin call, these two parameters are omitted and
	 * argc<3 (so you know autologin checks don't apply).
	 */
	if (access("/etc/bypasswin", 1) == 0) {
		char rhost[64];
		char rlogname[sizeof "RLOGNAME=" + NMAX+1];
		rhost[0] = '\0';
		if (rflag) {
			SCPYN(rhost, "RHOST=");
			strncat(rhost, argv[2], sizeof rhost - sizeof "RHOST=");
			SCPYN(rlogname, "RLOGNAME=");
			strncat(rlogname, rusername, NMAX);
		}
#ifdef SYSTEM5
		utmpslot(ttyn);
#endif /* SYSTEM5 */
		execl("/etc/bypasswin", "login",
		      lusername, rhost, rlogname, (char *)0);
		perror("/etc/bypasswin exec failed");
		exit(1);
	}
	/*
	 * If remote login use given name,
	 * otherwise use /bin/login to prompt user appropriately.
	 */
	if (rflag) {
		rflag = doremotelogin(argv[2]);
		/* if autologin failed, prompt for passwd */
		if (rflag == -1)
			rflag = 0;
	}
	/*
	 * If no remote login authentication,
	 * /bin/login will handle further checking.
	 */
	if (!rflag) {
#ifdef SYSTEM5
		utmpslot(ttyn);
#endif /* SYSTEM5 */
		execl("/bin/login", "login", lusername, (char *)0);
		perror("Can't exec /bin/login");
		exit(1);
	}
	/*
	 * Handle authenticated remote login.
	 * This mirrors the role of the login program, sans the
	 * check for a valid password.  Therefore, what follows
	 * should reflect the actions of /bin/login, and is affected
	 * by changes therein.
	 */
	SCPYN(utmp.ut_name, lusername);
	utmp.ut_type = USER_PROCESS;
	/*
	 * If user not super-user, check for logins disabled.
	 */
	if (pwd->pw_uid != 0 && (nlfd = fopen(nolog, "r")) > 0) {
		while ((c = getc(nlfd)) != EOF)
			putchar(c);
		fflush(stdout);
		sleep(5);
		exit(0);
	}
	/*
	 * If valid so far and root is logging in,
	 * see if root logins on this terminal are permitted.
	 */
	if (!invalid && pwd->pw_uid == 0 &&
	    !rootterm(ttyn+sizeof("/dev/")-1)) {
		logerr("ROOT LOGIN REFUSED %s",
		    ttyn+sizeof("/dev/")-1);
		invalid = TRUE;
	}
	if (invalid) {
		printf("Login incorrect\n");
		if (ttyn[sizeof("/dev/tty")-1] == 'd')
			logerr("BADDIALUP %s %s",
			    ttyn+sizeof("/dev/")-1, utmp.ut_name);
	}
	if (pwd->pw_shell == 0 || *pwd->pw_shell == '\0')
		pwd->pw_shell = "/bin/sh";
	if (chdir(pwd->pw_dir) < 0 && !invalid ) {
		if (chdir("/") < 0) {
			printf("No directory!\n");
			invalid = TRUE;
		} else {
			printf("No directory! %s\n",
			   "Logging in with home=/");
			pwd->pw_dir = "/";
		}
	}
	/*
	 * Remote login invalid must have been because
	 * of a restriction of some sort, no extra chances.
	 */
	if (invalid)
		exit(1);
#ifdef DEBUG
	fprintf(fp,"main: af handling login\n");
	fflush(fp);
#endif /* DEBUG */

#ifdef BSD_42
	if (quota(Q_SETUID, pwd->pw_uid, 0, 0) < 0) {
		if (errno == EUSERS)
			printf("%s.\n%s.\n",
			   "Too many users logged on already",
			   "Try again later");
		else if (errno == EPROCLIM)
			printf("You have too many processes running.\n");
		else
			perror("setuid");
		sleep(5);
		exit(0);
	}
#endif /* BSD_42 */
	time(&utmp.ut_time);
#ifdef SYSTEM5
	t = utmpslot(ttyn);
#else
	t = ttyslot();
	if (t <= 0 )
		t = findslot(ttyn);
	if (t > 0 && (f = open("/etc/utmp", 1)) >= 0) {
		lseek(f, (long)(t*sizeof(utmp)), 0);
		strncpy(utmp.ut_line, rindex(ttyn, '/')+4,2);
		utmp.ut_line[3]='.';
		write(f, (char *)&utmp, sizeof(utmp));
		close(f);
	}
#endif /* SYSTEM5 */
	if (t != 0 && (f = open(WTMP_FILE, 1)) >= 0) {
		lseek(f, 0L, 2);
		write(f, (char *)&utmp, sizeof(utmp));
		close(f);
	}
	quietlog = access(qlog, 0) == 0;
	if ((f = open(lastlog, 2)) >= 0) {
		struct lastlog ll;

		lseek(f, (long)pwd->pw_uid * sizeof (struct lastlog), 0);
		if (read(f, (char *) &ll, sizeof ll) == sizeof ll &&
		    ll.ll_time != 0 && !quietlog) {
			printf("Last login: %.*s ",
			    24-5, (char *)ctime(&ll.ll_time));
			if (*ll.ll_host != '\0')
				printf("from %.*s\n",
				    sizeof (ll.ll_host), ll.ll_host);
			else
				printf("on %.*s\n",
				    sizeof (ll.ll_line), ll.ll_line);
		}
		lseek(f, (long)pwd->pw_uid * sizeof (struct lastlog), 0);
		time(&ll.ll_time);
#ifdef SYSTEM5
		strncpy(ll.ll_line, rindex(ttyn, '/')+4,6);
		SCPYN(ll.ll_host, &utmp.ut_line[6]);
#else
		strncpy(ll.ll_line, rindex(ttyn, '/')+4,2);
#endif /* SYSTEM5 */
		write(f, (char *) &ll, sizeof ll);
		close(f);
	}
	chown(ttyn, pwd->pw_uid, pwd->pw_gid);
	chmod(ttyn, 0622);
	setgid(pwd->pw_gid);
	strncpy(name, utmp.ut_name, NMAX);
	name[NMAX] = '\0';
#ifdef BSD_42
	initgroups(name, pwd->pw_gid);
	quota(Q_DOWARN, pwd->pw_uid, (dev_t)-1, 0);
#endif 
	setuid(pwd->pw_uid);
	environ = envinit;
	strncat(homedir, pwd->pw_dir, sizeof(homedir)-6);
	strncat(shell, pwd->pw_shell, sizeof(shell)-7);
	if (term[strlen("TERM=")] == 0)
		strncat(term, stypeof(ttyn), sizeof(term)-6);
	strncat(user, pwd->pw_name, sizeof(user)-6);
	strncat(s5logname, pwd->pw_name, sizeof(user)-9);
	if ((namep = rindex(pwd->pw_shell, '/')) == NULL)
		namep = pwd->pw_shell;
	else
		namep++;
	strcat(minusnam, namep);
	umask(022);
	if (ttyn[sizeof("/dev/tty")-1] == 'd')
		logerr("DIALUP %s %s",
		    ttyn+sizeof("/dev/")-1, pwd->pw_name);
	if (!quietlog) {
#ifndef SYSTEM5
		showmotd();
#endif /* SYSTEM5 */
#ifndef SYSTEM5
		strcat(maildir, pwd->pw_name);
		if (access(maildir,4)==0) {
			struct stat statb;
			stat(maildir, &statb);
			if (statb.st_size)
				printf("You have mail.\n");
		}
#endif /* SYSTEM5 */
	}
	signal(SIGALRM, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
	signal(SIGINT, SIG_DFL);
	signal(SIGCLD,SIG_DFL);
#ifdef SIGTSTP
	signal(SIGTSTP, SIG_IGN);
#endif /* SIGTSTP */
	/*
	 * Flush stdin and clean up the terminal
	 */
#ifdef SYSTEM5
	ioctl(0,TCFLSH,0);	/* Flush the input queue */
#endif /* SYSTEM5 */
		
#ifdef DEBUG
ioctl(0,TIOCGETP,&ttyb);
fprintf(fp,"main: b4 exec shell\n");
fprintf(fp,"c_iflag %o\n", ttyb.c_iflag);
fprintf(fp,"c_oflag %o\n", ttyb.c_oflag);
fprintf(fp,"c_cflag %o\n", ttyb.c_cflag);
fprintf(fp,"c_lflag %o\n", ttyb.c_lflag);
fprintf(fp,"c_line %o\n", ttyb.c_line);
fflush(fp);
#endif /* DEBUG */
	execl(pwd->pw_shell, minusnam, 0);
	perror(pwd->pw_shell);
	printf("No shell\n");
	exit(0);
}

int	stopmotd;
catch()
{

	signal(SIGINT, SIG_IGN);
	stopmotd++;
}

rootterm(tty)
	char *tty;
{
	register FILE *fd;
	char buf[100];

	if ((fd = fopen(securetty, "r")) == NULL)
		return(1);
	while (fgets(buf, sizeof buf, fd) != NULL) {
		buf[strlen(buf)-1] = '\0';
		if (strcmp(tty, buf) == 0) {
			fclose(fd);
			return(1);
		}
	}
	fclose(fd);
	return(0);
}

showmotd()
{
	FILE *mf;
	register c;

	signal(SIGINT, catch);
	if ((mf = fopen("/etc/motd","r")) != NULL) {
		while ((c = getc(mf)) != EOF && stopmotd == 0)
			putchar(c);
		fclose(mf);
	}
	signal(SIGINT, SIG_IGN);
}

#undef	UNKNOWN
#define UNKNOWN "Mz"	/* Most common Terminal Type */

char *
stypeof(ttyid)
	char *ttyid;
{
	static char typebuf[16];
	char buf[50];
	register FILE *f;
	register char *p, *t, *q;

	if (ttyid == NULL)
		return (UNKNOWN);
	f = fopen("/etc/ttytype", "r");
	if (f == NULL)
		return (UNKNOWN);
	/* split off end of name */
	for (p = q = ttyid; *p != 0; p++)
		if (*p == '/')
			q = p + 1;

	/* scan the file */
	while (fgets(buf, sizeof buf, f) != NULL) {
		for (t = buf; *t != ' ' && *t != '\t'; t++)
			;
		*t++ = 0;
		while (*t == ' ' || *t == '\t')
			t++;
		for (p = t; *p > ' '; p++)
			;
		*p = 0;
		if (strcmp(q,t) == 0) {
			strcpy(typebuf, buf);
			fclose(f);
			return (typebuf);
		}
	}
	fclose (f);
	return (UNKNOWN);
}

doremotelogin(host)
	char *host;
{
	FILE *hostf;
	int first = 1;

	if (getuid()) {
		pwd = &nouser;
		goto bad;
	}
	setpwent();
	pwd = getpwnam(lusername);
	endpwent();
	if (pwd == NULL) {
		pwd = &nouser;
		goto bad;
	}
	hostf = pwd->pw_uid ? fopen("/etc/hosts.equiv", "r") : 0;
again:
	if (hostf) {
		char ahost[32];

		while (fgets(ahost, sizeof (ahost), hostf)) {
			char *user;

			if ((user = index(ahost, '\n')) != 0)
				*user++ = '\0';
			if ((user = index(ahost, ' ')) != 0)
				*user++ = '\0';
			if (!strcmp(host, ahost) &&
			    !strcmp(rusername, user ? user : lusername)) {
				fclose(hostf);
#ifdef DEBUG
				fprintf(fp,"doremotelogin: returning 1\n");
				fflush(fp);
#endif /* DEBUG */
				return (1);
			}
		}
		fclose(hostf);
	}
	if (first == 1) {
		char *rhosts = ".rhosts";
		struct stat sbuf;

		first = 0;
		if (chdir(pwd->pw_dir) < 0)
			goto again;
#ifdef BSD_42
		if (lstat(rhosts, &sbuf) < 0)
			goto again;
		if ((sbuf.st_mode & S_IFMT) == S_IFLNK) {
			printf("login: .rhosts is a soft link.\r\n");
			goto bad;
		}
#endif /* BSD_42 */
		hostf = fopen(rhosts, "r");
		fstat(fileno(hostf), &sbuf);
		if (sbuf.st_uid && sbuf.st_uid != pwd->pw_uid) {
			printf("login: Bad .rhosts ownership.\r\n");
			fclose(hostf);
			goto bad;
		}
		goto again;
	}
bad:
#ifdef DEBUG
	fprintf(fp,"doremotelogin: returning -1\n");
	fflush(fp);
#endif /* DEBUG */
	return (-1);
}

getstr(buf, cnt, err)
	char *buf;
	int cnt;
	char *err;
{
	char c;

	do {
		if (read(0, &c, 1) != 1)
			exit(1);
		if (--cnt < 0) {
			printf("%s too long\r\n", err);
			exit(1);
		}
		*buf++ = c;
	} while (c != 0);
}


char	*speeds[] =
    { "0", "50", "75", "110", "134", "150", "200", "300",
      "600", "1200", "1800", "2400", "4800", "9600", "19200", "38400" };
#define	NSPEEDS	(sizeof (speeds) / sizeof (speeds[0]))

doremoteterm(term, tp)
	char *term;
#ifdef SYSTEM5
	struct termio *tp;
#else
	struct sgttyb *tp;
#endif /* SYSTEM5 */
{
	char *cp = index(term, '/');
	register int i;

#ifdef SYSTEM5
	tp->c_cflag = CBAUD|CS8;
#else
	tp->sg_ispeed = tp->sg_ospeed = EXTB;
#endif /* SYSTEM5 */
	if (cp) {
		*cp++ = 0;
		for (i = 0; i < NSPEEDS; i++)
			if (!strcmp(speeds[i], cp)) {
#ifdef SYSTEM5
				tp->c_cflag &= ~CBAUD;
				tp->c_cflag |= CBAUD & i;
#else
				tp->sg_ispeed = tp->sg_ospeed = i;
#endif /* SYSTEM5 */
				break;
			}
	}
#ifdef SYSTEM5
	tp->c_oflag = OPOST|ONLCR|TAB3;
	tp->c_iflag = IGNPAR|ISTRIP|ICRNL;
	tp->c_lflag = ISIG|ICANON|ECHO|ECHOE|ECHOK;
#else
	tp->sg_flags = ECHO|CRMOD|ANYP|XTABS;
#endif /* SYSTEM5 */
}

logerr(fmt, a1, a2, a3)
	char *fmt, *a1, *a2, *a3;
{
#ifdef LOGERR
	FILE *cons = fopen("/dev/console", "w");

	if (cons != NULL) {
		fprintf(cons, fmt, a1, a2, a3);
		fprintf(cons, "\n\r");
		fclose(cons);
	}
#endif
}
#ifndef SYSTEM5
findslot(tp)
char *tp;
{
	char buf[200];
	FILE *fp;
	register int slot =0;
	register char *cp, *bp;

	if ((fp = fopen("/etc/inittab","r"))==NULL)
		return 0;
	cp = rindex(tp,'/')+1;
	for (slot = 0; fgets(buf,sizeof(buf),fp);){
		bp = buf;
		/*
		 * Inittab entries look :
		 *
		 * 	id:rstate:action:process
		 *
		 * Skip to the process field in inittab
		 */
#ifdef mc68k
		if(*bp == ':')	/* Ignore comments */
			continue;
#endif /* mc68k */
		bp = index(buf,':'); bp = index(++bp,':'); bp = index(++bp,':');
		/*
		 * Skip past the getty entry
		 */
		while (*bp != ' ' && *bp != '\t')
			bp++;
		while ( *bp == ' ' || *bp == '\t')
			bp++;
		/*
		 * We are down to ttypx part
		 */	
		if (!strncmp(cp,bp,5)){
			fclose(fp);
			return slot;
		}
		slot++;
	}
	fclose(fp);
	return 0;
}
#endif /* SYSTEM5 */
utmpslot (ttyline)
char *ttyline;
{
	struct utmp ut;
	char *ttyn;
	register f, len;

	ttyn = rindex(ttyline, '/');
	if(ttyn == 0)
		ttyn = ttyline;
	else
		ttyn++;
	if ((f = open(UTMP_FILE, O_RDWR)) < 0)
		return(0);
	len = strlen(ttyn);
#ifdef DEBUG
	syslog(LOG_DEBUG, "netlogin: ttyn = %s len = %d", ttyn, len);
#endif
	while(read(f, &ut, sizeof(ut)) == sizeof(ut)) {
		if(strncmp(ut.ut_line, ttyn, len) == 0) {
			strcpy(utmp.ut_line, ttyn);
			strncpy(utmp.ut_id, utmp.ut_line+3, 4);
			lseek(f, -(long)sizeof (ut), 1);
			write(f, (char *)&utmp, sizeof(ut));
			close(f);
			return(1);
		} 
	}
	lseek(f, 0L, 2);
	strcpy(utmp.ut_line, ttyn);
	strncpy(utmp.ut_id, utmp.ut_line+3, 4);
	write(f, (char *)&utmp, sizeof(ut));
	close(f);
	return(1);
}
