#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)remshd.c (TWG)  1.2     89/08/30 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/stream.h>

#include <sys/ip.h>
#include <sys/tcp.h>
#include <sys/in.h>

#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <netdb.h>
#include <tiuser.h>
#include <sys/stropts.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#ifdef	SECURITY
#include <auth.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/security.h>
#include <sys/audit.h>
#endif	/* SECURITY */

extern int	errno, t_errno;
#ifndef USG
int	reapchild();
#endif /* USG */
int ppid;
int Parent, Child;
struct	passwd *getpwnam();
int pv[2], neterr, readfrom, pid;
char	*index(), *rindex() /*, *sprintf() */;
int	options;
int sig_poll();
FILE *file;
/*
#define trace(x,y) { fprintf(file,x,y); fflush(file);}
*/
#define trace(x,y) 
int loginfo = 1;
int	error();
/*
 * remote shell server:
 *	remuser\0
 *	locuser\0
 *	command\0
 *	data
 */
/* VARARGS 1 */
main(argc, argv)
	int argc;
	char **argv;
{

	struct sockaddr_in from;
	int fromlen = sizeof(from);
	/*
	 * When fired up tcplisten
	 * argv[1] is the host.
	 */
	getpeername(0, &from, &fromlen);
	doit (0, &from);
}


char	username[20] = "USER=";	/* Only 8 char user names in UNIX */
char	logname[20] = "LOGNAME=";	/* Only 8 char user names in UNIX */
char	homedir[64] = "HOME=";
char	shell[64] = "SHELL=";
char	tz[32] = "TZ=";
char	*getenv();
char	*envinit[] =
	    {homedir, shell, tz, logname,
  		 "PATH=:/usr/lbin:/bin:/usr/bin", username, 0};
extern char	**environ;
extern int exit();

doit(f, fromp)
	int f;
	struct sockaddr_in *fromp;
{
	char cmdbuf[NCARGS+1], *cp;
	char locuser[16], remuser[16];
	struct passwd *pwd;
	int s, backoff;
	struct hostent *hp;
	short port;
	int   ready,  cc;
	char buf[BUFSIZ], sig;
	int one = 1;
	struct t_call scall,  *sndcall = &scall;
	struct stat st;

	if(loginfo && stat("/tmp/rshdlog", &st) < 0)
		loginfo = 0;
	else
		file = fopen("/tmp/rshdlog","a+");
	(void) signal(SIGINT, SIG_DFL);
	(void) signal(SIGQUIT, SIG_DFL);
	(void) signal(SIGTERM, SIG_DFL);
	(void) signal(SIGCLD, SIG_DFL);
	if ( ntohs(fromp->sin_port) >= IPPORT_RESERVED) {
		fprintf(stderr, "remshd: Invalid Port\n");
		exit(1);
	}
	(void) alarm(60);
	port = 0;
	/*
	 * Get the Port number to hook up to.
	 */
	for (;;) {
		char c;
		if (read(f, &c, 1) != 1) {
			perror("remshd: read");
			/* shutdown(f, 1+1); */
			exit(1);
		}
		if (c == 0)
			break;
		port = port * 10 + c - '0';
	}
	(void) alarm(0);
	trace("Got port %d\n", port);
	if (port != 0) {
		int lport = IPPORT_RESERVED - 1, retry = 0;
		neterr = rresvport(&lport, 0);
		if (neterr < 0) {
			trace("No port to reserve..\n",0);
			perror("remshd: can't get stderr port");
			exit(1);
		}
		if (port >= IPPORT_RESERVED) {
			fprintf(stderr, "remshd: 2nd port not reserved\n");
			exit(1);
		}
		fromp->sin_port = htons((u_short)port);
		sndcall->addr.buf = (char *)fromp;
		sndcall->addr.len = TCP_BINDADDRLEN;
		sndcall->udata.len = sndcall->opt.len = 0;
		try_again:
		trace("Connecting to error..(lport %d)", lport);
		trace("Connecting to error..(fport %d)", port);
		if (t_connect(neterr, sndcall, 0) < 0) {
			if (retry++ > 3) {
				perror("remshd: connect");
				exit(1);
			}
			sleep (1);
			goto try_again;
		}
		readfrom |= (1<<neterr);
	}
	trace("Connected to %x\n", fromp->sin_addr.s_addr);
	hp = gethostbyaddr(&fromp->sin_addr, sizeof (struct in_addr),
		fromp->sin_family);
	if (hp == 0) {
		error("Host name for your address unknown\n");
		exit(1);
	}
	getstr(remuser, sizeof(remuser), "remuser");
	getstr(locuser, sizeof(locuser), "locuser");
	getstr(cmdbuf, sizeof(cmdbuf), "command");
	trace("remote %s\n", remuser);
	if(loginfo) {
		fprintf(file,"Host:%s   Remote:%s   Local:%s   Cmd:%s\n",
			hp->h_name,remuser,locuser, cmdbuf); 
		fflush(file);
	}
	setpwent();
	pwd = getpwnam(locuser);
	if (pwd == NULL) {
		error("Login incorrect.\n");
		exit(1);
	}
	endpwent();
	if (chdir(pwd->pw_dir) < 0) {
		error("No remote directory.\n");
		sleep(2);
		exit(1);
	}
	if (useraccess(locuser) == 0 ||
	    ruserok(hp->h_name, pwd->pw_uid == 0, remuser, locuser) < 0) {
  		char tmpbuf[128];
  		sprintf(tmpbuf,"Permission denied for %s@%s\n",
  			remuser,hp->h_name);
  		error(tmpbuf);
		sleep(2);
		exit(1);
	}
	(void) write(2, "\0", 1);
	if (port) {
		int cleanup();
		if (pipe(pv) < 0) {
			error("Can't make pipe.\n");
			exit(1);
		}
		signal (SIGCLD, cleanup);
		pid = fork();
		if (pid == -1)  {
			error("Try again.\n");
			exit(1);
		}
		if (pid) {
			extern exit();
			int cleanup();
			/*
			 * Read From Pipe and write to the
			 * network.
			 */
			/* (void) close(0);  */ (void) close(1);(void) close(2);
			(void) close(pv[1]);
			readfrom |=  (1<<pv[0]);
			signal(SIGCLD, cleanup);
			Parent = getpid();
#ifdef TWO_PROCS
			/*
			 * If the shell process dies
			 * Then we can kill off the child
			 */
			Child = fork();
			if (Child < 0){
				error("No more processes\n");
				exit(1);
			}
			if (Child == 0){
				trace("Child reading from net.\n",0);
				sig_poll(SIGPOLL);
				kill(Parent, SIGKILL);
				exit(1);
			}
			(void)t_close(neterr);
			(void)setpgrp();/* We don't want to be kill */
#else
			t_sync(neterr);
			fcntl(neterr, F_SETFL, (O_NDELAY| fcntl(neterr,F_GETFL,0)));
			sigset(SIGPOLL, sig_poll);
			ioctl(neterr, I_SETSIG, S_INPUT);
			sig_poll(SIGPOLL);/* Pretend we just got a signal */
#endif /* TWO_PROCS */
			do {
				int cc1;
				errno = 0;
				if (readfrom & (1<<pv[0])) {
					errno = 0;
					try_read:
					cc = read(pv[0], buf, sizeof (buf));
					trace("read %d from pipe\n",cc);
					if (cc < 0 && errno == EINTR)
						goto try_read;
					if (cc <= 0) {
						(void)t_sndrel(neterr);
						sleep(1);
#ifdef TWO_PROCS
						exit(1);
#else
						readfrom &= ~(1<<pv[0]);
#endif
					} else 
					{
							cc1 = t_snd(neterr,
								 buf, cc, 0);
					}
				}
				/*
				 * If network error is set pause.
				 */
				else  if (readfrom & (1<<neterr)){
					exit (0); /* Is this OK ??? */
				}
				else break;
			} while (readfrom);
  			kill(0,15);
			_nolinger_tclose(neterr);
			exit(0);
		}
		(void) t_close(neterr); (void) close(pv[0]);  close (2); 
		dup2(pv[1], 2);
		close(pv[1]);
		fcntl(2, F_SETFL, (O_NDELAY| fcntl(2,F_GETFL,0)));
		t_sync(0);
		t_sync(1);
	}
	if ( pwd->pw_shell==NULL || *pwd->pw_shell == '\0' )
		pwd->pw_shell = "/bin/sh";
	/*initgroups(pwd->pw_name, pwd->pw_gid);*/
	audit(locuser, 0);
	(void) setgid(pwd->pw_gid);
	(void) setuid(pwd->pw_uid);
#ifdef USG
	strcat(tz, getenv("TZ"));
#endif
	environ = envinit;
	strncat(homedir, pwd->pw_dir, sizeof(homedir)-6);
	strncat(shell, pwd->pw_shell, sizeof(shell)-7);
	strncat(username, pwd->pw_name, sizeof(username)-6);
	strncat(logname, pwd->pw_name, sizeof(logname)-9);
	cp = rindex(pwd->pw_shell, '/');
	if (cp)
		cp++;
	else
		cp = pwd->pw_shell;
	trace("execing %s\n", cp);
	if(loginfo) fclose(file);
	signal(SIGCLD, SIG_DFL);
	execl(pwd->pw_shell, cp, "-c", cmdbuf, 0);
	write(2,"No EXEC\n",8);
	perror(pwd->pw_shell);
	sleep(2);
	exit(1);
protofail:
	error("rsh: protocol failure detected by remote\n");
	exit(1);
}

/* VARARGS 1 */
error(fmt)
	char *fmt;
{
	char buf[BUFSIZ];

	buf[0] = 1;
	(void) sprintf(buf+1, fmt);
	(void) write(2, buf, strlen(buf));
}

getstr(buf, cnt, err)
	char *buf;
	int cnt;
	char *err;
{
	char c;

	do {
		if (read(0, &c, 1) != 1)
			exit(1);
		*buf++ = c;
		if (--cnt == 0) {
			error("%s too long\n", err);
			exit(1);
		}
	} while (c != 0);
}
sig_poll(sig)
{
	register int cc;
	unsigned char sig;
	int flags;
	extern t_errno;

	sighold(SIGPOLL);

	for(;readfrom & (1<<neterr);){
		cc = t_rcv(neterr, &sig, 1, &flags);
		if (cc < 0 && t_errno == TNODATA)
			break;
		else
		 if (cc <= 0) {
			/*
			 * Turn off the neterr bit.
			 * The other end will come out of the pause
			 * and exit.
			 */
			_nolinger_tclose(neterr);
			readfrom &= ~(1<<neterr);
			break;
		}
 		if (kill(-Parent, sig) < 0 ) {
  		 cc =	kill(pid, sig);
		}
	}
#ifdef TWO_PROCS
	exit(0);
#endif
	sigrelse(SIGPOLL);
}
Conprint(fmt, a1, a2)
{
	FILE *fp;

	if (fp = fopen("/dev/console", "w")){
		fprintf(fp, fmt, a1, a2);
		fclose(fp);
	}
}
cleanup()
{
	char buf [1000];
	register int cnt;

	fcntl (pv[0], F_SETFL, O_NDELAY);
#ifdef TWO_PROCS
	kill(Child, SIGKILL);
	exit(0);
#endif /* TWO_PROCS */
	for (;;){
		cnt = read(pv[0],buf,sizeof(buf));
		if (cnt == 0) return;
		if (cnt <  0 && errno == EINTR)
			continue;
		if (cnt < 0) {
			(void)t_sndrel(neterr);
			readfrom &= ~(1 << neterr);
			return;
		}
		else 
			(void)t_snd(neterr,buf,cnt,0);
	}
}

/* write audit record */
audit(uname, mode)
char *uname;
int mode;
{	
#ifdef	SECURITY
	sat_login_t buf;

	buf.flag = LOGIN_ID;
	if ( mode )
		buf.flag |= LOGIN_FAIL;
	buf.mode = mode;
	buf.tty = 0;
	strcpy( buf.uname, uname, DIRSIZ ); 
	if ( audit_add_event( AUD_LOGIN, &buf, sizeof( sat_login_t )) < 0 )
		if ( errno != ENOSYS )
			fprintf( stderr, "login: can't write audit record\n" );
#endif	/* SECURITY */
}
