/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)rename.c (TWG)  1.2     89/06/20 "

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <signal.h>
rename(old,new)
char *old, *new;
{
	struct stat stbuf;
	extern errno;
	int (*oldval)();
	
	errno=0;
	if ( stat(old,&stbuf) < 0 )
		return -1;
	if ((stbuf.st_mode & S_IFMT) == S_IFDIR ){
		/*
		 * The old fork and exec routine
		 */
		register int pid, retval;
		char *path, *rindex();
		int status;

		if(stat(new,&stbuf) >= 0) {
			if(rmdir(new) < 0)
				return -1;
		} else {
			if(errno != ENOENT) return(-1);
			/* test the parent directory */
			if(path = rindex(new,'/')) {
				if(path != new) {
					*path=0;
					retval = stat(new,&stbuf);
					*path = '/';
					if(retval < 0)
						return(-1);
				}
			}
		}
		oldval = (int (*)())signal(SIGCLD, SIG_DFL);
		if (( pid = fork())<0)
			return -1;
		if ( pid == 0 ){
			execl("/bin/mv","mv",old,new,0);
			exit(0277);
		}
		while(pid != wait(&status))
			;
		(void) signal(SIGCLD, oldval);
		if(status & 0xff00) {
			if (( status >> 8 ) == 0277)
				errno = EPERM;
			else
				errno = EPERM;
			return(-1);
		}
		return 0;
	}
	/*
	 * DO the old link unlink combo
	 */
	if (unlink(new) < 0 && errno != ENOENT)
		return -1;
	if ( link ( old,new) < 0 )
		return -1;
	if ( unlink(old) < 0 ){
		unlink(new);
		return -1;
	}
	return 0;
}
