#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)setitimer.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/

#include <sys/time.h>
#include <sys/signal.h>
#include <errno.h>

/*
 * Must set the handler for SIGALRM with sigvec() instead 
 * of signal() for this to work right.
 * With sigvec() there is no need to reinstall the handler
 * after it is delivered (behaves like BSD4.3). 
 */

long ItimerVal;
int (*Alarm_Func)();
static int Alarm_Call();

setitimer(which, val, oval)
	register struct itimerval *val, *oval;
{
	register long tim;
	int (*func)();
	extern errno;

	if (which == ITIMER_PROF) {
		errno = EINVAL;
		return -1;
	}
	/*
	 * Treat the real and virtual as identical.
	 * Trap the SIGALRMs and Reset it and fire it up.
	 */
	func = (int (*)())signal(SIGALRM, Alarm_Call);
	/*
	 * Set the function to call on SIGALRM
	 */
	if (func != Alarm_Call)
		Alarm_Func = func;
	tim = alarm(0);
	if (oval) {
		oval->it_interval.tv_sec = ItimerVal;
		oval->it_interval.tv_usec = 0;
		oval->it_value.tv_sec = tim;
		oval->it_value.tv_usec = 0;
	}
	if (val->it_value.tv_usec)
		val->it_value.tv_sec++;
	if (val->it_interval.tv_usec)
		val->it_interval.tv_sec++;
	ItimerVal = val->it_interval.tv_sec;
	return alarm(val->it_value.tv_sec);
}

static int Arecurse = 0;
static
Alarm_Call(signo)
{
	int (*func)();
	if (Arecurse)
		/*
		 * We screwed up.
		 */
		return;
	Arecurse++;
	(void) (*Alarm_Func)(signo);
	func = (int (*)())signal(SIGALRM, Alarm_Call);
	if (func != Alarm_Call) {
		/*
		 * If the Alarm Catching Func has Changed this.
		 */
		Alarm_Func = func;
	}
	(void) alarm(ItimerVal);
	Arecurse--;
}
