/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)bind.c (TWG)        1.4      19:07:37 - 89/06/28"

/* LINTLIBRARY */
#include "sys/types.h"
#include "sys/fcntl.h"
#include "sys/stat.h"
#include "sys/stream.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/inetioctl.h"
#include "errno.h"
#include "sys/somod.h"
#include "sys/un.h"

bind(sock, sin, len)
	struct sockaddr_in *sin;
{
	int addrlen;

	if (sin->sin_family == AF_UNIX) {
		struct sockaddr_un *sun;
		struct stat sbuf, *s = &sbuf;
		int fd, plen, savemask;

		if (sin == 0L) {
			errno = EINVAL;
			return -1;
		}
		sun = (struct sockaddr_un *)sin;
		if ((plen = strlen(sun->sun_path)) >= SUNPATHLEN ||
		    (len < plen + sizeof(ushort))) {
			errno = EINVAL;
			return -1;
		}

		/* don't want to bind to an existing file */
		if (stat(sun->sun_path, &sbuf) == 0) {
			errno = EADDRINUSE;
			return -1;
		}

		savemask = umask(0);
		fd = open(sun->sun_path, O_RDONLY|O_CREAT, 0777);
		(void) umask(savemask);
		if (fd < 0) {
			errno = EADDRNOTAVAIL;
			return -1;
		}
		if (fstat(fd,&sbuf) < 0) {
			errno = EADDRNOTAVAIL;
			return -1;
		}
		(void) close(fd);

		/* Always pass down whole structure */
		addrlen = AFUADDRLEN;
	} else {
		addrlen = len;
	}

	if (!_s_ioctl(sock, (caddr_t)sin, addrlen, SIOC_BIND, 0))
		return -1;

	return 0;
}
