#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)errno_set.c (TWG)  1.1     89/05/18 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/inet.h>
#include <tiuser.h>

/* Maps t_errno to errno. following t_errno values are not mapped:
TBADSEQ, TBADFLAG - won't be generated by not using t_snddis, t_optmgmt in 
the SCL emulations.
TNODIS, TNOUDERR, TNOREL - will make sure these don't happen by checking 
t_look() value for corresponding indications before calling t_rcvdis,
t_rcvuderr, and t_rcvrel in the SCL emulations.
TLOOK is examined in the context of each SCL call as appropriate. */

void
_errno_set()
{
	extern int errno, t_errno;

	switch(t_errno) {

	case TBADADDR:
		errno = EADDRNOTAVAIL;
		break;

	case TBADOPT:
		errno = EINVAL;
		break;

	case TACCES:
		errno = EACCES;
		break;

	case TBADF:
		errno = ENOTSOCK;
		break;

	case TNOADDR:
		errno = EADDRNOTAVAIL;
		break;

	case TOUTSTATE:
		errno = EINVAL;
		break;

	case TSYSERR:
#ifdef notdef
		if (errno < EWOULDBLOCK && errno != EFAULT &&
		    errno != EINTR)
			errno = EIO;
#endif /* notdef */
		/* errno is already set by TLI. */
		break;

	case TBADDATA:
		errno = EINVAL;
		break;

	case TBUFOVFLW:
		errno = EINVAL;
		break;

	case TFLOW:
		errno = EWOULDBLOCK;
		break;

	case TNODATA:
		errno = EWOULDBLOCK;
		break;

	case TNOTSUPPORT:
		errno = EOPNOTSUPP;
		break;

	case TSTATECHNG:
		errno = EINPROGRESS;
		break;
	default:
		errno = EIO;	
	}
}
