/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)getload.c (TWG)        1.1      09:47:04 - 89/07/20"

/* LINTLIBRARY */

/*
 * This is the interface into the BSD Networking systm calls. 
 * These are invoked as ioctl's.
 */

#ifndef ARIX

#include <sys/param.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/in.h>
#include <sys/param.h>
#include <win_hook.h>

/* ARGSUSED */
getload (ave)
	double *ave;
{
	
	return _win_ioctl (WIN_GETLOAD, ave);
}

#else

#include <sys/sysarix.h>

/* ARGSUSED */
int
getload(ave)
	long *ave;  /* pointer to array of 3 longs */
{
	int result;
	int i;
	long avenrun[5];	/* sysarix expects array of 5 longs */

	result = sysarix( ARIXGETLA, avenrun );
	if (result)
		return result;
	for (i = 0; i <= 2; ++i )
		ave[i] = avenrun[i];
	return 0;
}
#endif
