/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)getsocknm.c (TWG)        1.2      16:57:17 - 89/06/27"

/* LINTLIBRARY */
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/in.h"
#include "sys/inetioctl.h"
#include "errno.h"
#include "sys/somod.h"

getsockname(s, name, namelen)
struct sockaddr_in *name;
int *namelen;
{

	if (!_s_ioctl(s, (caddr_t)name, *namelen, SIOC_GETSOCKNAME, namelen))
		return -1;

	if (name->sin_port == 0) {	/* must be done in TCP/UDP, etc */
		errno = EADDRNOTAVAIL;
		return -1;
	}

	return 0;
}
