/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)listen.c (TWG)        1.2      16:57:18 - 89/06/27"

/* LINTLIBRARY */
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/inetioctl.h"
#include "errno.h"
#include "sys/somod.h"

listen(sock, backlog)
{
	if (backlog < 0) {
		errno = EINVAL;
		return -1;
	}

	if (!_s_ioctl(sock, (caddr_t)&backlog, sizeof(int), SIOC_LISTEN, 0))
		return -1;

	return 0;
}
