/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)recv.c (TWG)        1.2      16:57:22 - 89/06/27"

/* LINTLIBRARY */
#include "sys/param.h"
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/inetioctl.h"
#include "errno.h"
#include "sys/somod.h"
extern int errno;

recv(s, buf, len, flags) 
	char *buf;
{
	int retval;
	
	if (flags & ~(MSG_OOB | MSG_PEEK))
		return (EINVAL);

	if (!(flags & MSG_OOB)) {
		if (!(flags & MSG_PEEK))
			return (read(s, buf, len));
		else {
			return (peek(s, buf, len));
		}
	} else {
		/* oob data is requested */
		if (!(flags & MSG_PEEK)) {
			if (!_s_ioctl(s, buf, len, SIOC_READOOB, &retval))
				return -1;
		} else {
			if (!_s_ioctl(s, buf, len, SIOC_PEEKOOB, &retval))
				return -1;
		}
		return retval;
	}
}


/*
 * peek - no support for now
 */
peek(s, buf, len) 
	char *buf;
{
	errno = EOPNOTSUPP;
	return -1;
}
