/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)send.c (TWG)        1.2      16:57:29 - 89/06/27"

/* LINTLIBRARY */
#include "sys/param.h"
#include "sys/types.h"
#include "sys/stream.h" 
#include "sys/tihdr.h" 
#include "sys/inet.h" 
#include "errno.h"
#include "sys/somod.h"
extern int slmsgsz;

send(s, msg, len, flags)
char *msg;
{
	struct S_snd_req *Sp;
	int retval;
	unsigned size;
	caddr_t saved_sp;
	extern caddr_t _ssp();
	extern void _rsp();

	saved_sp = _ssp();

	if (!slmsgsz && !_s_setmsgsz(s)) {
		_rsp(saved_sp);
		return -1;
	}

	if (flags == 0) {
		/* send the user buffer directly */
		if (len > slmsgsz) {
			_rsp(saved_sp);
			return (sl_send(s, msg, len, flags));
		} else {
			if (!_s_ioctl(s, msg, len, SIOC_SEND_S, 0)) {
				_rsp(saved_sp);
				return -1;
			}
			_rsp(saved_sp);
			return len;
		}
	} else {
		/* 
		 * construct a S_snd_req primitive, 
		 * copy the msg to it, and do an ioctl.
		 */
		if (len >  slmsgsz - sizeof(struct S_snd_req)) {
			_rsp(saved_sp);
			return (sl_send(s, msg, len, flags));
		} else {
			size = sizeof(struct S_snd_req) + len;
			if ((Sp=(struct S_snd_req *)alloca(size)) == NULL){
				errno = ENOBUFS;
				_rsp(saved_sp);
				return -1;
			}
			bzero((char *)Sp, size);
			Sp->cmd = SIOC_SEND_SF;	/* for verification */
			Sp->flags = flags;
			Sp->DATA_length = len;
			Sp->DATA_offset = sizeof(struct S_snd_req);
			/* set/unset signal handling for SIGSEGV, etc */
			bcopy(msg, (char *)Sp + Sp->DATA_offset, len);
			
			if (!_s_ioctl(s, (caddr_t)Sp, size, SIOC_SEND_SF, 0)){
				_rsp(saved_sp);
				return -1;
			}
			_rsp(saved_sp);
			return len;
		}
	}
}
		
	
sl_send(s, buf, len, flags)
char *buf;
{
	register int tlen, tcnt;
	register char *tbuf;
	register struct S_snd_req *Sp;
	int retval, maxmsgsz;
	unsigned size;
	caddr_t saved_sp;
	extern caddr_t _ssp();
	extern void _rsp();

	saved_sp = _ssp();

	if ((Sp = (struct S_snd_req *)alloca(slmsgsz)) == NULL){
		errno = ENOBUFS;
		_rsp(saved_sp);
		return -1;
	}
	bzero(Sp, slmsgsz);
	maxmsgsz = slmsgsz - sizeof(struct S_snd_req);

	tlen = len;
	tbuf = buf;

	while (tlen) {
		tcnt = tlen;
		if (tcnt >  maxmsgsz) 
			tcnt = maxmsgsz;

		if (flags == 0) 
			retval = _s_ioctl(s, tbuf, tcnt, SIOC_SEND_L, 0); 
		else {
			/* 
			 * construct S_snd_req primitive, 
			 * and copy tbuf to it.
			 */
			size = sizeof(struct S_snd_req) + tcnt;
			Sp->cmd = SIOC_SEND_LF;	/* for verification */
			Sp->flags = flags;
			Sp->DATA_length = tcnt;
			Sp->DATA_offset = sizeof(struct S_snd_req);
			/* set/unset signal handling for SIGSEGV, etc */
			bcopy(tbuf, (char *)Sp + Sp->DATA_offset, tcnt);
			retval = _s_ioctl(s, (caddr_t)Sp, size, SIOC_SEND_LF,0);
		}

		if (!retval) {
			if (len == tlen) {
				_rsp(saved_sp);
				return -1;
			} else {
				_rsp(saved_sp);
				return (len - tlen);
			}
		}
		
		tlen = tlen - tcnt;
		tbuf = tbuf + tcnt;
	}

	_rsp(saved_sp);
	return (len - tlen);
}
