#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)sendmsg.c (TWG)  1.2     89/06/27 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)sendmsg.c (TWG)        1.2      16:57:31 - 89/06/27"

/* LINTLIBRARY */
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/inet.h>
#include <sys/in.h>
#include <errno.h>
#include <tiuser.h>

sendmsg(s, msg,flags)
struct msghdr msg[];
{
	register struct iovec *iov;
	int i, n, cnt, state;
	extern int t_errno;

	if (msg == 0)	{
		errno = EINVAL;
		return -1;
	}

	if (msg->msg_iovlen >= MSG_MAXIOVLEN) {
		errno = EMSGSIZE;
		return -1;
	}
	if ((state = t_getstate(s)) < 0) {
		_errno_set();
		return -1;
	}
	iov = msg->msg_iov;
	cnt = 0;
	for (i=0; i < msg->msg_iovlen ; i++, iov++) {
		if (iov->iov_len < 0) {
			errno = EINVAL;
			return -1;
		}
		if (iov->iov_len == 0)
			continue;
		if (state == T_DATAXFER) {
			if (flags & MSG_OOB)
				flags = T_EXPEDITED;
			n = send(s, iov->iov_base, iov->iov_len, flags);
			if (n != iov->iov_len) 
				return -1;
		} else {
			n = sendto(s, iov->iov_base, iov->iov_len, 0, 
			msg->msg_name, msg->msg_namelen);
			if (n != iov->iov_len)
				return -1;
		}	
		cnt += iov->iov_len;
	}
	return cnt;
}
