/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)socket.c (TWG)        1.2      16:57:36 - 89/06/27"

/* LINTLIBRARY */
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/inet.h"
#include "sys/inetioctl.h"
#include "sys/socket.h"
#include "sys/in.h"
#include "netdb.h"
#include "sys/errno.h"
#include "sys/somod.h"

extern int slmsgsz;
extern int errno;
extern int _s_setmsgsz();

socket(af, type, protocol)
{
	register char *dev;
	register int fd;
	struct S_sock_req scall;
	int retval;

	switch (af) {

	case AF_INET:
	case AF_UNIX:
		break;

	default:
		errno = EAFNOSUPPORT;
		return -1;
	}

	switch (type) {

	case SOCK_STREAM:
		if (af == AF_INET) {
		    if ((protocol != 0) && (protocol != IPPROTO_TCP)) {
			errno = EPROTONOSUPPORT;
			return -1;
		    }
		    dev = DEV_TCP;
		} else {
		    dev = DEV_UDS;
		}
		break;

	case SOCK_DGRAM:
		if (af == AF_INET) {
		    if ((protocol != 0) && (protocol != IPPROTO_UDP)) {
			errno = EPROTONOSUPPORT;
			return -1;
		    }
		    dev = DEV_UDP;
		} else {
		    dev = DEV_UDD;
		}
		break;

	case SOCK_RAW:
		if (af != AF_INET) {
			errno = EAFNOSUPPORT;
			return -1;
		}
		dev = DEV_RAW;
		break;

	case SOCK_PAIR:
	default:
		errno = ESOCKTNOSUPPORT;
		return -1;
	}

	/*
	 * Now open the specified device.
	 */
	if ((fd = open(dev, 2)) < 0) {
		perror(dev);
		return -1;
	}

	if ((retval = ioctl(fd, I_FIND, "somod")) < 0) {
		errno = EIO;
		close(fd);
		return -1;
	}

	if (!retval) 
		if (ioctl(fd, I_PUSH, "somod") < 0) {
			errno = EIO;
			close(fd);
			return -1;	
		}

	/* Send down the socket call parameters to somod */

	scall.domain = af;
	scall.type = type;
	scall.proto = protocol;
	if (!_s_ioctl(fd, (caddr_t)&scall, sizeof(scall), SIOC_SOCKET, 0)) {
		close(fd);
		return -1;
	}

	/*
	 * For SOCK_DGRAM, and SOCK_RAW types set the 
	 * read mode to "message-discard"
	 */
	if (type == SOCK_DGRAM || type == SOCK_RAW) 
		if (ioctl(fd, I_SRDOPT, RMSGD) < 0) {
			close(fd);
			return -1;
		}

	/*
	 * If we're interfacing with a raw socket then we have to
	 * inform the raw driver of the protocol and address family.
	 * The raw driver will set this up in it's top queue.
	 * Also the raw driver will send this info. to IP, which
	 * must at least know the protocol.
	 */
	if (type == SOCK_RAW) {
		struct sockproto sockproto;
		struct strioctl ioc;

		sockproto.sp_family = af;
		if (protocol == 0)
			sockproto.sp_protocol = IPPROTO_RAW;
		else
			sockproto.sp_protocol = protocol;
		ioc.ic_dp = (char *)&sockproto;
		ioc.ic_len = sizeof(struct sockproto);
		ioc.ic_cmd = RAWIOC_PROTO;
		ioc.ic_timout = 60;
		if (ioctl(fd, I_STR, &ioc) < 0) {
			close(fd);
			errno = EPROTONOSUPPORT;
			return -1;
		}
	}

	if (!slmsgsz && !_s_setmsgsz(fd)) {
		close(fd);
		return -1;
	}

	return fd;
}
