/*
 * @(#) Copyright 1987.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)win_ioctl.c (TWG)  1.5     89/07/30 "

/*
 * This is the interface into the BSD
 * Networking systm calls. These are invoked
 * as ioctl's.
 */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/stream.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/in.h> 
#include <sys/route.h>
#include <stdio.h>
#include <routed.h>
#include <sys/ioctl.h>
#include <sys/stropts.h> 
#include <sys/inetioctl.h> 
#include <sys/if.h>  
#include <sys/in_var.h> 
#include <errno.h>
#include <signal.h>
#include <setjmp.h>
#include <win_hook.h>
jmp_buf b_env;

/*
 * This is the interface into the BSD
 * Networking systm calls. These are invoked
 * as ioctl's.
 */
_win_ioctl (syscall, args) 
{
	if (__win_hook_fd == -1 && _win_hook_open_() < 0)
		return -1;
	return ioctl (__win_hook_fd, WIN_HOOK_MASK | syscall, args);
}


/*
 * Generic ioctl routine for the ip module.
 */
int 
_ipioctl(s, cmd, data) 
	int s, cmd;
	char *data;
{ 
	struct strioctl ioc;
	int error;
	static struct rtentry kern_route;
	caddr_t saved_sp;
	extern caddr_t _ssp();
	extern void _rsp();

	saved_sp = _ssp();

	ioc.ic_cmd = cmd; 
	ioc.ic_timout = 60;
	switch (cmd)
	{
	    case IPIOC_GETIFCONF:
		{
		struct ifconf *ifc;
		char *p, *c;
		int i, len;
		void (*sigbus)(), (*sigemt)(), no_buf();
		extern char *alloca();

		ifc = (struct ifconf *)data;
		len = sizeof(int) + ifc->ifc_len; 		
		p = alloca(len); 		
		*(int *)p = ifc->ifc_len;
		ioc.ic_dp = p;
		ioc.ic_len = len;
		if (ioctl(s, I_STR, &ioc) < 0) {
			errno = EIO;
			_rsp(saved_sp);
			return -1;
		}
		c = ioc.ic_dp;
		ifc->ifc_len = *(int *)c;
		c += sizeof(int);
		sigbus = (void (*)())signal(SIGBUS, no_buf);
		sigemt = (void (*)())signal(SIGEMT, no_buf);
		if (setjmp(b_env) != 0) {
			(void) signal(SIGEMT, sigemt);
			(void) signal(SIGBUS, sigbus);
			errno = EFAULT;
			_rsp(saved_sp);
			return -1;
		}
		bcopy(c, ifc->ifc_buf, ifc->ifc_len);
		(void) signal(SIGEMT, sigemt);
		(void) signal(SIGBUS, sigbus);
		_rsp(saved_sp);
		return 0;
		}

	    case IPIOC_ADDROUTE:
	    case IPIOC_DELETEROUTE:
		{ 
/*
 * To eliminate name conflicts with elements 
 * of kernel route structure. 
 */
#undef rt_dst
#undef rt_flags
		 struct route_map *rtk = (struct route_map *)data;
		 struct rtentry *rt;

		 bzero((char *)&kern_route, sizeof (struct rtentry));
		 rt = &kern_route;
		 rt->rt_dst.s_addr = satosaddr(rtk->rtk_dst);
		 rt->rt_gateway.s_addr = satosaddr(rtk->rtk_router);
		 rt->rt_flags = rtk->rtk_flags;
		 rt->rt_tos = rtk->rtk_tos;
		 rt->rt_protocol = rtk->rtk_protocol;
		 rt->rt_priority = 0;
		 rt->rt_flags = rtk->rtk_flags;
		 ioc.ic_dp = (char *)rt;
		 ioc.ic_len = sizeof (struct rtentry);
		 break;
		}

	    case IPIOC_GETROUTE:
		{ 
/*
 * To eliminate name conflicts with elements 
 * of kernel route structure. 
 */
#undef rt_dst
#undef rt_flags
		 struct route_map *rtk = (struct route_map *)data;
		 struct rtentry *rt;

		 bzero((char *)&kern_route, sizeof (struct rtentry));
		 rt = &kern_route;
		 rt->rt_hash = rtk->rtk_hash;
		 rt->rt_flags = rtk->rtk_flags;
		 rt->rt_next = (struct rtentry *)rtk->rtk_next;
		 rt->rt_tos = rtk->rtk_tos;
		 rt->rt_protocol = rtk->rtk_protocol;
		 rt->rt_priority = 0;
		 ioc.ic_dp = (char *)rt;
		 ioc.ic_len = sizeof (struct rtentry);
		 break;
		}

	    default:
		ioc.ic_dp = (char *)data;
		ioc.ic_len = sizeof (struct ifreq);
		break;
	}	

	error = ioctl(s, I_STR, &ioc);

	switch (cmd)
	{
	    case IPIOC_GETROUTE:
		{ 
/*
 * To eliminate name conflicts with elements 
 * of kernel route structure. 
 */
#undef rt_dst
#undef rt_flags
		 struct route_map *rtk = (struct route_map *)data;
		 struct rtentry *rt;
		 struct sockaddr_in *rti;

		 rt = (struct rtentry *)ioc.ic_dp;
		 rtk->rtk_hash = rt->rt_hash;
		 rtk->rtk_flags = rtk->rtk_flags;
		 rti = (struct sockaddr_in *)&rtk->rtk_dst;
		 bzero((char *)rti, sizeof (struct sockaddr_in));
		 rti->sin_family = AF_INET;
		 rti->sin_addr = rt->rt_dst;
		 rti = (struct sockaddr_in *)&rtk->rtk_router;
		 bzero((char *)rti, sizeof (struct sockaddr_in));
		 rti->sin_family = AF_INET;
		 rti->sin_addr = rt->rt_gateway;
		 rtk->rtk_next = (struct route_map *)rt->rt_next;
		 rtk->rtk_tos = rt->rt_tos;
		 rtk->rtk_protocol = rt->rt_protocol;
		 break;
		}
	}

	_rsp(saved_sp);
	return (error);
}

void
no_buf()
{
	longjmp(b_env, 1);
}
