/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)write.c (TWG)        1.2      16:57:40 - 89/06/27"

/* LINTLIBRARY */
#include "sys/param.h"
#include "sys/types.h"
#include "sys/inet.h"
#include "sys/socket.h"
#include "signal.h"
#include "sys/stream.h"
#include "sys/tihdr.h"
#include "sys/somod.h"
#include "errno.h"
extern int errno;

/* ARGSUSED */
write (fd, buf, nchar)
	char *buf;
{
	register int retval, error;
	
	retval = _win_do_write (fd, buf, nchar);

	if (retval >= 0)
		return retval;

	if (errno != ERANGE)
		return retval;
	else {
		/*
		 * check for somod related failure 
		 */
		struct s_info info;
		
		if (!_s_ioctl(fd,(caddr_t)&info,sizeof(info),SIOC_GETINFO,0)){
			errno = ERANGE;
			return -1;
		}
			
		if (!(info.state & SS_ISCONNECTED)) {
			errno = ENOTCONN;
			return -1;
		}

		if (info.state & SS_CANTSENDMORE) {
			kill(getpid(), SIGPIPE);
			errno = EPIPE;
			return -1;
		}
		
		errno = ERANGE;
		return -1;
	}
}
