
    MEMTEST1 -- 02:00.PM Thursday 14 April 83

    maclib sal80
    INITIALIZE?
;   maclib frzscrn
    maclib get8hex
;   maclib blockmov
;   maclib compare
;   maclib cmpstrs
;   maclib divide
;   maclib multiply
;   maclib findstr
;   maclib response
;   maclib parms
;   maclib pic-optn
;   maclib <your macro filename(s)>
;   Z80?
    RMAC?

;;;;;;;;    most EQUs are in the (header) LIB files

    maclib standard
    maclib memtest

    if ?RMAC ! CSEG ! endif

;;;;;;;;    set up ORG

    if ?rmac
      org 0
    else
      org 100h
    endif

begin$code:

    GOTO? main

;;;;;;;;    local (non-LIB) macro definitions and subroutines go here

getresponse      MACRO chr,flag,savreg
;
;   Returns PSW and toggle FLAG:
;       response in A, zerset if a match with CHR
;       and FLAG = TRUE if zerset, FALSE otherwise
;
;   Double registers saved iff not nul SAVREG
;
    local sbr,endsbr
    jmp endsbr
sbr:
    CONS$TO$BUFR?
    GET$A$FROM$BUFR?
    LOWR$TO$UPPR?
    RETURN?
endsbr:
get$response     MACRO chr@,flag@,savreg@
    if not nul savreg@
      SAVE$DUBLS?
    endif
    CALL? sbr
    if not nul chr@
      cpi '&CHR@'
      if not nul flag@
        lxi H,flag@
        IF? ,ZERSET?
          mvi M,TRUE
        ELSE?
          mvi M,FALSE
        ENDELSE?
      endif
    endif
    if not nul savreg@
      RESTORE$DUBLS?
    endif
    ENDM
    get$response chr,flag,savreg
    ENDM


check$lo$bounds:
;
;   get args in HL and DE
;    
;   Clobbers PSW and preserves double registers iff no error
;
    IF? DE,NE?,0
      NEWLINE?
      STRING$TO$CONS? instlerrmsg,$
      pop PSW;    {balance stack}
      GOTO? err2
    ENDIF?
    STORE? HL,@lowr$bndry    
    STORE? DE,@lo$addr$extnsn
    RETURN?


check$hi$bounds:
;
;   get args in HL and DE
;   [HL] = 0   ==>   default, 
;   so change to TOP$OF$RAM
;
;   Clobbers PSW and preserves double registers iff no error
;
    IF? HL,EQ?,0;        {default}
      lxi H,TOP$OF$RAM
    ENDIF?
    IF? DE,NE?,0
      NEWLINE?
      STRING$TO$CONS? instlerrmsg,$
      pop PSW;    {balance stack}
      GOTO? err4
    ENDIF?
    STORE? HL,@uppr$bndry
    STORE? DE,@hi$addr$extnsn
    RETURN?


interpret$delay   MACRO
;
;   [A] {from GET$RESPONSE} is input.
;
;   Repeat prompt if [A] not one of:
;       <CR>, 'Y', 'N' or
;       '1', '2', '3', '4'.
;
;   Set ?delay to 0 if 'N' or <CR>
;   otherwise to VALUE, where
;   1 <= VALUE <= 4, (and 'Y' is the same as '1')
;
;   Clobbers PSW and preserves double registers
;
    cpi cr
    IFGOTO? ZERSET?,no$delay
    cpi 'N'
    IFGOTO? ZERSET?,no$delay
    cpi 'Y'
    IFGOTO? ZERSET?,delay1
    sui '0';       {ascii bias}
    cpi 1
    IFGOTO? ZERSET?,set$delay
    cpi 2
    IFGOTO? ZERSET?,set$delay
    cpi 3
    IFGOTO? ZERSET?,set$delay
    cpi 4
    IFGOTO? ZERSET?,set$delay
    GOTO? err3
no$delay:
    xra A
    GOTO? set$delay
delay1:
    mvi A,1;       {and fall through}
set$delay:
    STORE? A,?delay
    ENDM


define$flag    MACRO flag
;
;   [flag] <-- ([HL] < [DE])
;
;   Clobbers PSW and preserves double registers
;
    local sbr,endsbr
    jmp endsbr
sbr:
    IF? HL,LT?,DE
      mvi A,TRUE
    ELSE?
      mvi A,FALSE
    ENDELSE?
    RETURN?
endsbr:
define$flag    MACRO flag@
    CALL? sbr
    STORE? A,flag@
    ENDM
    define$flag flag
    ENDM


analyze$iterations:
;
;  check for [HL] = 0
;  check for [HL] < 'FFFF'
;
;    clobbers DE,HL
;
  IF? HL,EQ?,0
    mvi L,1
  ENDIF?
  STORE? HL,@iterations
  lxi D,0FFFFh
  define$flag ?terminates   
  RETURN?


eval$menu$summary     MACRO
;
;   check for [A] = 'N'
;
;   Preserves everything.
;
    cpi 'N'
    IFGOTO? ZERSET?,ERR2;      {repeat prompt}
    ENDM


*************************************************
*
*   End of locally declared macros
*
*************************************************

;;;;;;;;    body of program goes here

user$intrface:;        entry point
start:

;   establish the ground-rules, set stackpointer
;   MAIN?
    if not ?main
      lxi H,0
      dad SP
      STORE? HL,@prior$stkptr
      lxi SP,stkptr
    endif

;;;;;;;;;;;;;;;    balance of code segment goes here
                   ;
                   ;   MEMTST signs on with title and copyright notice
                   ;

 NEWLINE?
 STRING$TO$CONS? '             (TM)'
 NEWLINE?
 STRING$TO$CONS? '      MEMTEST    is produced and maintained by'
 NEWLINE?
 NEWLINE?
 STRING$TO$CONS? '                              (R)'
 NEWLINE?
 STRING$TO$CONS? '                      PROTOOLS'
 NEWLINE?
 NEWLINE?
 STRING$TO$CONS? '    24225 Summerhill Avenue, Los Altos, CA 94022'
 NEWLINE?
 STRING$TO$CONS? '              Telephone (415) 948-8007'
 NEWLINE?
 NEWLINE?
 STRING$TO$CONS? <'    Copyright 1978,'''80,'''83 Newberry Microsystems'>
 NEWLINE?
 STRING$TO$CONS? '                  All Rights Reserved'
 NEWLINE?
 NEWLINE?
 STRING$TO$CONS? '      (TM):  MEMTEST and PROTOOLS are trademarks of'
 NEWLINE?
 STRING$TO$CONS? '                   Newberry Microsystems'
 NEWLINE?
 NEWLINE?
 STRING$TO$CONS? '            (R): PROTOOLS Reg. U.S. Pat. Off.'
 NEWLINE?
 NEWLINE?
 NEWLINE?
 NEWLINE?
                   ;
                   ;   MEMTEST gives the following series of prompts:
                   ;
err1:
 NEWLINE?
 NEWLINE?
 STRING$TO$CONS? '  Menu or Default-list? (M/D/<CR>)'
 NEWLINE?
 STRING$TO$CONS? <'   (defaults to '''D'''): '>
 get$response M
                   ;
                   ;   If Default-list is selected, then prompt
                   ;

 IF? ,ZERCLR?;        {selected default-list}
   NEWLINE?
   NEWLINE?
   STRING$TO$CONS? '  Defaults are:'
   NEWLINE?
   STRING$TO$CONS? '    Test from 0000 to '
   lxi H,TOP$OF$RAM
   WRD$HEX$TO$CONS?
   STRING$TO$CONS? 'h, no Dynamic Timing,'
   NEWLINE?
   STRING$TO$CONS? '    QUICK mode, no DELAY, execute once and return to CP/M.'
   NEWLINE?
   STRING$TO$CONS? '  Is that correct? (Y/N/<CR>): '
                   ;
                   ;   (<CR>  defaults to ''Y'')
                   ;
   get$response N
                   ;
                   ;   If negative, then loop back to first prompt.
                   ;
   IFGOTO? ZERSET?,err1
   lxi H,TOP$OF$RAM
   STORE? HL,@uppr$bndry
                     ;
                   ;   If Menu is selected, then prompt
                   ;
 ELSE?
err2:
   NEWLINE?
   NEWLINE?
   STRING$TO$CONS? '  Enter address (hex) of bottom of memory and RETURN'
   NEWLINE?
   STRING$TO$CONS? '    (defaults to 0000): '
   GET$8$HEX?
   CALL? check$lo$bounds
err4:
   NEWLINE?
   NEWLINE?
   STRING$TO$CONS? '  Enter address (hex) of top of memory and RETURN'
   NEWLINE?
   STRING$TO$CONS? '    (defaults to '
   lxi H,TOP$OF$RAM
   WRD$HEX$TO$CONS?
   STRING$TO$CONS? 'h): '
   GET$8$HEX?
   CALL? check$hi$bounds
   NEWLINE?
   NEWLINE?
   STRING$TO$CONS? '  Test for dynamic timing? (Y/N/<CR>)'
   NEWLINE?
   STRING$TO$CONS? <'   (defaults to '''N'''): '>
   get$response Y,?timing
   IF? ,ZERCLR?
     NEWLINE?
     NEWLINE?
     STRING$TO$CONS? '  QUICKtest or PATTERN-sensitivity? (Q/P/<CR>)'
     NEWLINE?
     STRING$TO$CONS? '    (defaults to QUICKtest): '
     get$response P,?pattern
err3:
     NEWLINE?
     NEWLINE?
     STRING$TO$CONS? '  DELAY between Write and Read phases? (Y/N/<CR>)'
     NEWLINE?
     STRING$TO$CONS? <'   (defaults to '''N'''; '''1''', '''2''', '''3''' '>
     NEWLINE?
     STRING$TO$CONS? <'   or '''4''' may be entered in place of '''Y''';'>
     NEWLINE?
     STRING$TO$CONS? <'   '''Y'''<CR> same as '''1'''<CR>): '>
     get$response
     interpret$delay
   ENDIF?
   NEWLINE?
   NEWLINE?
   STRING$TO$CONS? <'  Number of iterations? (1/2/ ... /FFFE/<CR>)'>
   NEWLINE?
   STRING$TO$CONS? <'    (defaults to '''1'''; '''FFFF''' is infinite loop): '>
   GET$8$HEX?
   CALL? analyze$iterations
   NEWLINE?
   NEWLINE?
   STRING$TO$CONS? '  Send error-messages to disk? (Y/N/<CR>)'
   NEWLINE?
   STRING$TO$CONS? <'   (defaults to '''N'''): '>
   get$response Y,?errors$to$disk
                   ;
                   ;   When the responses are complete then prompt
                   ;
   NEWLINE?
   NEWLINE?
   STRING$TO$CONS? '  Test is from '
   LOAD? HL,@lowr$bndry
   WRD$HEX$TO$CONS?
   STRING$TO$CONS? ' to '
   LOAD? HL,@uppr$bndry
   WRD$HEX$TO$CONS?
   IF? ?pattern
     STRING$TO$CONS? '  in PATTERN-sensitive mode'
   ELSE?
     STRING$TO$CONS? '  in QUICKtest mode'
   ENDELSE?
   NEWLINE?
   IF? ?delay
     STRING$TO$CONS? '  with DELAY, delay-factor = '
     LOAD? A,?delay
     BYT$HEX$TO$CONS?
     STRING$TO$CONS? ' and'
   ENDIF?
   IF? ?timing
     STRING$TO$CONS? '  with Dynamic Timing tests and'
     NEWLINE?
   ENDIF?
   STRING$TO$CONS? '  with '
   LOAD? HL,@iterations
   IF? HL,NE?,0FFFFh
     WRD$HEX$TO$CONS?
   ELSE?
     STRING$TO$CONS? 'INFINITELY many'
   ENDELSE?
   STRING$TO$CONS? ' iteration(s).'
   NEWLINE?
   IF? ?errors$to$disk
     STRING$TO$CONS? '  Error-messages will be saved to file MEMTEST.ERR'
     NEWLINE?
   ENDIF?
   STRING$TO$CONS? '  Is that correct? (Y/N/<CR>): '
   get$response
   eval$menu$summary
   NEWLINE?
 ENDELSE?

exit:
    LOAD? HL,@prior$stkptr
    sphl
    if not ?main
      RETURN?
    else
      GOTO? reboot
    endif

end$code:

;;;;;;;;    data segment

;;;;;;;;    removed the DSEG statement

begin$data:

;;;;;;;;    PUBLICs and EXTRNs go here

    PUBLIC user$intrface,err1,err2,end$intrface

    EXTRN ?pattern,?delay,?terminates,?timing,?errors$to$disk
    EXTRN @lowr$bndry,@uppr$bndry,@lo$addr$extnsn,@hi$addr$extnsn
    EXTRN @iterations,main

;;;;;;;;    (DBs, DWs, DSs go here)

@prior$stkptr   ds 2

space$err$msg:  db 'Not enough space to move MEMTEST and/or save CP/M$'

instlerrmsg:    db 'Extended memory error -- NOT INSTALLED$'

enddata:

;;;;;;;;    stack goes here
stack:          ds STACK$SIZE
stkptr:
end$intrface:   ds 0

      END


