	TITLE	'Root module of relocatable BIOS for CP/M 3.0'

; ***********  **********  ***           ******** ****          ****
;************ ************ ***          *********   ****      ****
;***          ***      *** ***          ***           ****  ****
;***          ***      *** ***          ********        ****
;***          ***      *** ***          ********          ****
;***          ***      *** ***          ***           ****  ****
;************ ************ ************ ****************      ****
; *********    **********   *********    *************          ****
;
; Copyright (c) 1983, Colex Electronic Co. Ltd. All rights reserved.
;
;     No  part of this publication may be  reproduced,   transmitted,
;transcribed,   stored in a retrieval system,  or translated into any
;language  or  computer  language,   in any form  or  by  any  means,
;electronic,   mechanical,  magnetic,  optical,  chemical,  manual or
;otherwise   without the prior written permission of Colex Electronic
;Co. Ltd., 623, Ocean Centre, Kowloon, Hong Kong.
;
;
;     Colex  makes no representations or  warranties with  respect to
;the   contents  hereof  and  specifically  disclaims   any   implied
;warranties of merchantability or fitness for any particular purpose. 
;Further  Colex reserves the right to revise  this publication and to
;make  changes  from  time to  time  in the  content  hereof  without
;obligation  of  Colex  to  notify any person  of  such  revision  or
;changes.
;
	PAGE
;****************************************************************
;*								*
;*		BIOS Root Module for CP/M 3.0			*
;*								*
;****************************************************************
; Date		  Author	Modification
;20-Apr-83	K.J. Brand	V1.0
;22-Nov-83	R.J. Wellsted	Added Interupt vectors V2.0
	PAGE
CR	EQU	13
LF	EQU	10
BELL	EQU	7
CTLQ	EQU	'Q'-'@'
CTLS	EQU	'S'-'@'

CCP	EQU	0100H		;CCP gets loaded into the TPA

	MACLIB	MODEBAUD	;define mode bits
	MACLIB	PORTS		;define ports
	MACLIB	Z80		;define z80 opcodes
	MACLIB	EQUATES		;define system equates

	CSEG		;GENCPM puts CSEG stuff in common memory

;variables in system data page
	EXTRN	@COVEC,@CIVEC	;CON: redirection vectors
	EXTRN	@AOVEC,@AIVEC	;AUX: redirection vectors
	EXTRN	@LOVEC		;LST: redirection vectors
	EXTRN	@MXTPA		;addr of system entry point
	EXTRN	@BNKBF		;128 byte scratch buffer

;initialization
	EXTRN	?INIT		;general initialization and signon
	EXTRN	?LDCCP,?RLCCP	;load & reload CCP for BOOT & WBOOT

;user defined character I/O routines
	EXTRN	?CI,?CIST	;CON: input & status (device in B)
	EXTRN	?CO,?COST	;CON: output & status (device in <B)
	EXTRN	?CINIT		;(re)initialize device in <C>
	EXTRN	@CTBL		;physical character device table

;disk communication data items
	EXTRN	@DTBL		;table of pointers to XDPHs
	PUBLIC	@ADRV,@RDRV	;parameters for disk i/o
	PUBLIC	@TRK,@SECT	;   ''       ''  ''  ''
	PUBLIC	@DMA,@DBNK	;   ''       ''  ''  ''
	PUBLIC	@CNT		;   ''       ''  ''  ''

;memory control
	PUBLIC	@CBNK		;current bank
	EXTRN	?XMOVE,?MOVE	;select move bank, and block move
	EXTRN	?BANK		;select CPU bank

;clock support
	EXTRN	?TIME		;signal time operation

;general utility routines
	PUBLIC	?PMSG,?PDEC	;print message, print number from 0 to 65535
	PUBLIC	?PDERR		;print BIOS disk error message header

;External names for BIOS entry points
	PUBLIC	?BOOT,?WBOOT,?CONST,?CONIN,?CONO,?LIST,?AUXO,?AUXI
	PUBLIC	?HOME,?SLDSK,?STTRK,?STSEC,?STDMA,?READ,?WRITE
	PUBLIC	?LISTS,?SCTRN
	PUBLIC	?CONOS,?AUXIS,?AUXOS,?DVTBL,?DEVIN,?DRTBL
	PUBLIC	?MLTIO,?FLUSH,?MOV,?TIM,?BNKSL,?STBNK,?XMOV

;Interupts
	PUBLIC	@INTVE		;interupt vector table
	EXTRN	NULINT,RTCINT	;interupt service routines
	PAGE
;****************************************************************
;*								*
;*		BIOS Jump vector.				*
;*	All BIOS routines are invoked by calling these entry	*
;*	 points.						*
;*								*
;****************************************************************
?BOOT:	JMP	BOOT		;initial entry on cold start
?WBOOT:	JMP	WBOOT		;reentry on program exit, warm start
?CONST:	JMP	CONST		;return console input status
?CONIN:	JMP	CONIN		;return console input character
?CONO:	JMP	CONOUT		;send console output character
?LIST:	JMP	LIST		;send list output character
?AUXO:	JMP	AUXOUT		;send auxilliary output character
?AUXI:	JMP	AUXIN		;return auxilliary input character
?HOME:	JMP	HOME		;set disks to logical home
?SLDSK:	JMP	SELDSK		;select disk drive, return disk parameter info
?STTRK:	JMP	SETTRK		;set disk track
?STSEC:	JMP	SETSEC		;set disk sector
?STDMA:	JMP	SETDMA		;set disk I/O memory address
?READ:	JMP	READ		;read physical block(s)
?WRITE:	JMP	WRITE		;write physical block(s)
?LISTS:	JMP	LISTST		;return list device status
?SCTRN:	JMP	SECTRN		;translate logical to physical sector
?CONOS:	JMP	CONOST		;return console output status
?AUXIS:	JMP	AUXIST		;return aux input status
?AUXOS:	JMP	AUXOST		;return aux output status
?DVTBL:	JMP	DEVTBL		;return address of device def table
?DEVIN:	JMP	?CINIT		;change baud rate of device
?DRTBL:	JMP	GETDRV		;return address of disk drive table
?MLTIO:	JMP	MULTIO		;set multiple record count for disk I/O
?FLUSH:	JMP	FLUSH		;flush BIOS maintained disk caching
?MOV:	JMP	?MOVE		;block move memory to memory
?TIM:	JMP	?TIME		;Signal Time and Date operation
?BNKSL:	JMP	BNKSEL		;select bank for code execution and default DMA
?STBNK:	JMP	SETBNK		;select bank for disk I/O DMA operations.
?XMOV:	JMP	?XMOVE		;set source and destination banks
	JMP	0		;reserved for future expansion
	JMP	0		;reserved for future expansion
	JMP	0		;reserved for future expansion

	DS	13		;padding to 16 byte boundary

@INTVE:	DW	RTCINT		;cio counter/timer 3
	DW	NULINT		;cio counter/timer 2
	DW	NULINT		;cio counter/timer 1
	DW	NULINT		;cio timer error
	PAGE
;****************************************************************
;*								*
;*			BOOT					*
;*	Initial entry point for system startup.			*
;*								*
;****************************************************************
	DSEG			;this part can be banked
BOOT:	LXI	SP,BOOT$STACK	;use local stack pointer
	MVI	C,15		;initialize all 16 character devices
C$INIT$LOOP:
	PUSH	B		;save device no.
	CALL	?CINIT		;do device init
	POP	B		;restore device no.
	DCR	C		;adjust device no.
	JP	C$INIT$LOOP	;loop back if more to do.
	CALL	?INIT		;perform any additional system initialization
				;and print signon message 
	MVI	B,16		;no. of disks to init
	MVI	C,0		;first absolute drive no.
	LXI	H,@DTBL		;point to drive table
D$INIT$LOOP:
	PUSH	B		;save remaining count and abs drive
	MOV	E,M		;get low xdph address
	INX	H		;adjust pointer
	MOV	D,M		;get high xdph address
	INX	H		;adjust pointer
	MOV	A,E		;copy lo pointer
	ORA	D		;test with hi
	JRZ	D$INIT$NEXT	;if null, no drive
	PUSH	H		;save @drv pointer 
	PUSH	D		;save xdph pointer
	XCHG			;xdph address to HL
	DCX	H		;adjust
	DCX	H		;point to relative drive no.
	MOV	A,M		;get the relative drive no.
	STA	@RDRV		;save in global param.
	MOV	A,C		;get abs. drive no.
	STA	@ADRV		;save in global param.
	DCX	H		;point to hi init address
	MOV	D,M		;get hi pointer
	DCX	H		;point to lo init address
	MOV	E,M		;get lo init pointer
	XCHG			;copy to HL
	POP	D		;get address of xdph in for entry to drvinit
	CALL	IPCHL		;call init routine
	POP	H		;recover @drv pointer
D$INIT$NEXT:
	POP	B		;recover counter and drive no.
	INR	C		;next abs drive no.
	DJNZ	D$INIT$LOOP	;adjust count and loop
	JMP	BOOT$1		;jump to common memory to load CCP

	CSEG	;following in resident memory
BOOT$1:	CALL	SET$JUMPS	;init page 0, in bank 1 if banked
	CALL	?LDCCP		;fetch CCP for first time
	JMP	CCP		;and run it
	PAGE
;****************************************************************
;*								*
;*			WBOOT					*
;*		Entry for system restarts.			*
;*								*
;****************************************************************
WBOOT:	LXI	SP,BOOT$STACK	;use local stack
	CALL	SET$JUMPS	;initialize page zero and bank 1 if banked
	CALL	?RLCCP		;reload CCP
	JMP	CCP		;and re-run

SET$JUMPS:
	IF BANKED
	MVI	A,1 		;bank no. for tpa
	CALL	?BNKSL		;select the tpa bank
	ENDIF

	MVI	A,JMP		;load a jump instruction
	STA	0		;save in bios jump
	STA	5	 	;save in bdos jump
	LXI	H,?WBOOT	;get address of warm boot
	SHLD	1		;BIOS warm start entry
	LHLD	@MXTPA		;get top of tpa address
	SHLD	6		;BDOS system call entry
	RET

	DS 64			;space for local stack
BOOT$STACK EQU	$

DEVTBL:	LXI	H,@CTBL		;get address of character device table
	RET

GETDRV:	LXI	H,@DTBL 	;get address of Drive table
	RET
	PAGE
;****************************************************************
;*								*
;*		Character output device handlers.		*
;*	controls the calls to the various subroutines in CHARIO	*
;*								*
;****************************************************************
CONOUT:	LHLD	@COVEC		;fetch console output bit vector
	JMP	OUT$SCAN

AUXOUT:	LHLD	@AOVEC		;fetch aux output bit vector
	JMP	OUT$SCAN

LIST:	LHLD	@LOVEC		;fetch list output bit vector

OUT$SCAN:
	MVI	B,0		;start with device 0
CO$NEXT:
	DAD	H		;shift out next bit
	JNC	NOT$OUT$DEVICE	;skip over if not set
	PUSH	H		;save the vector
	PUSH	B		;save the count and character
NOT$OUT$READY:
	CALL	COSTER		;get device output status
	ORA	A		;test
	JZ	NOT$OUT$READY	;loop until device ready
	POP	B 
	PUSH	B		;restore and resave the character and device
	CALL	?CO		;if device selected, print it
	POP	B		;recover count and character
	POP	H		;recover the rest of the vector
NOT$OUT$DEVICE:
	INR	B		;next device number
	MOV	A,H
	ORA	L		;see if any devices left
	JNZ	CO$NEXT		;and go find them...
	RET
	PAGE
;****************************************************************
;*								*
;*		Character output device status handlers.	*
;*								*
;****************************************************************
CONOST:	LHLD	@COVEC		;get console output bit vector
	JMP	OST$SCAN

AUXOST:	LHLD	@AOVEC		;get aux output bit vector
	JMP	OST$SCAN

LISTST:	LHLD	@LOVEC		;get list output bit vector

OST$SCAN:
	MVI	B,0		;start with device 0
COS$NEXT:
	DAD	H		;check next bit
	PUSH	H		;save the vector
	PUSH	B		;save the count
	MVI	A,0FFH		;assume device ready
	CC	COSTER		;check status for this device
	POP	B		;recover count
	POP	H		;recover bit vector
	ORA	A		;see if device ready
	RZ			;if any not ready, return false
	INR	B		;drop device number
	MOV	A,H 
	ORA	L		;see if any more selected devices
	JNZ	COS$NEXT
	ORI	0FFH		;all selected were ready, return true
	RET

COSTER:	MOV	L,B		;copy device code
	MVI	H,0		;make device code 16 bits
	PUSH	H		;save it on stack
	DAD	H		;*2
	DAD	H		;*4
	DAD	H		;*8
	LXI	D,@CTBL+6 	;point to base + mode byte
	DAD	D		;make address of mode byte
	MOV	A,M		;get mode byte
	ANI	MB$XONXOFF	;test if xon/xoff supported
	POP	H		;recover console number in <HL>
	JZ	?COST		;not a xon device, go get output status direct
	LXI	D,XOFFLIST	;point to base of xon/xoff flag table
	DAD	D		;point to proper xon/xoff flag
	CALL	CIST1		;see if this device has character
	MOV	A,M		;get flag
	CNZ	CI1		;get flag or read key if any
	CPI	CTLQ		;test for xon
	JNZ	NOT$Q		;if its a ctl-Q,
	MVI	A,0FFH 		;set the flag ready
NOT$Q:	CPI	CTLS		;test for xoff
	JNZ	NOT$S		;if its a ctl-S,
	MVI	A,00H		;clear the flag
NOT$S:	MOV	M,A		;save the flag
	CALL	COST1		;get the actual output status,
	ANA	M		;and mask with ctl-Q/ctl-S flag
	RET			;return this as the status

CIST1:				;get input status with BC and HL saved
	PUSH	B
	PUSH	H		;save regs
	CALL	?CIST		;get device input status
	POP	H		;restore regs
	POP	B
	ORA	A		;test result
	RET

COST1:				;get output status, saving BC & HL
	PUSH	B
	PUSH	H		;save regs
	CALL	?COST		;get device output status
	POP	H		;restore regs
	POP	B
	ORA	A		;test result
	RET

CI1:				;get input, saving <BC> & <HL>
	PUSH	B
	PUSH	H		;save regs
	CALL	?CI		;get the char
	POP	H		;restore regs
	POP	B
	RET
	PAGE
;****************************************************************
;*								*
;*		Character input device handlers.		*
;*								*
;****************************************************************
CONST:	LHLD	@CIVEC		;get console input bit vector
	JMP	IST$SCAN

AUXIST:	LHLD	@AIVEC		;get aux input bit vector

IST$SCAN:
	MVI	B,0		;start with device 0
CIS$NEXT:
	DAD	H		;check next bit
	MVI	A,0		;assume device not ready
	CC	CIST1		;check status for this device
	ORA	A
	RNZ			;if any ready, return true
	INR	B		;drop device number
	MOV	A,H
	ORA	L		;see if any more selected devices
	JNZ	CIS$NEXT
	XRA 	A		;all selected were not ready, return false
	RET

CONIN:	LHLD	@CIVEC		;get con input bit vector
	JMP	IN$SCAN

AUXIN:	LHLD	@AIVEC		;get aux input bit vector

IN$SCAN:
	PUSH	H		;save bit vector
	MVI	B,0		;start with device 0
CI$NEXT:
	DAD	H		;shift out next bit
	MVI	A,0		;insure zero (nonexistant device not ready).
	CC	CIST1		;see if the device has a character
	ORA	A		;test
	JNZ	CI$RDY		;this device has a character
	INR	B		;else, next device
	MOV	A,H
	ORA	L		;see if any more devices
	JNZ	CI$NEXT		;go look at them
	POP	H		;recover bit vector
	JMP	IN$SCAN		;loop until we find a character

CI$RDY:	POP	H		;discard extra stack
	JMP	?CI
	PAGE
;****************************************************************
;*								*
;*		Utility Subroutines.				*
;*								*
;****************************************************************
IPCHL:				;vectored CALL point
	PCHL

?PMSG:				;print message @HL on console device(s)
				;up to a null saves BC & DE
	PUSH	B
	PUSH	D		;save regs
PMSG$LOOP:
	MOV	A,M		;get character
	ORA	A		;test it
	JZ	PMSG$EXIT	;exit loop if null
	MOV	C,A		;copy char
	PUSH	H		;save pointer
	CALL	?CONO		;do output
	POP	H		;restore pointer
	INX	H		;adjust it
	JMP	PMSG$LOOP	;and loop
PMSG$EXIT:
	POP	D		;restore regs
	POP	B
	RET			;done

?PDEC:				;print binary number 0-65535 from <HL>
	LXI	B,TABLE10	;point to powers of ten
	LXI	D,-10000	;load initial value (-ve to save doing sub)
NEXT:	MVI	A,'0'-1		;load initial char value
PDECL:	PUSH	H		;save no.
	INR	A		;adjust char
	DAD	D		;test no.
	JNC	STOPLOOP	;done this char if result +ve
	INX	SP		;throw away tos
	INX	SP
	JMP	PDECL		;loop
STOPLOOP:
	PUSH	D		;save regs
	PUSH	B
	MOV	C,A		;copy char
	CALL	?CONO		;display char
	POP	B		;get regs
	POP	D
NEXTDIGIT:
	POP	H		;get no.
	LDAX	B		;get power of ten to DE
	MOV	E,A
	INX	B
	LDAX	B
	MOV	D,A
	INX	B
	MOV	A,E		;test if finished (DE=0)
	ORA	D
	JNZ	NEXT		;loop if not
	RET

TABLE10:
	DW	-1000
	DW	-100
	DW	-10
	DW	-1
	DW	0

?PDERR:	LXI	H,DRIVE$MSG	;point to error message header
	CALL	?PMSG		;print it
	LDA	@ADRV		;get absolute drive no.
	ADI	'A'		;convert to ascii
	MOV	C,A		;copy char
	CALL	?CONO		;print drive code
	LXI	H,TRACK$MSG	;point to track header
	CALL	?PMSG		;print track header
	LHLD	@TRK		;get track no.
	CALL	?PDEC		;print track number
	LXI	H,SECTOR$MSG	;point to sector header
	CALL	?PMSG		;print sector header
	LHLD	@SECT		;get sector no.
	CALL	?PDEC		;print sector number
	RET

BNKSEL:	STA	@CBNK 		;remember current bank
	JMP	?BANK		;and go exit through
				;physical bank select routine

XOFFLIST:
	DB	-1,-1,-1,-1	;xoff clears to 0
	DB	-1,-1,-1,-1	;xon sets to -1
	DB	-1,-1,-1,-1	;initially assume all devices ready
	DB	-1,-1,-1,-1
	PAGE
;****************************************************************
;*								*
;*		Disk device handlers.				*
;*								*
;****************************************************************
	DSEG			;resides in banked memory
SELDSK:	MOV	A,C		;get drive select code
	STA	@ADRV		;save it
	MOV	L,C		;make 16 bit in HL
	MVI	H,0
	DAD	H		;create index from drive code
	LXI	B,@DTBL		;point to drive table
	DAD	B		;point to correct drive entry
	MOV	A,M		;get low pointer
	INX	H		;adjust pointer
	MOV	H,M		;get high pointer
	MOV	L,A		;point at disk descriptor
	ORA	H		;test for null drive
	RZ 			;if no entry in table, no disk
	MOV	A,E		;test if logged-in
	ANI	1		;(if lsb of E=1 skip log-in)
	JNZ	NOT$FIRST$SELECT
	PUSH	H		;save pointer
	XCHG			;copy to DE
	LXI	H,-2		;offset for relative drive code
	DAD	D		;add offset
	MOV	A,M		;get relative drive no.
	STA	@RDRV		;save it
	LXI	H,-6		;offset for login routine
	DAD	D		;point to it
	MOV	A,M		;get low address
	INX	H		;adjust pointer
	MOV	H,M		;get high address
	MOV	L,A		;copy low address
	CALL	IPCHL		;call drive LOGIN
	POP	D		;recover DPH pointer
	LXI	H,12		;offset for dpb pointer
	DAD	D		;point to it
	MOV	C,M		;get lo byte dpb address
	INX	H		;adjust pointer
	MOV	A,M		;get hi byte dpb address
	ORA	C		;test for 0 dpb
	JRNZ	GOT$XDPH	;skip if valid drive (not 0)
	LXI	D,0		;mark as bad drive
GOT$XDPH:
	XCHG			;xdph pointer into HL
NOT$FIRST$SELECT:		;all done
	RET

HOME:	LXI	B,0		;same as set track zero

SETTRK:	SBCD	@TRK		;save track no.
	RET

SETSEC:	SBCD	@SECT		;save sector no.
	RET

SETDMA:	SBCD	@DMA		;save dma address
	LDA	@CBNK		;default dma bank is current bank

SETBNK:	STA	@DBNK		;save dma bank
	RET

SECTRN:	MOV	L,C		;copy logical to result
	MOV	H,B
	MOV	A,D		;get table address
	ORA	E		;test for non-zero
	RZ			;done if no table
	DAD	D		;add logical to table base
	MOV	L,M		;get translated sector no.
	MVI	H,0		;make 16 bit
	RET
	PAGE
;****************************************************************
;*								*
;*		Disk Read and Write handlers.			*
;*								*
;****************************************************************
READ:	LHLD	@ADRV		;get absolute drive code
	MVI	H,0		;zero msb
	DAD	H		;double it
	LXI	D,@DTBL		;point to drive table
	DAD	D		;make address of table entry
	MOV	A,M		;get address low
	INX	H		;adjust pointer
	MOV	H,M		;get address high
	MOV	L,A		;form pointer
	PUSH	H		;save address of table
	LXI	D,-8		;offset for read routine
	DAD	D		;point to read routine address
	JMP	RW$COMMON	;use common code

WRITE:	LHLD	@ADRV		;get absolute drive code
	MVI	H,0		;zero msb
	DAD	H		;double it
	LXI	D,@DTBL		;point to drive table
	DAD	D		;make address of table entry
	MOV	A,M		;get address low
	INX	H		;adjust pointer
	MOV	H,M		;get address high
	MOV	L,A		;form pointer
	PUSH	H		;save address of table
	LXI	D,-10		;offset for write routine
	DAD	D		;point to write routine address
RW$COMMON:
	MOV	A,M		;get address low
	INX	H		;adjust pointer
	MOV	H,M		;get address high
	MOV	L,A		;form pointer
	POP	D		;recover address of table
	DCX	D
	DCX	D		;point to relative drive
	LDAX	D		;get relative drive no.
	STA	@RDRV		;post it
	INX	D
	INX	D		;point to DPH again
	PCHL			;leap to driver

MULTIO:	STA	@CNT		;save count
	RET

FLUSH:	XRA A 
	RET			;return with no error

DRIVE$MSG:
	DB	CR,LF,BELL,'BIOS Error on ',0
TRACK$MSG:
	DB	': T-',0
SECTOR$MSG:
	DB	', S-',0

	CSEG	;common memory
@ADRV:	DS	1		;currently selected disk drive
@RDRV:	DS	1		;controller relative disk drive
@TRK:	DS	2		;current track number
@SECT:	DS	2		;current sector number
@DMA:	DS	2		;current DMA address
@CNT:	DB	0		;record count for multisector transfer
@DBNK:	DB	0		;bank for DMA operations
@CBNK:	DB	0		;bank for processor operations

	END
