	TITLE 'Colex 800 series diskette handler'

; ***********  **********  ***           ******** ****          ****
;************ ************ ***          *********   ****      ****
;***          ***      *** ***          ***           ****  ****
;***          ***      *** ***          ********        ****
;***          ***      *** ***          ********          ****
;***          ***      *** ***          ***           ****  ****
;************ ************ ************ ****************      ****
; *********    **********   *********    *************          ****
;
;Copyright (c) 1983, Colex Electronic Co. Ltd. All rights reserved.
;
;     No  part of this publication may be  reproduced,   transmitted,
;transcribed,   stored in a retrieval system,  or translated into any
;language  or  computer  language,   in any form  or  by  any  means,
;electronic,   mechanical,  magnetic,  optical,  chemical,  manual or
;otherwise   without the prior written permission of Colex Electronic
;Co. Ltd., 623, Ocean Centre, Kowloon, Hong Kong.
;
;
;     Colex  makes no representations or  warranties with  respect to
;the   contents  hereof  and  specifically  disclaims   any   implied
;warranties of merchantability or fitness for any particular purpose.
;Further  Colex reserves the right to revise  this publication and to
;make  changes  from  time to  time  in the  content  hereof  without
;obligation  of  Colex  to  notify any person  of  such  revision  or
;changes.
;
	PAGE
;****************************************************************
;*								*
;*		Floppy disk driver for CP/M 3.0			*
;*								*
;****************************************************************
;  Date		  Author		Modification
;20-Apr-83	K.J. Brand	V1.0
;03-Jul-83	K.J. Brand	V1.1 bug in the login routine
;xx-Oct-83	R.J. Wellsted	V2.0 more bugs in login routine
;23-Nov-83	R.J. Wellsted	V2.1 bug in retry routine
;24-Nov-83	R.J. Wellsted	V2.2 not ready test in login, tick time-out
;27-Jan-84	R.J. Wellsted	V2.3 fixed bug in above.
	PAGE
	DSEG

	PUBLIC	FDXD0,FDXD1,FDXD2 ;public entry points

	EXTRN	@ADRV,@RDRV,@DBNK,@HD$UP
	EXTRN	@DMA,@TRK,@SECT	;various disk i/o parameters

	EXTRN	?WBOOT		;warm boot vector
	EXTRN	?PMSG		;print message @<HL> up to 00
	EXTRN	?PDEC		;print 16 bit binary number in <HL>
	EXTRN	?PDERR		;print BIOS disk error header
	EXTRN	?CONIN,?CONO	;con in and out
	EXTRN	?CONST		;get console status
	EXTRN	?BNKSL		;bank select routine

	MACLIB	PORTS		;i/o port equates
	MACLIB	CPM3		;cp/m 3 disk definition macros
	MACLIB	EQUATES		;system equates
	MACLIB	Z80		;z80 opcodes

CR	EQU	13
LF	EQU	10
BELL	EQU	7

RESTORE	EQU	9		;wd1797 restore command
STEP	EQU	59H		;wd1797 step in command
SEEK	EQU	19H		;wd1797 seek command
TIMES	EQU	3		;no. of retries before error
RDID$TIMES EQU	3		;number of passes through read-id
DRIVES	EQU	3		;must agree with drivers present

DD	EQU	10B		;mode bits for double density
EIGHT	EQU	01B		;mode bits for eight inch
SDENS	EQU	00B		;mode bits for single density
FIVE	EQU	00B		;mode bits for five inch
SD5SS	EQU	128		;hard core sector size for single
SD8SS	EQU	128		;density formats

DDS	EQU	-1		;flag for double sided drives
SS	EQU	0		;flag for single sided drives
	
				;sector size code as used in format
SS1024	EQU	3		; 3 = 1024
SS512	EQU	2		;   2 = 512
SS256	EQU	1		;     1 = 256
SS128	EQU	0		;       0 = 128

MOT	EQU	3		;motor on bit in drive select byte
SZ	EQU	5		;size select bit
RS	EQU	6		;reset for 1797
SD	EQU	7		;single/double density bit

XTRA	EQU	0		;one left to grow on
	PAGE
;****************************************************************
;*								*
;*	XDPHs for the floppies (each has extra bytes for mode)	*
;*								*
;****************************************************************
	DB	DD OR FIVE,DDS	;mode(dd 5"), 2 sided flag
	DB	SS512,XTRA	;sector size(512), extra byte
	DW	FD$WRITE	;floppy write
	DW	FD$READ		;floppy read
	DW	FD$LOGIN	;floppy login (set density, sector size & dpb)
	DW	FD$INIT		;floppy init
	DB	0,0		;relative drive 0
FDXD0:	DPH     TRAN5E,DPB5ED	;using params for largest possible drive

	DB	DD OR FIVE,DDS	;mode(dd 5"), 2 sided
	DB	SS512,XTRA	;sector size(512), extra byte
	DW	FD$WRITE	;floppy write
	DW	FD$READ		;floppy read
	DW	FD$LOGIN	;floppy login
	DW	FD$INIT		;floppy init
	DB	1,0		;relative drive 1
FDXD1:	DPH	TRAN5E,DPB5ED	;using params for largest posible drive

	DB	DD OR EIGHT,DDS	;dd 8", 2 sided
	DB	SS1024,XTRA	;1024 byte sectors, extra
	DW	FD$WRITE	;floppy write
	DW	FD$READ		;floppy read
	DW	FD$LOGIN	;floppy login
	DW	FD$INIT		;floppy init
	DB	2,0		;relative drive 2
FDXD2:	DPH	TRAN8X,DPB8XD	;using params for largest posible drive
	PAGE
;****************************************************************
;*								*
;*		The disk parameter blocks.			*
;*								*
;****************************************************************
	CSEG
	;8" configurations
DPB8SS:	DPB 128,26,77,1024,64,2		;8" ss/sd 128 b/s
DPB8DS:	;DPB 256,26,77,2048,128,2	;8" ss/dd 256 b/s
	DW	52			;sectors/track
	DB	4,15			;block shift/mask
	DB	0			;extent mask
	DW	242			;drive size
	DW	127			;dir entries
	DB	11000000B		;directory allocation
	DB	00000000B
	DW	(127/4)+1		;check vector size
	DW	2			;system tracks
	DB	1,1			;256 bytes/sector
DPB8DD:	DPB 256,52,77,2048,128,2	;8" ds/dd 256 b/s
DPB8ES:	DPB 512,16,77,2048,128,2	;8" ss/dd 512 b/s
DPB8ED:	DPB 512,32,77,2048,128,2	;8" ds/dd 512 b/s
DPB8XS:	DPB 1024,8,77,2048,128,2	;8" ss/dd 1024 b/s
DPB8XD:	DPB 1024,16,77,2048,128,2	;8" ds/dd 1024 b/s
	;5.25" configurations
DPB5SS:	DPB 128,16,80,1024,64,3		;5" ss/sd 128 b/s
DPB5DS:	DPB 256,16,80,2048,128,2	;5" ss/dd 256 b/s
DPB5DD:	DPB 256,32,80,2048,128,2	;5" ds/dd 256 b/s
DPB5ES:	DPB 512,10,80,2048,128,2	;5" ss/dd 512 b/s
DPB5ED:	DPB 512,20,80,2048,128,2	;5" ds/dd 512 b/s
	PAGE
;****************************************************************
;*								*
;*		The sector skew tables.				*
;*								*
;****************************************************************
	DSEG
	;8" tables
TRAN8S:	SKEW	26,6,1		;8" single side/single density
TRAN8D:	SKEW	26,9,1		;8" single side double density
	SKEW	26,9,27		; the other side
TRAN8X:	SKEW	8,3,1		;single side/extended density
	SKEW	8,3,9		; the other side
	;5.25" tables
TRAN5E:	SKEW	10,4,1		;5.25" single sided/extra density
	SKEW	10,4,11		; the other side

TRAN8E:
TRAN5S:
TRAN5D:	SKEW	32,1,1		;straight 1-1
	PAGE
;****************************************************************
;*								*
;*		 Initialization entry point.			*
;*	called for first time initialization. includes		*
;*	resetting 1797, DMA, initializing mode bytes, when	*
;*	doing drive 0. initializes <mode> for this drive from	*
;*	xdph.							*
;*								*
;****************************************************************
FD$INIT:
	MVI	A,-1		;load init error flag
	STA	ERROR$FLAG	;save in error flag, when this increments to 0
				;it tells error routine this is the first
				;time through so just change density
				;and re-log through cp/m
	MVI	A,11010000B	;set single density, no reset & 5.25"
	OUT	P$FDSTAT	;send to fdc
	LXI	H,-14		;start looking at mode bytes in xdph
	DAD	D		;de pointing to xdph on entry
	MOV	B,M		;b holds mode byte
	LDA	@RDRV		;use the relative drive as an offset
	MOV	E,A		;into various tables
	MVI	D,0		;make 16 bit
	LXI	H,MODE		;point to mode table
	DAD	D		;point to entry for this drive
	MOV	M,B		;set mode byte
	LXI	H,OLD$TRACK	;point to current track table
	DAD	D		;now init current track for this drive to -1
	MVI	M,-1		;so restore gets done
	RET
	PAGE
;****************************************************************
;*								*
;*		Floppy disk login routine.			*
;*	This entry is called when a logical drive is about to	*
;*	be logged in for the purpose of density determination.	*
;*	It adjusts the parameters contained in the disk		*
;*	parameter header pointed at by <DE> on entry to reflect	*
;*	what is found out by a read-id operation returning	*
;*	<mode>, <sides> and <max$sector> information, destroys	*
;*	all register, including <ix>. lacks confirmation of the	*
;*	single density format by a following read-id (the s/d	*
;*	params are returned on faith).				*
;*								*
;****************************************************************
FD$LOGIN:
	SSPD	SAVE$STACK	;save stack
	CALL	DISABLE		;disable time-outs
	LXI	SP,NEW$STACK	;set up local stack
	LXI	H,-14		;point to mode byte for this drive
	DAD	D		;starting with xdph address
	MOV	A,M		;get mode byte
	PUSH	PSW		;save mode
	RRC			;to see if its eight or five
				;carry will be set if eight inch
	LXIX	EIGHT$TABLE	;if 8", point to 8" part of table
	JRC	CONT		;skip if 8"
	LXIX	FIVE$TABLE	;if 5.25", point to 5.25" section
CONT:	LDA	@RDRV		;get relative drive code
	MOV	C,A    		;set up relative drive as a 16 bit value
	MVI	B,0		;in <bc>, <de> points to xdph
				;both saved until finished
	LXI	H,MODE		;point to mode table
	DAD	B		;point to entry for this drive
	POP	PSW		;get default mode
	ORI	DD		;assume double density
	MOV	M,A		;save default for now
	LXI	H,SELECT$TABLE	;point to drive select table
	DAD	B		;point to entry for this drive
	RRC			;eight inch drives set carry
	BIT	0,A		;single density drives set z flag
	MOV	A,M		;get select value (leaves flags set)
	SETB	RS,A		;turn off 1797 reset bit
	SETB	MOT,A		;assume 5.25" mode and turn on motor
	SETB	SZ,A		;assume 5.25" mode
	JRNC	NOT8		;skip if not 8"
	RES	SZ,A		;set 8" mode
	RES	MOT,A		;reset motor on bit
NOT8:	JRNZ	NOTS		;if z not set, then double density
	SETB	7,A		;single density has bit 7 set
NOTS:	OUT	P$SELECT	;and send to controller
	STA	OLD$SELECT	;save for subsequent checks during i/o
	LXI	H,REAL$SEL	;keeps a byte for this drive used for
	DAD	B		;later selects
	MOV	M,A		;store real select value in table
	LXI	H,OLD$TRACK	;point to current track table
	DAD	B		;point to entry for this drive
	MOV	A,M		;get which track we were on
	CPI	-1		;was it just after init?
	JRNZ	NOTINIT		;skip if not
	CALL	RESTOR		;yes, do a restore for first time
	XRA	A		;make a zero for track compare below
	MOV	M,A		;and save in table
NOTINIT:
	OUT	P$FDTRACK	;update track register
	CPI	2		;should be >= 2 for good test
	JRNC	INSIDE		;skip if so
	MVI	A,2		;else, seek track two
INSIDE:	OUT	P$FDDATA	;set up fdc for the seek
	MOV	M,A		;update current track table for this drive
	MVI	A,SEEK		;seek to 'this' track
	CALL	BUSY		;do the seek
	MVI	A,1		;set up for sector no. 1
	OUT	P$FDSECTOR	;send to the controller
	PUSH	B		;save relative drive offset
	CALL	READ$ID		;this returns <hl> pointing to read-id bytes
	POP	B		;used here to determine sector size if read
				;returned no errors
	ANI	10010000B	;checks rnf
	JNZ	ERROR		;error means its s/d or no disk
	           		;but if ok means its d/s-d/d or s/s-d/d
	INX	H
	INX	H		;point to sector size flag
	INX	H
	MOV	A,M		;retrieve it and...
	LXI	H,-12		;load offset for sector size in xdph
	DAD	D		;point to it
	MOV	M,A		;update value there
	MOV	L,A		;use the sector size flag to index into
	MVI	H,0		;parameter table later
	PUSH	D		;save xdph pointer
	XCHG			;save sector size code in <de> for now
	   	   		;need to count this next one down by size code
				;which is in <A>
	LXI	H,128		;this is the sector size that can get added
RE$ADD:	DAD	H		;at least once to itself, so it starts at 256
	DCR	A		;results in sector size in bytes in hl
	JRNZ	RE$ADD		;loop until done
	DCX	H		;so the dma can use it
	SHLD	ZDMA$LENGTH	;save in dma params
	XCHG			;getting back original sector size code
				;back into <hl>
	DCX	H		;make 1->0, 2->1, 3->2 cause table starts
				;with 256 byte sectors (size code 1)
	DAD	H		;*2
	DAD	H		;*4
	PUSH	H		;copy (sector size code-1)*4 into <de>
	POP	D
	DAD	H		;*8
	DAD	D		;=12*(sector size code-1)
	XCHG			;swap because you can't add <hl> and <ix>
				;(xdph on stack)
	DADX	D		;indexing into table for correct sector size
				;using ix as pointer
	POP	D		;get back xdph pointer
	LXI	H,-13		;load offset for double sided flag
	DAD	D		;point to flag in xdph
	MOV	A,M		;get flag
	ORA	A		;test it
	MVI	A,0		;set up for it being single sided
	JRZ	SINGL		;skip if single sided
	LDX	A,10		;find starting sector of second side in
				;table section for this drive/sector size
	ANI	10010000B	;checks drive not ready and rnf
	MVI	A,0		;again, assume single side
	JRNZ	SINGL		;jumps if true (i.e. error returned)
	XCHG			;else, save xdph pointer in <hl>
	LXI	D,6		;the index into double sided sub-section of
				;parameter table for this sector size
	DADX	D		;point to it
	XCHG			;get back xdph pointer to <de>
	MVI	A,-1		;to finally admit there is a second side
SINGL:	LXI	H,SIDES		;point to double sided flag
	DAD	B		;for this drive
	MOV	M,A		;signal double sided disk if allowed, else
				;single sided
	LDX	A,4		;get first sector second side, either -1
				;or the right value
	LXI	H,MAX$SECTOR	;point to max. sector table
	DAD	B		;point to entry for this drive
	MOV	M,A		;update current value
UPDATE$VECTOR:			;from here, update the current xdph with
				;values from table
	PUSHIX
	POP	H		;get pointer into table for source values
				;<de> had xdph address, remember
	LDI			;move trans address into xdph
	LDI			;hi byte
	XCHG			;get address in xdph into <hl> for increment
	LXI	B,10		;offset to the dpb value within the xdph
	DAD	B               ;(<bc> used to have rdrv value, not req'd now)
	XCHG			;<de> now pointing to dpb[rdrv], <hl> at
				;table data for dpb for this format
	LDI			;move it
	LDI			;dont forget the high byte
	CALL	ENABLE		;re-enable time outs
	LSPD	SAVE$STACK	;restore old stack
	RET

ERROR:	;get to here if d/d assumption was wrong
	;so anything left must be s/d or bad drive.
	LXI	H,-12		;index into xdph
	DAD	D		;to point to sector size code
	MVI	M,0		;and make it a zero, i.e. 128 bytes
	LXI	H,REAL$SEL	;point to select byte table
	DAD	B		;point to byte for this drive
	MOV	A,M		;get current select byte
	ORI	80H		;set single density mode
	MOV	M,A		;save
	OUT	P$SELECT	;select the floppy in sd mode
	STA	OLD$SELECT	;update memory copy
	LXI	H,MODE		;now look at mode
	DAD	B		;index into correct drive data
	MOV	A,M		;get mode byte
	ANI	NOT DD		;turning off double density bit
	MOV	M,A		;when we reset mode bit
	MVI	A,1		;use sector 1
	OUT	P$FDSECTOR	;send to fdc
	MVI	A,88H		;just a read with no data transfer
	CALL	BUSY		;from side 0
	LXIX	NO$DRIVE	;assume bad drive
	ANI	80H		;get fdc not ready bit
	JRNZ	UPDATE$VECTOR	;go tell the user
	LXIX	TABLE		;point to base of table
	MOV	L,M		;move mode into a 16 bit format
	MVI	H,0
	PUSH	D		;save xdph pointer
	DAD	H		;*2
	DAD	H		;*4
	DAD	H		;to get *8
				;mode=0 if 5", 1 if 8" and
				;mode*8 left in <hl>
	XCHG			;to add to ix
	DADX	D		;in order to index into 8" part of
				;s/d sub-section of table with ix
				;or stay in 5" s/d sub section
	LXI	H,TABLE+6	;base of table plus offset to sector size
	DAD	D		;info
	MOV	A,M		;this gets the sector size value, low byte
	INX	H
	MOV	H,M		;then high byte...
	MOV	L,A		;assembled in <hl>...
	DCX	H		;and decremented, so the dma can use it
	SHLD	ZDMA$LENGTH	;save in dma params
	POP	D		;retreiving xdph pointer
	LXI	H,SIDES		;point to sides table
	DAD	B		;point to entry for this this drive
	MVI	M,0		;indicating single sided operation
	JMP	UPDATE$VECTOR	;and tell the user

BUSY:	OUT	P$FDCMND	;send command to fdc
	MVI	A,0FH		;load delay count
DELA:	DCR	A		;adjust counter
	JRNZ	DELA		;loop until fdc stable
NOTYET:	IN	P$FDCMND	;get fdc status
	RRC			;test busy bit
	JRC	NOTYET		;loop if still busy
	IN	P$FDDATA	;reset dreq if data expected to be xfered
	IN	P$FDCMND	;get command status
	RET

NO$DRIVE:
	DW	0,0,0,0		;null drive
TABLE:				;where all the common trans/dpblk
				;and extra data is stored
				;note that each sec|or size group has a s/s
				;and d/s sub section except s/d which is
				;assumed to always be s/s
;   SINGLE DENSITY FORMATS:
	DW	TRAN5S		;pointer to xlate table
	DW	DPB5SS		;pointer to dpb
	DB	-1,XTRA		;single sided, 128 b/s
	DW	SD5SS		;single density 5.25" sector 3)ze

	DW	TRAN8S		;pointer to xlate table
	DW	DPB8SS		;pointer to dpb
	DB	-1,SS128	;singe sided, 128 b/s
	DW	SD8SS		;single density 8" sector size
;   DOUBLE DENSITY FORMATS:
FIVE$TABLE:
	DW	TRAN5D		;pointer to xlate table
	DW	DPB5DS		;pointer to dpb
	DB	-1,SS256	;single sided, 256 b/s

	DW	TRAN5D		;pointer to xlate table
	DW	DPB5DD		;pointer to dpb
	DB	17,SS256	;double sided, 256 b/s

	DW	TRAN5E		;pointer to xlate table
	DW	DPB5ES		;pointer to dpb
	DB	-1,SS512	;single sided, 512 b/s

	DW	TRAN5E		;pointer to xlate table
	DW	DPB5ED		;pointer to dpb
	DB	11,SS512	;double sided, 512 b/s
EIGHT$TABLE:
	DW	TRAN8D		;pointer to xlate table
	DW	DPB8DS		;pointer to dpb
	DB	-1,SS256	;single sided, 256 b/s

	DW	TRAN8D		;pointer to xlate table
	DW	DPB8DD		;pointer to dpb
	DB	27,SS256	;double sided, 256 b/s

	DW	TRAN8E		;pointer to xlate table
	DW	DPB8ES		;pointer to dpb
	DB	-1,SS512	;single sided, 512 b/s

	DW	0		;pointer to xlate table
	DW	DPB8ED		;pointer to dpb
	DB	17,SS512	;double  sided, 512 b/s

	DW	TRAN8X		;pointer to xlate table
	DW	DPB8XS		;pointer to dpb
	DB	-1,SS1024	;single sided, 1024 b/s

	DW	TRAN8X		;pointer to xlate table
	DW	DPB8XD		;pointer to dpb
	DB	9,SS1024	;double sided, 1024 b/s
	PAGE
;****************************************************************
;*								*
;*		Floppy Disk READ and WRITE entry points.	*
;*	these entries are called with the following arguments:	*
;*		relative drive number	in @rdrv (8 bits)	*
;*		absolute drive number	in @adrv (8 bits)	*
;*		disk transfer address	in @dma (16 bits)	*
;*		disk transfer bank	in @dbnk (8 bits)	*
;*		disk track address	in @trk (16 bits)	*
;*		disk sector address	in @sect (16 bits)	*
;*		pointer to XDPH		in DE			*
;*	they transfer the appropriate data, perform retries	*
;*	if necessary, then return a status code in A.		*
;*								*
;****************************************************************
FD$READ:
	LXI 	H,READ$MSG	;point to read text
	MVI 	A,88H		;load read command
	MVI 	B,17		;number of dma bytes for read
	JR 	RW$COMMON	;skip to common driver

FD$WRITE:
	LXI 	H,WRITE$MSG	;point to write text
	MVI 	A,0A8H		;load read command
	MVI 	B,19		;number of dma bytes for write

RW$COMMON:
	SSPD	SAVE$STACK	;save current stack
	LXI	SP,NEW$STACK	;piont to local stack
	PUSH	D		;save xdph pointer on new stack
	SHLD 	OPERATION$NAME	;save message pointer for errors
	STA 	DISK$COMMAND	;save 1797 command
	MOV 	A,B		;get dma byte count
	STA 	ZDMA$BYTES	;save it
	CALL	DISABLE		;disable time-outs
	LDA	@RDRV		;which drive being discussed
	MOV	E,A		;used as an offset to get to
	MVI	D,0		;drive relative data
	LXI	H,SIDES		;point to side table
	DAD	D		;point to entry for this drive
	BIT	0,M		;test if double or single sided
	JRZ	NOT$TWO		;skip if single
	LDA	@SECT		;get sector no.
	LXI	H,MAX$SECTOR	;point to sector no. table
	DAD	D		;point to the entry for this drive
	CMP	M		;see if on second side
	JRC	NOT$TWO		;treat same as single sided if not
	LXI	H,DISK$COMMAND	;piont to the disk command
	SETB	1,M		;set up for second side
NOT$TWO:
	XCHG			;DE had relative drive value, now in HL
	XTHL			;get xdph pointer from tos, now tos has rdrive
	LXI	D,-12		;offset for sector size code on xdph
	DAD	D		;point to it
	MOV	A,M		;get it (0:=128, 1:=256, 2:=512, 3:=1024)
	LXI	H,128		;set up least common denominator
	ORA	A		;test for 128 byte sectors
	JRZ	OUTNOW		;skip multiply if so
ADD$IT:	DAD	H		;else multiply by 2, 3, or 4
	DCR	A		;results in sector size in bytes in hl
	JRNZ	ADD$IT		;256, 512, or 1024
OUTNOW:	DCX	H		;so dma can use it
	SHLD	ZDMA$LENGTH	;save in dma params
	LHLD	@DMA		;get transfer address
	SHLD	ZDMA$DMA	;save in dma params
	POP	D		;get rel drive into DE
	LXI	H,REAL$SEL	;point to select code table
	DAD	D		;point to value for this drive
	MOV	A,M		;get the mask
	OUT	P$SELECT	;send it
	LXI	H,OLD$SELECT	;point to last mask sent
	CMP	M		;is it the same as last time?
	MOV	M,A		;so it will be next time
	EXAF			;store results till later
	LXI	H,OLD$TRACK	;point to track table
	DAD	D		;point to entry for this drive
	MOV	A,M		;get last track for this drive
	OUT	P$FDTRACK	;got to remind 1797 where it was
	EXAF			;get back results of same drive test
	LDA	@TRK		;find out where we need to go
	JRNZ	LETS$SEEK	;if drive changed, got to reseek
	CMP	M		;compare track we're on with what we want
	JRZ	MORE$RETRIES	;if same skip the seek
LETS$SEEK:
	OUT	P$FDDATA	;send track no. to 1797
	MOV	M,A		;update current track array
	MVI	A,SEEK		;load the seek command
	CALL	BUSY		;do it.
MORE$RETRIES:
	LDA	OLD$SELECT	;get the select value & send to fdc
	OUT	P$SELECT	;(in case deselected while waiting
				;for operator to say retry
	MVI 	C,TIMES		;allow 'times' retries
RETRY$OPERATION:
	PUSH 	B		;save retry counter
	LDA 	@SECT		;get sector no.
	OUT 	P$FDSECTOR	;send to 1797
	LXI 	H,DMA$BLOCK	;point to dma command block
	LDA	ZDMA$BYTES	;load no. of byte to send
	MOV	B,A		;save it
	MVI	C,P$ZDMA	;poin to dma port
	OUTIR			;send commands to Z80 DMA
	MVI	A,087H		;load dma enable command
	OUTP	A		;send it to dma
	LDA 	DISK$COMMAND	;get 1797 command
	CAL 	EXEC$COMMAN	;d i i whateve bank retur status
	STA 	DISK$STATUS	;save status for error messages
	POP 	B		;recover retry counter
	ORA 	A		;test for error
	LXI	H,ERROR$FLAG	;point at error flag
	JRNZ    ERRORS		;skip if there was an error
	MVI	M,-1		;after setting error flag to 'all ok'
GO$BACK:
	CALL	ENABLE		;re-enable time-outs
	LSPD	SAVE$STACK	;restore stack
	RET			;and return

ERRORS:
	MOV	B,A		;save error code
				;<hl> point to error$flag which is -1
;	INR	M		;if this is first unsuccessful attempt
;	MVI	A,-1		;return the media changed status so
;	JRZ	GO$BACK		;cp/m will do a re-login

	PUSH	B		;save error code on stack
	CALL 	RE$SEEK		;check we are on the correct track
        POP	B		;get error code back
	MOV	A,B		;get error code for testing
	ANI	0100$0000B	;check for write protect
	MVI	A,2		;send write protect return code to cpm
	JNZ	GO$BACK		;back to bdos
	DCR 	C 		;decrement tries
	JNZ 	RETRY$OPERATION	;if not exhausted, try again
	PAGE
;****************************************************************
;*								*
;*		Permanent error, print message like:		*
;*	BIOS Err on d: T-nn, S-mm, <operation> <type>, Retry ?	*
;*	but only on second pass through here because first	*
;*	time here is probably the result of a density change	*
;*	without an intervening ^C.				*
;*								*
;****************************************************************
	MVI	A,-1		;reset error$flag like everything's ok
	STA	ERROR$FLAG	;on retry, its like it was at beginning
	CALL 	?PDERR		;print message header
	LHLD 	OPERATION$NAME	;get operation text pointer
	CALL 	?PMSG		;print operation type
	LDA 	DISK$STATUS	;get status byte from last error
	LXI 	H,ERROR$TABLE	;point at table of message addresses
ERRM1:	MOV 	E,M		;get lo byte of message pointer
	INX 	H		;adjust pointer
	MOV 	D,M		;get hi byte of message pointer
	INX 	H 		;point to next message address
	ADD 	A		;shift error status
	PUSH 	PSW		;save residual bits
	XCHG			;swap pointer
	CC 	?PMSG		;print the message if required
	XCHG			;restore pointer
	POP 	PSW		;restore error status
	JRNZ 	ERRM1		;if any more bits left, continue
	LXI 	H,ERROR$MSG	;point to error message tail
	CALL 	?PMSG		;print tail
	CALL 	U$CONIN$ECHO	;get operator response
	ANI	5FH		;force upper case
	CPI 	'Y'		;test for retry
	PUSH	PSW		;save result of Y/N test
	MVI	C,CR		;load a cr
	CALL	?CONO		;send to console
	MVI	C,LF		;load a lf
	CALL	?CONO		;send to console
	POP	PSW		;get y/n test back
	JZ 	MORE$RETRIES 	;Yes, then retry 'retries' more times
	MVI	A,1		;otherwise,
	JMP	GO$BACK		;return hard error to BDOS
	PAGE
;****************************************************************
;*								*
;*		Try to recover from a disk error.		*
;*								*
;****************************************************************
RE$SEEK:
	CALL	RESTOR		;restore drive
	LXI	H,OLD$TRACK	;so we enter check$seek with HL right
	DAD	D		;DE holds rdrv
	MOV	A,M		;get where we are supposed to be
	OUT	P$FDDATA	;send to 1797
	MVI	A,SEEK		;load the seek command
	JMP	BUSY		;do it

RESTOR:	MVI 	A,RESTORE	;load restore command
	JMP	BUSY		;do it
	PAGE
;****************************************************************
;*								*
;*		Send a data transfer command to the fdc.	*
;*	issue 1797 command, and wait for busy to go active	*
;*	then go away, return status. this happens in common	*
;*	memory. blows away A and B.				*
;*								*
;****************************************************************
	CSEG			;has to be in common memory
EXEC$COMMAND:
	MOV	B,A		;save command for execution until we
	LDA	@DBNK		;change banks to where dma is required
	CALL	?BNKSL		;select the correct bank

CHECK$READY:
	IN	P$FDSTAT	;get drive status
	RLC			;check if ready
	JRNC	SEND$IT		;skip if so
	SETB	2,B		;fix up command so it can load head
	PUSH	B		;save command
	LXI	B,0		;load counter
DELAY:	NOP
	NOP
	NOP			;waste some time (5us)
	NOP
	NOP
	DCX	B		;adjust counter (1.5us)
	MOV	A,B		;get hi byte of count (1us)
	ORA	C		;test with low byte (1us)
	JRNZ	DELAY		;loop back if delay not done (3us)
	;total delay =65536 * 11.5us = 0.753 s
	POP	B		;return command to B
	IN	P$FDSTAT	;get disk status
	BIT	7,A		;test if ready now
	JRNZ	GET$OUT		;abort command if not
SEND$IT:
	MOV	A,B		;get command back
	OUT 	P$FDCMND	;send it
WAIT:	IN	P$FDCMND	;get fdc status
	RRC			;test if busy
	JRNC	WAIT		;wait for it to get busy
WAIT$BUSY:
	IN 	P$FDSTAT	;get fdc status
	RRC			;check if busy
	JRC 	WAIT$BUSY	;loop if so
	IN	P$FDDATA	;clear ireq
	IN 	P$FDSTAT	;get 1797 status
GET$OUT:
	MOV	B,A		;save status until banks get re-switched
	XRA	A		;we want bank 0
	CALL	?BNKSL		;select it
	MOV	A,B		;get status back
	RET
	PAGE
;****************************************************************
;*								*
;*		Utility Subroutines.				*
;*								*
;****************************************************************
	DSEG
DISABLE:			;disable the time-out counter
	PUSH	PSW		;save A & flags
	MVI	A,-1		;load -1
	STA	@HD$UP+1	;inhibit time-outs
	POP	PSW		;restore A & flags
	RET

ENABLE:	PUSH	PSW		;save A & flags
	MVI	A,128		;count for 4 sec time-out
	STA	@HD$UP		;init time out counter
	XRA	A		;load a 0
	STA	@HD$UP+1	;enable time-outs
	POP	PSW		;restore A & flags
	RET

READ$ID:
	MVI	C,RDID$TIMES	;we want to try rdid$times times
	MVI	B,11000100B	;read-id command, 15 ms delay
TRY$AGAIN:
	MOV	A,B		;get command back from b
	PUSH	B		;save command
	LXI 	H,READ$ID$BLOCK	;point to dma params
	LXI 	B,18*256+P$ZDMA ;load byte count & port no.
	OUTIR			;send params to dma
	CALL 	EXEC$COMMAND	;do the command
	ANI 	10011100B	;mask status
	POP	B		;reload the command
	JRZ	ITS$OK		;if status ok skip
	ANI	10000000B	;test if drive ready
	JRNZ	NOT$OK		;skip retries if not
	CALL	RESTOR		;restore the drive
	MVI	A,2		;we want track 2
	OUT	P$FDDATA	;send to fdc
	MVI	A,SEEK		;load the seek command
	CALL	BUSY		;do it
	DCR	C		;adjust retry counter
	JRNZ	TRY$AGAIN	;loop if not exhausted
NOT$OK:	MVI	A,90H		;signal record not found and drive not ready
	ORA	A		;so flags are set right on return
	MVI	B,2		;to show we are on track two
	RET
ITS$OK:	LXI 	H,ID$BUFFER	;point to id read from disk
	MOV 	B,M		;get actual track number in B
	RET			;and return with Z flag true for OK

U$CONIN$ECHO:
	CALL	?CONST		;get console status
	ORA 	A		;test for a char
	JRZ 	U$C1		;skip if none there
	CALL 	?CONIN		;get the char and throw away
	JR	U$CONIN$ECHO	;try again
U$C1:	CALL 	?CONIN		;get the char.
	PUSH 	PSW		;save it
	MOV 	C,A		;copy it
	CALL 	?CONO		;print it
	POP 	PSW		;get it back
	CPI 	'a'		;test if lower case
	RC			;done if not
	SUI 	'a'-'A'		;make upper case
	RET
	PAGE
;****************************************************************
;*								*
;*			Data Area.				*
;*								*
;****************************************************************
DISK$COMMAND:
	DS	1		;current wd1797 command
OLD$SELECT:
	DS	1		;last drive selected
OLD$TRACK:
	DS	DRIVES		;last track seeked to, one for each drive
ZDMA$BYTES:
	DS	1		;length of dma string

DISK$STATUS:
	DS	1		;last error status code for messages
MODE:	DS	DRIVES		;storage for 5.25"/8", s/d density
SIDES:	DS	DRIVES		;storage for no. of sides
MAX$SECTOR:
	DS	DRIVES		;for double sided, the first sector on
				;second side for this drive
REAL$SEL:
	DS	DRIVES		;where the complicated select values are kept
SELECT$TABLE:
	DB	0001B,0010B	;drives 0,1
	DB	0100B		;drive 2

READ$MSG:
	DB	', Read,',0
WRITE$MSG:
	DB	', Write,',0
OPERATION$NAME:
	DW	READ$MSG	;pointer to operation text

ERROR$TABLE:
	DW	B7$MSG		;nr message pointer
	DW	B6$MSG		;wp message pointer
	DW	B5$MSG		;wf message pointer
	DW	B4$MSG		;rnf message pointer
	DW	B3$MSG		;crc message pointer
	DW	B2$MSG		;ld message pointer
	DW	B1$MSG		;drq message pointer
	DW	B0$MSG		;busy message pointer

B7$MSG:	DB	' Not ready,',0
B6$MSG:	DB	' Protect,',0
B5$MSG:	DB	' Fault,',0
B4$MSG:	DB	' Record not found,',0
B3$MSG:	DB	' CRC,',0
B2$MSG:	DB	' Lost data,',0
B1$MSG:	DB	' DREQ,',0
B0$MSG:	DB	' Busy,',0

ERROR$MSG:
	DB	' Retry (Y/N) ? ',0
ERROR$FLAG:
	DB	0

DMA$BLOCK:			;for normal operations
	DB	0C3H
	DB	0C3H
	DB	0C3H
	DB	0C3H
	DB	0C3H
	DB	0C3H
	DB	14H		;channel A is incrementing memory
	DB	28H		;channel B is fixed port address
	DB	9AH		;RDY is high, CE/ only, stop on EOB
	DB	79H		;program all of ch. A, xfer B->A (temp)
ZDMA$DMA:
	DS	2		;starting DMA address
ZDMA$LENGTH:
	DS	2		;sector size-1
	DB	85H		;xfer byte at a time, ch B is 8 bit address
	DB	P$FDDATA	;ch B port address (1797 data port)
	DB	0CFH		;load B as source register
	DB	05H		;xfer A->B
	DB	0CFH		;load A as source register

READ$ID$BLOCK:			;to do a read id
	DB	0C3H
	DB	0C3H
	DB	0C3H
	DB	0C3H
	DB	0C3H
	DB	0C3H		;reset DMA channel
	DB	14H		;channel A is incrementing memory
	DB	28H		;channel B is fixed port address
	DB	9AH		;RDY is high, CE/ only, stop on EOB
	DB	79H		;program all of ch. A, xfer A->B (temp)
	DW	ID$BUFFER	;starting DMA address
	DW	6-1		;Read ID always xfers 6 bytes
	DB	85H		;byte xfer, ch B is 8 bit address
	DB	P$FDDATA	;ch B port address (1797 data port)
	DB	0CFH		;load dest (currently source) register
	DB	87H

	CSEG
ID$BUFFER:
	DS	6		;buffer to hold ID field
				;track
				;side
				;sector
				;length
				;CRC 1
				;CRC 2
SAVE$STACK:
	DS	2		;storage location for stack during execute
				;routine
	DS	64		;stack space for execute routine
NEW$STACK EQU	$

	END
