	TITLE 'System Control Block Definition for CP/M3 BIOS'

	PUBLIC @CIVEC, @COVEC, @AIVEC, @AOVEC, @LOVEC, @BNKBF
	PUBLIC @CRDMA, @CRDSK, @VINFO, @RESEL, @FX, @USRCD 
        PUBLIC @MLTIO, @ERMDE, @ERDSK, @MEDIA, @BFLGS
	PUBLIC @DATE, @HOUR, @MIN, @SEC, ?ERJMP, @MXTPA


SCB$BASE EQU    0FE00H          ; Base of the SCB

@CIVEC  EQU     SCB$BASE+22H    ; Console Input Redirection 
                                ; Vector (word, r/w)
@COVEC  EQU     SCB$BASE+24H    ; Console Output Redirection 
                                ; Vector (word, r/w)
@AIVEC  EQU     SCB$BASE+26H    ; Auxiliary Input Redirection 
                                ; Vector (word, r/w)
@AOVEC  EQU     SCB$BASE+28H    ; Auxiliary Output Redirection 
                                ; Vector (word, r/w)
@LOVEC  EQU     SCB$BASE+2AH    ; List Output Redirection 
                                ; Vector (word, r/w)
@BNKBF  EQU     SCB$BASE+35H    ; Address of 128 Byte Buffer 
                                ; for Banked BIOS (word, r/o)
@CRDMA  EQU     SCB$BASE+3CH    ; Current DMA Address 
                                ; (word, r/o)
@CRDSK  EQU     SCB$BASE+3EH    ; Current Disk (byte, r/o)
@VINFO  EQU     SCB$BASE+3FH    ; BDOS Variable "INFO" 
                                ; (word, r/o)
@RESEL  EQU     SCB$BASE+41H    ; FCB Flag (byte, r/o)
@FX     EQU     SCB$BASE+43H    ; BDOS Function for Error 
                                ; Messages (byte, r/o)
@USRCD  EQU     SCB$BASE+44H    ; Current User Code (byte, r/o)
@MLTIO	EQU	SCB$BASE+4AH	; Current Multi-Sector Count
				; (byte,r/w)
@ERMDE  EQU     SCB$BASE+4BH    ; BDOS Error Mode (byte, r/o)
@ERDSK	EQU	SCB$BASE+51H	; BDOS Error Disk (byte,r/o)
@MEDIA	EQU	SCB$BASE+54H	; Set by BIOS to indicate
				; open door (byte,r/w)
@BFLGS  EQU     SCB$BASE+57H    ; BDOS Message Size Flag (byte,r/o)  
@DATE   EQU     SCB$BASE+58H    ; Date in Days Since 1 Jan 78 
                                ; (word, r/w)
@HOUR   EQU     SCB$BASE+5AH    ; Hour in BCD (byte, r/w)
@MIN    EQU     SCB$BASE+5BH    ; Minute in BCD (byte, r/w)
@SEC    EQU     SCB$BASE+5CH    ; Second in BCD (byte, r/w)
?ERJMP  EQU     SCB$BASE+5FH    ; BDOS Error Message Jump
                                ; (word, r/w)
@MXTPA  EQU     SCB$BASE+62H    ; Top of User TPA 
                                ; (address at 6,7)(word, r/o)
	END

w)
@MXTPA  EQU     SCB$BA