TITLE	BOOT	RECORD


BURST	EQU	0
CR	EQU	0DH
LF	EQU	0AH
EOM	EQU	-1

;
; PRE-DEFINITION
;
BIOSIZS	EQU	300H			; SIZE OF IO.SYS IN PARA
RTDIR_SEG_AT EQU 1EE0H			; DUMMY
DIR_ENTSZ EQU	20H			; DIRECTORY ENTRY SIZE
STCK	EQU	300H			; INITIAL STACK POINTER
;
GETGIAT	EQU	99H
;

BPS_	EQU	512			; IF CHANGED, REVIEW PROCEDURE GET_FILE_SIZE

;
;
; DIR STRUCTURE
;
DIR_ENTRY STRUC
DIR_NAME DB	11 DUP (?)		; FILE NAME
DIR_ATTR DB	?			; ATTRIBUTE BITS
DIR_PAD	DB	10 DUP (?)		; RESERVED FOR EXPANSION
DIR_TIME DW	?			; TIME OF LAST WRITE
DIR_DATE DW	?			; DATE OF LAST WRITE
DIR_FIRST DW	?			; FIRST ALLOCATION UNIT OF FILE
DIR_SIZE_L DW	?			; LOW 16 BITS OF FILE SIZE
DIR_SIZE_H DW	?			; HIGH 16 BITS OF FILE SIZE
DIR_ENTRY ENDS
;
;
RTDIR_SEG SEGMENT AT RTDIR_SEG_AT
RTDIR_SEG ENDS
;
INCLUDE	\GIFI\SRC\GIFMAC.MAC
;
PUSHA	MACRO
	DB	60H
ENDM
;
POPA	MACRO
	DB	61H
ENDM
;
SHRAX	MACRO	CNT
	DB	0C1H, 0E8H, CNT
ENDM
;
; DISK OPERATION MACRO'S
;

RESET_	MACRO
	LOCAL	NOERR
	MOV	BX, RESET*4+DSKDEV*64
	CALL	GIFDIC
	JNC	NOERR
	JMP	FAIL_AND_DIE
NOERR:
ENDM

GST_	MACRO	FUNC
	LOCAL	NOERR
	MOV	DL, FUNC
	MOV	BX, GSTATUS*4+DSKDEV*64
	CALL	GIFDIC
	JNC	NOERR
	JMP	FAIL_AND_DIE
NOERR:
ENDM

SST_	MACRO	FUNC
	LOCAL	NOERR
	MOV	DL, FUNC
	MOV	BX, SSTATUS*4+DSKDEV*64
	MOV	AL, BOOT_DRIVE
	CALL	GIFDIC
	JNC	NOERR
	JMP	FAIL_AND_DIE
NOERR:
ENDM

READ_	MACRO	SEG
	LOCAL	NOERR
	MOV	BX, READ*4+DSKDEV*64
	XOR	DI, DI
	MOV	AX, SEG
	MOV	ES, AX
	MOV	AL, BOOT_DRIVE
	CALL	GIFDIC
	JNC	NOERR
	JMP	FAIL_AND_DIE
NOERR:
ENDM

;
CODE	SEGMENT				; AT 0
	ASSUME	CS:CODE, DS:CODE, ES:CODE
	ORG	0
;VVVVVV
; THE POSITION MUST BE FIXED UNTIL ^^^^^^
PUBLIC	BOOTSTART
BOOTSTART:
	JMP	START
;
	ORG	3
OEM	DB	'COLEX186'
; BPB
BPS	DW	200H
SEC_UNIT DB	2
RES_SEC	DW	1
NUM_FAT	DB	2
DIR_ENT	DW	4B0H
SEC_DISK DW	5A0H
DISK_MEDIA DB	0F9H
SEC_FAT	DW	2
SEC_TRK	DW	9
NUM_HEAD DW	2
HID_SEC	DW	0
;
RTDIR_SEC DW	5
DISK_DATA DW	50H
SUSHIFT	DB	1
TRKN	DW	80
GMED	DB	11H
;^^^^^^

; INTERNAL DATA AREA

BOOT_DRIVE DB	?
MSDOSEG	DW	?			; MSDOS SEGMENT
RTDSEG	DW	?			; ROOT SEGMENT
;
; GIAT (GIFDIC INTERNAL ADDRESS TABLE)
;
GIAT	LABEL	WORD
PROMVER	DW	?			; PROM VERSION
GIATSZ	DW	?			; NUMBER OF WORDS IN THIS TABLE
PROMPG	DW	?			; PROM PGROUP
PROMDG	DW	?			; PROM DGROUP
GIFDICC	DW	?			; GIFDIC CALL
GIFDICA	DW	?			; GIFDIC ADDRESS TABLE
ATTRTAB	DW	?			; GIFDIC ATTRIBUTE TABLE
EODATA	DW	?			; END OF PROM DATA AREA
MAXRAM	DD	?			; RAM SIZE IN BYTE

GIATCNT	EQU	($-GIAT)/2
;
; BIOS POINTER
BIOS	LABEL	DWORD
BIOSLOC	DW	0
BIOSSEG	DW	?

; GIFDIC POINTER
GIFDIC	LABEL	DWORD
GFDLOC	DW	?
GFDSEG	DW	?

START:
	CLI
	MOV	AX, CS
	MOV	DS, AX
	MOV	ES, AX
	MOV	SS, AX
	MOV	SP, STCK

; GET GIAT TABLE
	MOV	DI, OFFSET GIAT
	MOV	CX, GIATCNT
	INT	GETGIAT
	MOV	AX, EODATA
	SHRAX	4
	INC	AX
	ADD	AX, PROMDG
	MOV	BIOSSEG, AX
	ADD	AX, BIOSIZS
	MOV	MSDOSEG, AX
	MOV	AX, GIFDICC
	MOV	GFDLOC, AX
	MOV	AX, PROMPG
	MOV	GFDSEG, AX

	CMP	SUSHIFT, -1
	JNE	BOOTSYS
; NON-SYSTEM DISK
	MOV	DI, OFFSET NON_SYS_MSG
	JMP	PRINT_AND_DIE

BOOTSYS:

	MOV	DI, OFFSET OEM_COPYRIGHT
	CALL	PRINT

; GET BOOT DRIVE
	GST_	CTRLOG
	MOV	BOOT_DRIVE, AL

; RESET THE BOOT DRIVE
	RESET_

; SET BOOT DRIVE MEDIA
	MOV	DH, GMED
	CMP	DH, 0
	JZ	SHORT NONFLPB		; NON-FLOPPY BOOT
	SST_	MEDSET
NONFLPB:

; GET ROOT DIRECTORY
	MOV	AX, CS
	SUB	AX, BPS_/10H
	MOV	RTDSEG, AX
	MOV	DX, RTDIR_SEC
	MOV	CX, 1
	READ_	RTDSEG
;
	MOV	AX, RTDSEG
	MOV	DS, AX
	ASSUME	DS:RTDIR_SEG
	MOV	SI, 0			; START FROM THE FIRST FILES
;
; BE SURE THAT THE ORDER OF THE FIRST TWO FILES IS IO.SYS AND
; MSDOS.SYS.  THEY SHOULD BE PHYSICALLY CONSECUTIVE.
; (FOR TESTING PURPOSE, THE ROMRTN IS ON DISK.  SO THE THIRD FILE
; SHOULD BE BIOS.ROM)
;
	CALL	GET_PARM
	READ_	BIOSSEG
;
	CALL	GET_PARM
	READ_	MSDOSEG
;
BOOT_END:
	JMP	BIOS
;
FAIL_AND_DIE:
	MOV	DI, OFFSET BOOT_FAIL_MSG
PRINT_AND_DIE:
	CALL	PRINT
	JMP	$

PRINT	PROC	NEAR
	PUSH	DS
	PUSH	ES
	PUSHA
	MOV	AX, CS
	MOV	ES, AX
	XOR	CX, CX
	MOV	CL, EOM
IF	BURST
	MOV	AH, 0C2H		; BURST MODE, STOP CHAR, WAIT
	MOV	BX, WRITE*4+SCONDEV*64
	CALL	GIFDIC
ELSE
	MOV	AX, ES
	MOV	DS, AX
	MOV	SI, DI
PADLP:
	LODSB
	CMP	AL, CL
	JE	PADLPEND
	MOV	AH, 2
	MOV	BX, WRITE*4+SCONDEV*64
	CALL	GIFDIC
	JMP	PADLP
PADLPEND:
ENDIF
	POPA
	POP	ES
	POP	DS
	RET
PRINT	ENDP

;
OEM_COPYRIGHT DB CR, LF, 'COLEX VME/186'
	DB	CR, LF, 'COPYRIGHT 1983,1984,1985 COLEX INC.'
	DB	CR, LF, EOM
NON_SYS_MSG DB	CR, LF, 'NON-SYSTEM DISK', EOM
BOOT_FAIL_MSG DB CR, LF, 'BOOT FAILURE', EOM
;
GET_PARM PROC	NEAR
	CALL	GET_START_SEC
	CALL	GET_FILE_SIZE
	ADD	SI, SIZE DIR_ENTRY
	RET
GET_PARM ENDP
;
GET_START_SEC PROC NEAR
	MOV	DX, [SI.DIR_FIRST]
	SUB	DX, 2
	MOV	CL, SUSHIFT
	SHL	DX, CL
	ADD	DX, DISK_DATA
	RET
GET_START_SEC ENDP
;
GET_FILE_SIZE PROC NEAR
	MOV	CX, [SI.DIR_SIZE_L]	; FOR NOW, THE HIGHER WORD IS 0
	SHR	CH, 1			; DIVIDED BY 200H
	MOV	CL, CH
	XOR	CH, CH
	INC	CX
	RET
GET_FILE_SIZE ENDP
;
CODE	ENDS
;
END
