/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)dmap.h	1.4"	*/

#ifndef dmap_h
#define dmap_h

#include <sys/types.h>

/*
 * Definitions for the mapping of virtual swap
 * space to the physical swap area - the disk map.
 * For data and stack, a doubling algorithm is used
 * The original size of process is allocated exactly, the length
 * stored in fsize. Only DMMAX cliks are allocated as a chunk, so the
 * first 'n' addrs may be used for the initial allocation.
 * 'n' is (size (in cliks) of segment / DMMAX) + 1
 * After that, a block size of DMMIN click, then
 * 2 * DMMIN, 4 * DMMIN, 8 * DMMIN, etc,
 * up to DMMAX.
 * To compute required NDMAP, we note that at worst, the initial allocation
 * will use 1 addr to describe just 1 clik of process. Thereafter,
 * the doubling algorithm takes over:
 *	For DMMIN = 1; DMMAX = 64; max virtual process 4.0Mb
 *	We need 15 addrs to map 3.75 Mb plus 6 addrs to map .25M - 4K
 *	Plus 1 for initial gives 22 addrs required.
 * NOTE: we use ushorts, which limits us to 256M of swap (since all
 * addrs are in cliks)
 */

#define	NDMAP 		22	/* size of the swap area map */
#define	DMMIN 		1	/* the initial block size in clicks */
#define	DMMAX		64	/* max block size alloc on drum = .25M byte */
#define	DMTEXT		64	/* size of blocks of pure text = .25M byte */
#define DMMASK		(DMMAX-1)	/* get remainder */
#define DMTMASK		(DMTEXT-1)	/* get remainder */

struct	dmap
{
	ushort	dm_size;	/* current size (in clicks) used by process */
	ushort	dm_alloc;	/* amount of physical swap space allocated */
	ushort	dm_fsize;	/* size (in clicks) of 1st chunk */
	ushort	dm_map[NDMAP];	/* 1st disk block number (in clicks) in each chunk */
};

/*
 * The following structure is that ``returned''
 * from a call to vstodb().
 */
struct	dblock
{
	swblk_t	db_base;	/* disk addr of physical contig drum block */
	swblk_t	db_size;	/* size of block (in cliks) */
};
#endif
