/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)gdioctl.h	1.4"	*/

#ifndef gdioctl_h
#define gdioctl_h
#include "sys/gdisk.h"

/*
 * Ioctl control packet
 */
struct gdctl {
	unsigned short	status;	/* status */
	struct gdswprt	params;	/* description of the disk */
	short		dsktyp;	/* the type of disk */
};
#define	GDIOCTYPE	0xff00		/* same as TTY IOCTYPE - identifies
					   type as disk, returns GDIOC */

#define	GDIOC		('G'<<8)
#define	GDGETA		(GDIOC|1)	/* get gdisk structure */
#define	GDSETA		(GDIOC|2)	/* set gdisk structure */
#define	GDFORMAT	(GDIOC|3)	/* format track command */
#define	GDDISMNT	(GDIOC|4)	/* flush buffers ready for removing */
#define GDNOTIFY	(GDIOC|5)	/* notify this proc via SIGUSR1 when
						disk comes on line */
#define GDUNNOTIFY	(GDIOC|6)	/* clear notification needed */

/*
 * Disk types
 */
#define	GD_WIN	HD	/* Winchester */
#define	GD_SYQ	SY	/* Syquest */
#define	GD_FLP	FD	/* Floppy */

/*
 * Status bits
 */
#define VALID_VHB	F_CT_FMT	/* valid vhb has been read */
#define DRV_READY	F_READY		/* the disk is on line */
#define PULLED		F_PULLED	/* the disk was removed without permission last time */
#endif gdioctl_h
