/*	Convergent Technologies - System V - Jul 1983	*/
/*	"@(#)i8259.h	1.2"	*/

#ifndef i8259_h
#define i8259_h

/*
 *	Definitions for the I8259 Interrupt controller.
 */

/*	Initialisation control word 1 - ICW1	*/
#define ICW4_NEED	0x01		/* =1 then ICW4 needed */
#define SINGL		0x02		/* =1 single else cascade mode */
#define CADI4		0x04		/* =1 call addr interval =4 else 8 */
#define	LTIM		0x08		/* =1 level triggered else edge trig */
#define MBONE		0x10		/* must be set in ICW1 */
#define VEC85MSK	0xe0		/* interrupt vector address 8085 mode */

/*	Initialisation control word 2 - ICW2	*/
#define VEC86MSK	0xf8		/* t7-t3 interrupt vector addr (8086) */

/*	Initialisation control word 3 - ICW3 - not needed SINGL mode	*/

/*	Initialisation control word 4 - ICW4	*/
#define MICP_MD		0x01		/* =1 8086 else 8085 */
#define AEOI		0x02		/* =1 auto EOI else normal EOI */
#define MSTR_SLV	0x04		/* =1 master else slave */
#define BUF_MD		0x08		/* =1 buffered mode else non buffered */
#define SFN_MD		0x10		/* =1 special fully nested mode */

/*	Operation control word 1 - OCW1	*/
/*	For enabling/disabling interrupts	*/
#define DISABCH0	0x01		/* =1 channel 0 interrupts disabled */
#define DISABCH1	0x02		/* =1 channel 1 interrupts disabled */
#define DISABCH2	0x04		/* =1 channel 2 interrupts disabled */
#define DISABCH3	0x08		/* =1 channel 3 interrupts disabled */
#define DISABCH4	0x10		/* =1 channel 4 interrupts disabled */
#define DISABCH5	0x20		/* =1 channel 5 interrupts disabled */
#define DISABCH6	0x40		/* =1 channel 6 interrupts disabled */
#define DISABCH7	0x80		/* =1 channel 7 interrupts disabled */

/*	Operation control word 2 - OCW2	*/
#define IR_LVL		0x07		/* IR level to be acted upon */
#define OCW2		0x00		/* d3=0 for OCW2 else OCW3 */
/*	d4 must be zero	*/
#define EOI_MSK		0xe0		/* mask for eoi command bits */
/*	eoi command values	*/
#define RAEOICLR	0x00		/* rotate in automatic eoi mode (clr) */
#define NONSPEOI	0x20		/* non specific eoi command */
#define EOINOP		0x40		/* nop */
#define SPEOI		0x60		/* specific eoi command */
#define RAEOISET	0x80		/* rotate in automatic eoi mode (set) */
#define RNONSPEOI	0xa0		/* rotate on non specific eoi cmnd */
#define SETPRIO		0xc0		/* set priority command */
#define RSPEOI		0xe0		/* rotate on specific eoi command */

/*	Operation control word 3 - OCW3	*/
#define OCWRIS		0x01		/* =1 read IS reg else IR reg if RR=1 */
#define OCWRR		0x02		/* =1 enable RIS */
#define OCWPOLL		0x04		/* =1 poll command else no poll */
#define OCW3		0x08		/* d3=1 for OCW3 else OCW2 */
/*	d4 must be zero	*/
#define OCWSMM		0x20		/* =1 set special mask if ESMM=1 */
#define OCWESMM		0x40		/* =1 enables SMM */
/*	d7 must be zero	*/

#endif i8259_h
