/*	Convergent Technologies - System V - January 1984 */
/*	"@(#)notify.h	1.3" */
#ifndef notify_h
#define notify_h

/*
 * defines, structs, etc for system calls: notify, unnotify, evwait, evnowait
 */

/* events that can be waited on: */
#define PIPEADD		1		/* notify when chars added to pipe */
#define TTYADD		2		/* notify when chars have been typed */
#define NOTICC		3		/* notify when caller gets an ICC msg */
#define UMSG		4		/* notify on receipt of Unix5 msg */
#define PROCDIED	5		/* notify on arbitrary process death */
#define ASYNCREAD	6		/* notify when async read completes */
#define ASYNCWRITE	7		/* notify when async write completes */
#define NOTFUNLOCK	8		/* notify when file unlocked */
#define NOTSIG		9		/* signal */

/* the following 'types' may be returned on an ev_wait */
#define NOTLOSTSIG	254		/* lost a signal */
#define NOTLOST		255		/* lost a notification */

/* internal representation for lost notification is high bit */
#define LOSTNOT		0x8000

/* The following structure is chained on the user struct, 1 for each
 * notification received
 */
typedef struct ev_not EV_NOT;
struct ev_not {
	EV_NOT	*ev_fwd;		/* link list */
	char 	*ev_tag;		/* user supplied identifier */
	char	*ev_data;		/* type dependent field */
	ushort	ev_type;		/* what type */
};

/* Struct, 1 for each process and each notification asked for via notify */
typedef struct ev_tab EV_TAB;
struct ev_tab {
	EV_NOT	*ev_ptr;		/* ptr to head of ev's for process */
	char	*ev_tag;		/* user supplied identifier */
	ushort	*ev_srcptr;		/* ptr to entry in notifiable struct */
	ushort	ev_link;		/* link to others wanting notify */
};

/* kernel calls associated with notify */
#define	NOTIFY_SYS	0
#define UNNOTIFY_SYS	1
#define EVWAIT		2
#define EVNOWAIT	3

#define EVT_INVALID	((EV_NOT *)0)
#define EVT_NOLINK	((ushort) -1)

/* defines for special instructions to not_sendnot */
#define QONLY		0	/* Q notification only */
#define NDELETE		1	/* Q notification and delete request */

#endif notify_h
