/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)param.h	1.9"	*/

#ifndef param_h
#define param_h
/*
 * fundamental variables
 * don't change too often
 */

#define	NOFILE	20		/* max open files per process */
#define	MAXPID	30000		/* max process id */
#define	MAXUID	60000		/* max user id */
#define	MAXLINK	1000		/* max links */

#ifndef ASM
#include <sys/types.h>
#endif

#define	CANBSIZ	256		/* max size of typewriter line	*/
#define	HZ	60		/* Ticks/second of the clock */
#define	NCARGS	5120		/* # characters in exec arglist */

/*
 * priorities
 * should not be altered too much
 */

#define	PMASK	0177
#define	PCATCH	0400
#define	PSWP	0	/* swapper needs a swap candidate */
#define	PINOD	10	/* process accessing locked inode */
#define	PRIBIO	20	/* process sleeping on block I/O system buffer */
#define	PZERO	25	/* sleep <= PZERO not broken by signals */
#define	NZERO	20	/* default process nice */
#define	PPIPE	26	/* sleeping on empty pipe read, full pipe write */
#define	TTIPRI	27	/* waiting for tty input (was 28) */
#define	PEXWT	28	/* user wait on exchange: exWait() or exCall() */
#define	TTOPRI	29	/* waiting for space in tty output clist */
#define	PWAIT	30	/* waiting death of child: wait() sys call */
#define	PSLEP	39	/* waiting signal: pause() sys call */
#define	PUSER	60	/* base priority for user process with dflt nice */
#define	PIDLE	127	/* no runnable processes in system */

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define	NBPW	sizeof(int)	/* number of bytes in an integer */

#ifdef KERNEL
#define FsTYPE	2
#else
/* some commands are more compatible if use dual file system */
#ifndef	FsTYPE
#define	FsTYPE	3
#endif
#endif KERNEL

#if FsTYPE==1
	/* Original 512 byte file system */
#define	BSIZE	512		/* size of file system block (bytes) */
#define	SBUFSIZE	BSIZE	/* system buffer size */
#define	BSHIFT	9		/* LOG2(BSIZE) */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	0777		/* BSIZE-1 */
#define	INOPB	8		/* inodes per block */
#define	INOSHIFT	3	/* LOG2(INOPB) if exact */
#define	NMASK	0177		/* NINDIR-1 */
#define	NSHIFT	7		/* LOG2(NINDIR) */
#define	FsBSIZE(dev)	BSIZE
#define	FsBSHIFT(dev)	BSHIFT
#define	FsNINDIR(dev)	NINDIR
#define	FsBMASK(dev)	BMASK
#define	FsINOPB(dev)	INOPB
#define	FsLTOP(dev, b)	b
#define	FsPTOL(dev, b)	b
#define	FsNMASK(dev)	NMASK
#define	FsNSHIFT(dev)	NSHIFT
#define	FsITOD(dev, x)	itod(x)
#define	FsITOO(dev, x)	itoo(x)
#endif

#if FsTYPE==2
	/* New 1024 byte file system */
#define	BSIZE	1024		/* size of file system block (bytes) */
#define	SBUFSIZE	BSIZE	/* system buffer size */
#define	BSHIFT	10		/* LOG2(BSIZE) */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	01777		/* BSIZE-1 */
#define	INOPB	16		/* inodes per block */
#define	INOSHIFT	4	/* LOG2(INOPB) if exact */
#define	NMASK	0377		/* NINDIR-1 */
#define	NSHIFT	8		/* LOG2(NINDIR) */
#define	Fs2BLK	0x2000
#define	FsBSIZE(dev)	BSIZE
#define	FsBSHIFT(dev)	BSHIFT
#define	FsNINDIR(dev)	NINDIR
#define	FsBMASK(dev)	BMASK
#define	FsINOPB(dev)	INOPB
#define	FsLTOP(dev, b)	(b<<1)
#define	FsPTOL(dev, b)	(b>>1)
#define	FsNMASK(dev)	NMASK
#define	FsNSHIFT(dev)	NSHIFT
#define	FsITOD(dev, x)	itod(x)
#define	FsITOO(dev, x)	itoo(x)
#define	FsINOS(dev, x)	((x&~017)+1)
#define	FsBOFF(dev, x)	((x)&01777)
#define	FsBNO(dev, x)	((x)>>10)
#endif

#if FsTYPE==3
	/* Dual system */
#define	BSIZE	512		/* size of file system block (bytes) */
#define	SBUFSIZE	(BSIZE*2)	/* system buffer size */
#define	BSHIFT	9		/* LOG2(BSIZE) */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	0777		/* BSIZE-1 */
#define	INOPB	8		/* inodes per block */
#define	INOSHIFT	3	/* LOG2(INOPB) if exact */
#define	NMASK	0177		/* NINDIR-1 */
#define	NSHIFT	7		/* LOG2(NINDIR) */
#define	Fs2BLK	0x2000
#define	FsLRG(dev)	(dev&Fs2BLK)
#define	FsBSIZE(dev)	(FsLRG(dev) ? (BSIZE*2) : BSIZE)
#define	FsBSHIFT(dev)	(FsLRG(dev) ? 10 : 9)
#define	FsNINDIR(dev)	(FsLRG(dev) ? 256 : 128)
#define	FsBMASK(dev)	(FsLRG(dev) ? 01777 : 0777)
#define	FsBOFF(dev, x)	(FsLRG(dev) ? ((x)&01777) : ((x)&0777))
#define	FsBNO(dev, x)	(FsLRG(dev) ? ((x)>>10) : ((x)>>9))
#define	FsINOPB(dev)	(FsLRG(dev) ? 16 : 8)
#define	FsLTOP(dev, b)	(FsLRG(dev) ? b<<1 : b)
#define	FsPTOL(dev, b)	(FsLRG(dev) ? b>>1 : b)
#define	FsNMASK(dev)	(FsLRG(dev) ? 0377 : 0177)
#define	FsNSHIFT(dev)	(FsLRG(dev) ? 8 : 7)
#define	FsITOD(dev, x)	(daddr_t)(FsLRG(dev) ? \
	((unsigned)x+(2*16-1))>>4 : ((unsigned)x+(2*8-1))>>3)
#define	FsITOO(dev, x)	(daddr_t)(FsLRG(dev) ? \
	((unsigned)x+(2*16-1))&017 : ((unsigned)x+(2*8-1))&07)
#define	FsINOS(dev, x)	(FsLRG(dev) ? \
	((x&~017)+1) : ((x&~07)+1))
#endif

#define	NICFREE	50		/* number of superblock free blocks */
#define	NULL	0
#define	CMASK	0		/* default mask for file creation */
#define	NODEV	(dev_t)(-1)
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#define	SUPERB	((daddr_t)1)	/* physical block number of the super block */
#define	SUPERBOFF	512	/* byte offset of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#define	NICINOD	100		/* number of superblock inodes */

#define DS	1		/* used by expand to expand ds size */
#define SS	2		/* used by expand to expand ss size */
#define	NCPS	16		/* Number of clicks per segment */
#define	CPSSHIFT	4	/* LOG2(NCPS) if exact */
#define	NBPC	4096		/* Number of bytes per click */
#define	BPCSHIFT	12	/* LOG2(NBPC) if exact */
#define	MAXMEM	(1024)		/* max virtual core in 4096-byte clicks */
#define	MAXBLK	64		/* max blocks possible for phys IO */
				/* limited by the number of Kernel map slots
				   dedicated to dma */
#define	SSIZE	2048		/* initial stack size (in bytes) */
#define	SINCR	2		/* increment of stack (*4096 bytes) */
#define YELLOWZONE	64	/* stack auto expansion zone */
#define	UPAGES	1
#define	USIZE	(UPAGES + 1)	/* size of user block (*4096) */
#define KSTACK		0x70600		/* kernel stack address */
#define VUSER_START	0x80000		/* start address of user process */
#define PTE_BANK0	256	/* size of mpte's in the first page of u */
#define	SYSPAGE		128	/* page table entries reserved for kernel */
#define VPG_BASE	0x70000	/* starting virtual address of user pages */
#define U_OFFSET	0x0600	/* offset of u struct into user pages */
#define	PTE_OFFSET	0xC00	/* offset of pte in usr tbl */
#define	VPTE_BASE	0x70C00	/* starting virtual address of pte in u */

/*
 * Some macros for units conversion
 */
#ifndef ASM
#include <sys/sysmacros.h>
#endif

/*	Machine-dependent bits and macros	*/

#define	SUPVMODE	0x2000		/* usermode bits */
#define	USERMODE(ps)	((ps & SUPVMODE) == 0)

#define	BASEPRI(ps)	((ps & 0x700) != 0)

#define	lobyte(X)	(((unsigned char *)&X)[1])
#define	hibyte(X)	(((unsigned char *)&X)[0])
#define	loword(X)	(((ushort *)&X)[1])
#define	hiword(X)	(((ushort *)&X)[0])

#endif param_h
