/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)pt422.h	1.7"	*/

/*
 * format of ctos runfile header.
 * header is first 512 bytes, followed by memory image starting at zero.
 */
struct runfile {
	ushort magic;		/* magic number */
	char fill1[2];		/* filler */
	unsigned char cpgnums[2];	/* count page numbers */
	char fill2[2];		/* filler */
	char cnt[2];		/* count of 16 byte units */
	char fill3[10];		/* filler */
	char rastart[2];	/* relative start */
	char sastart[2];	/* segment start */
};

#define RUNFILEMAGIC	0x4757

/*
 *	format of write circ request at start of xbuf data field.
 */
struct wcreq {
	short bytesbelow;	/* # of bytes below (swapped) */
	short sInfo;		/* */
	char  nReqPbCb;		/* */
	char  nRespPbCb;	/* */
	short userNum;		/* IGNORED */
	short exchResp;		/* IGNORED */
	short ercRet;		/* error return code */
	short rqc;		/* request code */
	char  bDestCPU;		/* IGNORED */
	char  bSourceCPU;	/* IGNORED */
	char  bPort;		/* IGNORED */
	wndw_t  bWindow;	/* */
	uint  pFifo;		/* */
	short sFifo;		/* */
	short loSavedPut;	/* */
	short loTop;		/* */
	short loBot;		/* */
	short loGet;		/* */
	short loPut;		/* */
	char  foLock;		/* */
	char  foCarrier;	/* */
	char  rgbAP[8];		/* */
	char  Data;		/* */
};

#define ADDWCREQ		((sizeof (struct wcreq)) - 2)

struct rreq {
	short bytesbelow;	/* # of bytes below (swapped) */
	short sInfo;		/* */
	char  nReqPbCb;		/* */
	char  nRespPbCb;	/* */
	short userNum;		/* IGNORED */
	short exchResp;		/* IGNORED */
	short ercRet;		/* error return code */
	short rqc;		/* request code */
	char  bDestCPU;		/* IGNORED */
	char  bSourceCPU;	/* IGNORED */
	char  bPort;		/* IGNORED */
	wndw_t  bWindow;	/* */
	char  bTime;		/* */
	char  bDummy;		/* UNUSED */
	uint  psCountRet;	/* */
	short ssCountRet;	/* */
	uint  pDataRet;		/* */
	short sDataRet;		/* */
	short RetCnt;		/* returned count (not byte swapped) */
	char  Data;		/* start of returned data */
};

/* give size of rreq up to RetCnt (but not including) */
#define ADDRREQ		((sizeof (struct rreq)) - 4)


/* generic header */
struct rqhd {
	short bytesbelow;	/* # of bytes below (swapped) */
	short sInfo;		/* */
	char  nReqPbCb;		/* */
	char  nRespPbCb;	/* */
	short userNum;		/* IGNORED */
	short exchResp;		/* IGNORED */
	short ercRet;		/* error return code */
	short rqc;		/* request code */
	char  bDestCPU;		/* IGNORED */
	char  bSourceCPU;	/* IGNORED */
	char  bPort;		/* IGNORED */
	wndw_t  bWindow;	/* */
};
#define ADDRRQ		(sizeof (struct rqhd))
#define XBRDSZ		(sizeof (struct rreq))	/* size of header for a read */
#define XBWCDSZ		(sizeof (struct wcreq))	/* size of header for a write */

/* request codes  */
#define rqcReadTerminal		0x3015
#define rqcWriteTerminal	0x302a
#define rqcWcircTerminal	0x3000
#define rqcCloseTerminal	0x3013
#define rqcTSPIoctl			0x3016

/* error codes */
#define ercBadWindow		0x7001
#define ercDeleted			0x7006

#define SWAPUSHORT(x)	(((x) >> 8) | (((x) & 0xFF) << 8))
#define NWNDWS		6	/* max # of windows per PT */

/* The following 2 xbufs are special purpose and their data sizes
 * as defined above are over and above any header size
 */
#define NXRDATA		       64	/* number of data bytes for a read*/
#define NXWDATA		       64	/* # of data bytes for small write 
					 * note: data includes write header*/

struct xwbuf {				/* transmission buffer (small)	*/
    struct xbuf		*x_next;	/* next pointer			*/
    short		x_size;		/* number of bytes in the xbuf	*/
    char		x_pool;		/* is this a read or a write xbuf */
    char		x_wndw;		/* window number for this xbuf */
    char		x_addr;		/* comm-level (ADCCP) address	*/
    char		x_cntl;		/* comm-level (ADCCP) control	*/
    char		x_data[NXWDATA+XBWCDSZ];/* data bytes		*/
};

struct xrbuf {				/* transmission buffer (read)	*/
    struct xbuf		*x_next;	/* next pointer			*/
    short		x_size;		/* number of bytes in the xbuf	*/
    char		x_pool;		/* is this a read or a write xbuf */
    char		x_wndw;		/* window number for this xbuf */
    char		x_addr;		/* comm-level (ADCCP) address	*/
    char		x_cntl;		/* comm-level (ADCCP) control	*/
    char		x_data[NXRDATA+XBRDSZ];/* data bytes		*/
};


/* struct to hold tty structs per window NOTE: don't add othjer elements,
 * numerous places in pt422.c assumes a linear array of tty's
 */
struct pt_tty {
	struct tty	tt_tty[NWNDWS];
};
struct pt_spbufs {
	struct xrbuf	tt_xrbuf[NWNDWS];
	struct xwbuf	tt_xwbuf[NWNDWS];
};

/* flags in t_dstat (size char) of tty struct */
#define PTSTATE		0x07		/* mask for drop state
							(defined in cl.h) */
#define PTRDREQ		0x10		/* read issued to this pt */
#define PTNEEDWR	0x20		/* write delayed due to lack of xbufs */
#define PTWAITCLOSE	0x40		/* wait for CloseTerminal to complete */

/* hold info about "direct mode" */
struct pt_direct {
	union {
		struct xbuf		*pt_xp;
		struct pt_direct	*pt_next;
	} un;
	short unsigned	pt_flags;
	short unsigned	pt_dev;
};
#define PTVALID		0x1
#define PTFLUSHED	0x2

/*
 *	FAILURE CODES from pt_download.
 */
#define PTFAILVHB	1		/* can not read vhb on the winchester */
#define PTNODLFILE	2		/* no down load file */
#define PTFAILDLIND	3		/* can not read down load index */
#define PTFAILRUNFILE	4		/* can not read run file header */
#define PTFAILRMAGIC	5		/* wrong magic # in run file header */
#define PTFAILRDATA	6		/* can not read run file block */
#define PTFAILNORUNFILE 7		/* no such down load image */
#define PTGONEDOWN	8		/* pt no longer booting */

/*
 * TSP Ioctl stuff
 */
#define TSP_WPB		1		/* write parameter block */
#define TSP_CIB		2		/* clear input buffer */
struct tspioblock
{
	char	baud;
	char	stopbits;
	char	parity;
	char	bitsperchar;
	char	ixoff;
	char	ixon;
	char	ixany;
	char	cunused;
	short	sunused;
};
#define TSPS15		0		/* 1.5 stopbits per character */
#define TSPS1		1		/* 1 stopbits per character */
#define TSPS2		2		/* 2 stopbits per character */
#define TSPPODD		0		/* odd parity */
#define TSPPEVEN	1		/* even parity */
#define TSPPNONE	2		/* no parity */
#define TSPCS5		5		/* 5 data bits per character */
#define TSPCS6		6		/* 6 data bits per character */
#define TSPCS7		7		/* 7 data bits per character */
#define TSPCS8		8		/* 8 data bits per character */
#define	TSPB0		0		/* hangup */
#define	TSPB50		1		/* 50 baud */
#define	TSPB75		2		/* 75 baud */
#define	TSPB110		3		/* 110 baud */
#define	TSPB134		4		/* 134 baud */
#define	TSPB150		5		/* 150 baud */
#define	TSPB200		6		/* 200 baud */
#define	TSPB300		7		/* 300 baud */
#define	TSPB600		8		/* 600 baud */
#define	TSPB1200	9		/* 1200 baud */
#define	TSPB1800	10		/* 1800 baud */
#define	TSPB2400	11		/* 2400 baud */
#define	TSPB4800	12		/* 4800 baud */
#define	TSPB9600	13		/* 9600 baud */
