/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)reg.h	1.1"	*/

#ifndef reg_h
#define reg_h

#include <sys/target.h>
/*
 * Location of the users' stored registers relative to R0.
 * Usage is u.u_ar0[XX].
 */

#define	R0	(0)
#define	R1	(1)
#define	R2	(2)
#define	R3	(3)
#define	R4	(4)
#define	R5	(5)
#define	R6	(6)
#define	R7	(7)
#define AR0	(8)
#define	AR1	(9)
#define	AR2	(10)
#define	AR3	(11)
#define	AR4	(12)
#define	AR5	(13)
#define	AR6	(14)
#define	AR7	(15)
#define	SP	(15)
#if mc68000
#define	PC	(18)
#define	RPS	(17)
#endif
#if mc68010
#define	PC	(17)
#define	RPS	(16)
#define	VECTOR	(18)		/* vector offset + flag in MS 16 bits
				   special status word in LS 16 bits */
#define EV_FLTADR (19)		/* fault address */
#define EV_DOPBF  (20)		/* data output buffer in LS 16 bits */
#define EV_DIPBF  (21)		/* data input buffer in LS 16 bits */
#define EV_IIPBF  (22)		/* instruction input buffer */

#define EV_LNGFRMT	0x80000000	/* 1= long format */
/* bits in special status word of the long format exception stack frame */
#define EV_RR	0x8000		/* rerun flag 0=processor rerun 1=s/w rerun */
#define EV_IF	0x2000		/* instruction fetch */
#define EV_DF	0x1000		/* data fetch to data input buffer */
#define EV_RM	0x0800		/* read-modify-write cycle */
#define EV_HB	0x0400		/* high byte transfer (valid if BY set) */
#define EV_BY	0x0200		/* BY=1 byte xfr else word */
#define EV_RW	0x0100		/* read/write 0=write 1=read */
#define EV_FC	0x0007		/* fc2-0 */

#endif

#define	TBIT	0100000		/* PS trace bit */
#endif
