
/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)space.h	1.30" */

#ifndef space_h
#define space_h

/* #define	KERNEL	*/

#include <sys/param.h>

#include "sys/acct.h"
struct	acct	acctbuf;
struct	inode	*acctp;

#include "sys/tty.h"
struct	cblock	cfree[NCLIST];

#include "sys/buf.h"
struct	buf	buf[NBUF];	/* buffer headers */
char	buffers	[NBUF][BSIZE];

struct	buf	bfreelist;	/* head of the free list of buffers */
struct	pfree	pfreelist;	/* Head of physio header pool */
struct	buf	pbuf[NPBUF];	/* Physical io header pool */
int	nbuf = NPBUF;
struct	buf	swbuf[NSWBUF];
int	nswbuf = NSWBUF;
struct	buf	bswlist;
struct	buf	*bclnlist;

struct	hbuf	hbuf[NHBUF];	/* buffer hash table */

#include "sys/file.h"
struct	file	file[NFILE];	/* file table */
int cdlimit = MAXFSIZE;		/* max file size (ulimit) */

#include "sys/inode.h"
struct	inode	inode[NINODE];	/* inode table */
struct locklist locklist[NFLOCKS];
short nflocks = NFLOCKS;

#include "sys/proc.h"
struct	proc	proc[NPROC];	/* process table */

#include "sys/text.h"
struct	text text[NTEXT];	/* text table */

#include "sys/map.h"
struct map swapmap[SMAPSIZ];
struct map argmap[ARGMAPSIZE];
int	argsz = ARGSZ;
int	nswapmap = SMAPSIZ;

/* dynamic root option (see startup()) */
int dynroot = DYNROOT;

/* set up user virtual limits */
ushort Maxumem = MAXUMEM;	/* max click # of user */
uint Maxuaddr = ctob(MAXUMEM);	/* same for ASM */
uint Usrstack = ctob(MAXUMEM);	/* starts right below highest address */
ushort *Maxupgaddr = PG_BASE + MAXUMEM; /* top of hardware map address */

#include "sys/callo.h"
struct callo callout[NCALL];
struct fcallo fcallout[NCALL];

#include "sys/mount.h"
struct mount mount[NMOUNT];

#include "sys/elog.h"
#include "sys/err.h"
#include "sys/erec.h"
struct	err	err = {
	NESLOT,
};

#include "sys/sysinfo.h"
struct sysinfo sysinfo;
struct syswait syswait;
struct syserr syserr;

#include "sys/opt.h"

#include "sys/var.h"
struct var v = {
	NBUF,
	NCALL,
	NINODE,
	(char *)(&inode[NINODE]),
	NFILE,
	(char *)(&file[NFILE]),
	NMOUNT,
	(char *)(&mount[NMOUNT]),
	NPROC,
	(char *)(&proc[2]),
	NTEXT,
	(char *)(&text[NTEXT]),
	NCLIST,
	NSABUF,
	MAXUP,
	SMAPSIZ,
	NHBUF,
	NHBUF-1,
	NPBUF,
};

#include "sys/init.h"

#ifndef	PRF_0
prfintr() {}
unsigned	prfstat;
#endif

#ifdef	DISK_0
#ifndef	DISK_1
#define	DISK_1	0
#endif
#ifndef	DISK_2
#define	DISK_2	0
#endif
#ifndef	DISK_3
#define	DISK_3	0
#endif
#include "sys/iobuf.h"
#include "sys/gdisk.h"
/*	MiniFrame general disk driver global variables */
ushort gdhdbbq[HDMAXCYL], gdhd1bbq[HDMAXCYL];
struct bbmcell gdhdbb[HDMAXBADBLK], gdhd1bb[HDMAXBADBLK];

extern ghdintr(), ghdstart();
extern gfpintr(), gfpstart();

struct gdswprt gddefault = {
	"Deflt",1,1,4,4,HITECH|FPDENSITY,0,512}; /* sufficient to load vhb+bbt*/

struct gdsw gdsw[] = {
	{	0, {"WIN", 1023, 4, 17, 68, 0, 0, 512},
		-1, 0, 16, 1023*16, 80, ghdintr, ghdstart,
		HDMAXCYL, HDMAXBADBLK, gdhdbbq, gdhdbb, 0},
	{	0, {"DRV1", 1023, 4, 17, 68, 0, 0, 512},
		-1, 0, 16, 1023*16, 80, ghdintr, ghdstart,
		HDMAXCYL, HDMAXBADBLK, gdhd1bbq, gdhd1bb, 0},
	{	0, {"FD", 80, 2, 8, 16, 2, 0, 512},
		-1, 0, 8, 80*8, 80, gfpintr, gfpstart,
		FPMAXCYL, FPMAXBADBLK, NULL, NULL, 0}
};
struct iobuf	gdutab[DISKS];
struct iobuf	gdtab;
struct iotime	gdstat[DISKS];
struct driver	gdreal;
int gd_cnt = DISK_0;		/* 1 general disk controller for HD SY FD */
char	gdourunflg = 0;		/* disk dma over/under run flag */
#endif

#ifdef	TRACE_0
#include "sys/trace.h"
struct trace trace[TRACE_0];
#endif

#if MESG==1
#include	"sys/ipc.h"
#include	"sys/msg.h"

struct map	msgmap[MSGMAP];
struct msqid_ds	msgque[MSGMNI];
struct msg	msgh[MSGTQL];
char		msgbuf[MSGSEG*MSGSSZ];
struct msginfo	msginfo = {
	MSGMAP,
	MSGMAX,
	MSGMNB,
	MSGMNI,
	MSGSSZ,
	MSGTQL,
	MSGSEG
};
#endif

#if SEMA==1
#	ifndef IPC_ALLOC
#	include	"sys/ipc.h"
#	endif
#include	"sys/sem.h"
struct semid_ds	sema[SEMMNI];
struct sem	sem[SEMMNS];
struct map	semmap[SEMMAP];
struct	sem_undo	*sem_undo[NPROC];
#define	SEMUSZ	(sizeof(struct sem_undo)+sizeof(struct undo)*SEMUME)
/* each undo struct is SEMUSZ bytes long */
unsigned char semu[SEMUSZ*SEMMNU];
union {
	short		semvals[SEMMSL];
	struct semid_ds	ds;
	struct sembuf	semops[SEMOPM];
}	semtmp;

struct	seminfo seminfo = {
	SEMMAP,
	SEMMNI,
	SEMMNS,
	SEMMNU,
	SEMMSL,
	SEMOPM,
	SEMUME,
	SEMUSZ,
	SEMVMX,
	SEMAEM
};
#endif

#if SHMEM==1
#	ifndef	IPC_ALLOC
#	include	"sys/ipc.h"
#	endif
#include	"sys/shm.h"
struct shmid_ds	shmem[SHMMNI];	
struct	shmpt_ds	shm_pte[NPROC*SHMSEG];
struct	shminfo shminfo = {
	SHMMAX,
	SHMMIN,
	SHMMNI,
	SHMSEG,
	SHMBRK,
	SHMALL
};
struct map shmmap[SHMMAPSIZE];
struct mpte shmmpte[SHMALL];	/* page table entries */
#endif

#if NETWORK==1
struct map mbmap[256];
char mbutlbase[32768+128];
#endif

/*	data associated with the low level RS-232 input routine in ml/i8274.s */
#include "sys/iohw.h"
#include "sys/i8274.h"

struct device sertty0 = {
	0, NULL, A_CMND_ADDR, A_DATA_ADDR, A_CMND_ADDR,
	0,0,0,0,0,0,SEL_A_BAUD,A_BAUD_ADDR,AB_CNTL_WD };
struct device sertty1 = {
	0, NULL, B_CMND_ADDR, B_DATA_ADDR, A_CMND_ADDR,
	0,0,0,0,0,1,SEL_B_BAUD,B_BAUD_ADDR,AB_CNTL_WD };
#if I8274_0 > 1
struct device sertty2 = {
	0, NULL, C_CMND_ADDR, C_DATA_ADDR, C_CMND_ADDR,
	0,0,0,0,0,0,SEL_C_BAUD,C_BAUD_ADDR,CD_CNTL_WD };
struct device sertty3 = {
	0, NULL, D_CMND_ADDR, D_DATA_ADDR, C_CMND_ADDR,
	0,0,0,0,0,1,SEL_D_BAUD,D_BAUD_ADDR,CD_CNTL_WD };
struct device sertty4 = {
	0, NULL, E_CMND_ADDR, E_DATA_ADDR, E_CMND_ADDR,
	0,0,0,0,0,0,SEL_E_BAUD,E_BAUD_ADDR,CD_CNTL_WD };
struct device sertty5 = {
	0, NULL, F_CMND_ADDR, F_DATA_ADDR, E_CMND_ADDR,
	0,0,0,0,0,1,SEL_F_BAUD,F_BAUD_ADDR,GH_CNTL_WD };
struct device sertty6 = {
	0, NULL, G_CMND_ADDR, G_DATA_ADDR, G_CMND_ADDR,
	0,0,0,0,0,0,SEL_G_BAUD,G_BAUD_ADDR,GH_CNTL_WD };
struct device sertty7 = {
	0, NULL, H_CMND_ADDR, H_DATA_ADDR, G_CMND_ADDR,
	0,0,0,0,0,1,SEL_H_BAUD,H_BAUD_ADDR,GH_CNTL_WD };
struct device sertty8 = {
	0, NULL, I_CMND_ADDR, I_DATA_ADDR, I_CMND_ADDR,
	0,0,0,0,0,0,SEL_I_BAUD,I_BAUD_ADDR,IJ_CNTL_WD };
struct device sertty9 = {
	0, NULL, J_CMND_ADDR, J_DATA_ADDR, I_CMND_ADDR,
	0,0,0,0,0,1,SEL_J_BAUD,J_BAUD_ADDR,IJ_CNTL_WD };
#if I8274_0 > 5
struct device sertty10 = {
	0, NULL, K_CMND_ADDR, K_DATA_ADDR, K_CMND_ADDR,
	0,0,0,0,0,0,SEL_K_BAUD,K_BAUD_ADDR,IJ_CNTL_WD };
struct device sertty11 = {
	0, NULL, L_CMND_ADDR, L_DATA_ADDR, K_CMND_ADDR,
	0,0,0,0,0,1,SEL_L_BAUD,L_BAUD_ADDR,LMN_CNTL_WD };
struct device sertty12 = {
	0, NULL, M_CMND_ADDR, M_DATA_ADDR, M_CMND_ADDR,
	0,0,0,0,0,0,SEL_M_BAUD,M_BAUD_ADDR,LMN_CNTL_WD };
struct device sertty13 = {
	0, NULL, N_CMND_ADDR, N_DATA_ADDR, M_CMND_ADDR,
	0,0,0,0,0,1,SEL_N_BAUD,N_BAUD_ADDR,LMN_CNTL_WD };
struct device sertty14 = {
	0, NULL, O_CMND_ADDR, O_DATA_ADDR, O_CMND_ADDR,
	0,0,0,0,0,0,SEL_O_BAUD,O_BAUD_ADDR,OPQ_CNTL_WD };
struct device sertty15 = {
	0, NULL, P_CMND_ADDR, P_DATA_ADDR, O_CMND_ADDR,
	0,0,0,0,0,1,SEL_P_BAUD,P_BAUD_ADDR,OPQ_CNTL_WD };
struct device sertty16 = {
	0, NULL, Q_CMND_ADDR, Q_DATA_ADDR, Q_CMND_ADDR,
	0,0,0,0,0,0,SEL_Q_BAUD,Q_BAUD_ADDR,OPQ_CNTL_WD };
struct device sertty17 = {
	0, NULL, R_CMND_ADDR, R_DATA_ADDR, Q_CMND_ADDR,
	0,0,0,0,0,1,SEL_R_BAUD,R_BAUD_ADDR,R_CNTL_WD };
#endif
#endif
struct device *ser_addr[] = {
#if I8274_0 > 1
	&sertty0, &sertty1, &sertty2, &sertty3, &sertty4, &sertty5,
#if I8274_0 > 5
	&sertty6, &sertty7, &sertty8, &sertty9, &sertty10, &sertty11,
	&sertty12, &sertty13, &sertty14, &sertty15, &sertty16, &sertty17 };
#else
	&sertty6, &sertty7, &sertty8, &sertty9 };
#endif
#else
	&sertty0, &sertty1 };
#endif

#define SZSERBUF	(I8274_0 * 2 * NSERBUF)
unsigned int serbuf[SZSERBUF];
unsigned int *inptr = serbuf;		/* addr of next char to put in buffer */
unsigned int *outptr = serbuf;	/* address of next char to take from buffer */

int serbufcnt = 0;			/* count of characters in buffer */
int serbufful = SZSERBUF;		/* max characters that can be put in buffer */
#ifdef LATER
int serhiwater = (SZSERBUF - (I8274_0 * 2*SERHI)); /*hi water mark, when serbufcnt exceeds -xoff */
int serlowater = ((SZSERBUF / 4) * 1);	/*low water mark, when serbufcnt falls below -xon */

unsigned int serxoff = 0;		/* XOFF from RX blocking TX */
unsigned int serrqstxoff = 0;		/* RX requests TX to send XOFF */
#endif

char serinprogress = 0;			/* =1 means C serrint is running */
unsigned int serinxoff = 0;		/* received XOFF blocking TX */
unsigned int sertxblkd = 0;		/* received XOFF should restart TX */
unsigned int sercd = 0;		/* state of CD for each line */
unsigned int sercts = 0;		/* state of CTS for each line */
unsigned int serixon = 0;		/* state of ixon for each line */
unsigned int *eserbuf = &serbuf[SZSERBUF]; /* first address past serbuf */
short ser_ports[ I8274_0 ] = {0};   /* preserves extended control bits 
					per 8274 port	*/
int ser_cnt = I8274_0 * 2;		/* how many serial ports */
struct tty ser_tty[I8274_0 * 2] = {0};	/* info about each one */

/* table of serial drivers interrupt routines and table for interrupt sharing */
extern int  rx8274b(), tx8274b(), st8274b(), sr8274b();
extern int  rx8274a(), tx8274a(), st8274a(), sr8274a();
#if I8274_0 > 1
extern int  rx8274d(), tx8274d(), st8274d(), sr8274d();
extern int  rx8274c(), tx8274c(), st8274c(), sr8274c();
extern int  rx8274f(), tx8274f(), st8274f(), sr8274f();
extern int  rx8274e(), tx8274e(), st8274e(), sr8274e();
extern int  rx8274h(), tx8274h(), st8274h(), sr8274h();
extern int  rx8274g(), tx8274g(), st8274g(), sr8274g();
extern int  rx8274j(), tx8274j(), st8274j(), sr8274j();
extern int  rx8274i(), tx8274i(), st8274i(), sr8274i();
#if I8274_0 > 5
extern int  rx8274l(), tx8274l(), st8274l(), sr8274l();
extern int  rx8274k(), tx8274k(), st8274k(), sr8274k();
extern int  rx8274n(), tx8274n(), st8274n(), sr8274n();
extern int  rx8274m(), tx8274m(), st8274m(), sr8274m();
extern int  rx8274p(), tx8274p(), st8274p(), sr8274p();
extern int  rx8274o(), tx8274o(), st8274o(), sr8274o();
extern int  rx8274r(), tx8274r(), st8274r(), sr8274r();
extern int  rx8274q(), tx8274q(), st8274q(), sr8274q();
#endif
#endif
int (*ser_iv[])() = {
	rx8274a, tx8274a, sr8274a, st8274a,
	rx8274b, tx8274b, sr8274b, st8274b,
#if I8274_0 > 1
	rx8274c, tx8274c, sr8274c, st8274c,
	rx8274d, tx8274d, sr8274d, st8274d,
	rx8274e, tx8274e, sr8274e, st8274e,
	rx8274f, tx8274f, sr8274f, st8274f,
	rx8274g, tx8274g, sr8274g, st8274g,
	rx8274h, tx8274h, sr8274h, st8274h,
	rx8274i, tx8274i, sr8274i, st8274i,
	rx8274j, tx8274j, sr8274j, st8274j,
#if I8274_0 > 5
	rx8274k, tx8274k, sr8274k, st8274k,
	rx8274l, tx8274l, sr8274l, st8274l,
	rx8274m, tx8274m, sr8274m, st8274m,
	rx8274n, tx8274n, sr8274n, st8274n,
	rx8274o, tx8274o, sr8274o, st8274o,
	rx8274p, tx8274p, sr8274p, st8274p,
	rx8274q, tx8274q, sr8274q, st8274q,
	rx8274r, tx8274r, sr8274r, st8274r,
#endif
#endif
	};
int (*ser_vec[I8274_0 * 2])();		/* hold vector owners */

#include "sys/i8259.h"
#ifdef S2652_0
ushort A8259intmask = (ushort) (DISABCH0 | DISABCH2);
					/* disable RS422 TXU & CARR int */
#else
ushort A8259intmask = (ushort) (DISABCH0 | DISABCH1 | DISABCH2 | DISABCH3);
					/* disable RS422 ints */
#endif

#ifdef S2652_0
#include "sys/pt422.h"
#include "sys/cl.h"

/*  These are the statically-allocated area for line and drop blocks.	*/

struct lblk ltab[S2652_0];
struct dblk dtab[NDROPS * S2652_0];
struct dblk *lutab[NDROPS * S2652_0];
short cl_lines = S2652_0;	/* # RS-422 lines for cluster operation */
short cl_drops = NDROPS;	/* drops per  S2652 */
short pt_cnt = S2652_0 * NDROPS;
struct pt_tty pt_tty[S2652_0 * NDROPS];
struct pt_direct pt_direct[S2652_0 * NDROPS * 2];/* 2 for windows */
struct pt_direct *ptdhd;
struct pt_flags pt_fl[S2652_0];	/* data structs for low level pt operation */
struct lblk *pt_wrl[S2652_0]; 
struct pt_spbufs pt_spbufs[S2652_0 * NDROPS];
struct xbuf xbffree[S2652_0 * NDROPS * NXBUF];	/* xbufs for output */
struct xbuf *xbfhd;
int ptdrv = PTDRV;		/* what drive to get download images from */
#else
/* the clist hi-water stuff uses pt_cnt */
short pt_cnt = 0;
#endif

/* 
 *	Pseudo-terminal tty and ioctl structs.
 */

#if PTS_0 > 0
#include "sys/vt.h"

short vt_cnt = PTS_0;

struct	tty vt_tty[PTS_0];
struct	vt_ioctl vt_ioctl[PTS_0];
#endif

#if !LATER
int pwr_cnt = 0;
int pwr_act = 0;
#endif

#if NOTIFY==1
#include "sys/notify.h"
EV_NOT Ev_not[NEVNOT];
EV_TAB Ev_tab[NEVTAB];
short NEv_tab = NEVTAB;
short NEv_not = NEVNOT;
#endif

/*
 * /dev/console driver buffers
 */
/* For debugging, this buffer may be made larger (e.g. 20000) */
/* we must have this some where in binary */
char conbuf[CBUFSZ] = {
	"Copyright 1983, Convergent Technologies, Inc. \
	Licensed Material, Property of \
	Convergent Technologies, Inc. \
	All Rights Reserved."
};
char *conbufhead = conbuf;
char *conbuftail = conbuf;
char *conbufend = conbuf + sizeof(conbuf);
char *conbufread = conbuf;
short consz = CBUFSZ;

#endif space_h
