/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)sysmacros.h	1.4"	*/

#ifndef sysmacros_h
#define sysmacros_h

/*
 * Some macros for units conversion
 */
/* Core clicks (4096 bytes) to segments and vice versa */
#ifdef CPSSHIFT
#define	ctos(x)	(((x)+(NCPS-1))>>CPSSHIFT)
#define	stoc(x)	((x)<<CPSSHIFT)
#else
#define ctos(x) ((x+(NCPS-1))/NCPS)
#define	stoc(x) ((x)*NCPS)
#endif

/* round clicks to next segment multiple */
#define segrnd(x) (((x)+(NCPS-1)) & ~(NCPS-1))

/* Core clicks (4096 bytes) to disk blocks (1024 bytes) */
#ifdef mc68k
#define	ctod(x)	((x)<<2)
#define dtoc(x) ((x)>>2)
#else vax
#define	ctod(x) ((x+(NCPD-1))/NCPD)
#endif mc68k

/* inumber to disk address */
#ifdef INOSHIFT
#define	itod(x)	(daddr_t)(((unsigned)x+(2*INOPB-1))>>INOSHIFT)
#else
#define	itod(x)	(daddr_t)(((unsigned)x+(2*INOPB-1))/INOPB)
#endif

/* inumber to disk offset */
#ifdef INOSHIFT
#define	itoo(x)	(int)(((unsigned)x+(2*INOPB-1))&(INOPB-1))
#else
#define	itoo(x)	(int)(((unsigned)x+(2*INOPB-1))%INOPB)
#endif

/* clicks to bytes */
#ifdef BPCSHIFT
#define	ctob(x)	((x)<<BPCSHIFT)
#else
#define	ctob(x)	((x)*NBPC)
#endif

/* bytes to clicks */
#ifdef BPCSHIFT
#define	btoc(x)	(((unsigned)(x)+(NBPC-1))>>BPCSHIFT)
#define	btoct(x)	((unsigned)(x)>>BPCSHIFT)
#else
#define	btoc(x)	(((unsigned)(x)+(NBPC-1))/NBPC)
#define	btoct(x)	((unsigned)(x)/NBPC)
#endif

/* major part of a device */
#define	major(x)	(int)((unsigned)x>>8)
#define	bmajor(x)	(int)(((unsigned)x>>8)&037)
#define	brdev(x)	(x&0x1fff)

/* minor part of a device */
#define	minor(x)	(int)(x&0377)

/* make a device number */
#define	makedev(x,y)	(dev_t)(((x)<<8) | (y))

/* kernel prints: make printf conditional on globl "kpflg" being set. */
#define kprintf kpflg&&printf
extern int kpflg;	/* kernel printf flag enables debugging output */

/* bytes to disk blocks, disk blocks to bytes */
#define btodb(x) (((x)+BSIZE-1)>>BSHIFT)
#define dbtob(x) ((x)<<BSHIFT)

/* file system blocks to disk blocks and back */
#define	fsbtodb(b)	(b)
#define	dbtofsb(b)	(b)

/* min and max */
#define KIMIN(a, b)	((int)(a) <= (int)(b) ? (a) : (b))
#define KIMAX(a, b)	((int)(a) >= (int)(b) ? (a) : (b))
#endif sysmacros_h
