/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)systm.h	1.4"	*/

#ifndef systm_h
#define systm_h

#include <sys/param.h>
#include <sys/inode.h>
#include <sys/proc.h>
#include <sys/pte.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/filsys.h>
#include <sys/cmap.h>

/*
 * Random set of variables used by more than one routine.
 */
extern struct inode *rootdir;	/* pointer to inode of root directory */
extern short cputype;		/* type of cpu = 1	MegaFrame
						 2	MegaFrame2 (MiniFrame)
				 */
extern time_t lbolt;		/* time in HZ since last boot */
extern time_t time;		/* time in sec from 1970 */

extern char runin;		/* scheduling flag */
extern char runout;		/* scheduling flag */
#ifdef vax
extern char runrun;		/* scheduling flag */
#else
extern int runrun;		/* scheduling flag */
#endif
extern char curpri;		/* current priority */
extern struct proc *curproc;	/* current proc */
extern struct proc *curmapproc;	/* current proc loaded in memory map */
extern struct proc *runq;	/* head of linked list of running processes */

extern	maxmem;			/* max available memory */
extern	physmem;		/* physical memory on this CPU */
#ifdef vax
extern daddr_t swplo;		/* block number of swap space */
#endif
extern	nswap;			/* size of swap space */
extern dev_t rootdev;		/* device of the root */
extern dev_t swapdev;		/* swapping device */
extern dev_t pipedev;		/* pipe device */
extern char *panicstr;		/* panic string pointer */
extern	blkacty;		/* active block devices */
extern	pwr_cnt, pwr_act;
extern int (*pwr_clr[])();

extern dev_t getmdev();
extern daddr_t	bmap();
extern struct inode *ialloc();
extern struct inode *iget();
extern struct inode *owner();
extern struct inode *maknode();
extern struct inode *namei();
extern struct buf *alloc();
extern struct buf *getblk();
extern struct buf *geteblk();
extern struct buf *bread();
extern struct buf *breada();
extern struct filsys *getfs();
extern struct file *getf();
extern struct file *falloc();
extern int	uchar();

/*
 * Structure of the system-entry table
 */
extern struct sysent {
	char	sy_narg;		/* total number of arguments */
#ifdef vax
	char	sy_nrarg;		/* number of args in registers */
#endif vax
	int	(*sy_call)();		/* handler */
} sysent[];

int	hand;			/* current index into coremap used by daemon */

int	nswdev;			/* number of swap devices */
#ifndef slp_c
extern	int	mpid;		/* generic for unique process id's */
#endif
#ifdef mega
char	kmapwnt;		/* kernel map want flag */
#endif
extern	dev_t	argdev;		/* device for argument lists */

extern struct buf *baddr();
extern void bcopy();
extern int copyin();
extern int copyout();
extern int copyseg();
extern int clearseg();
#ifdef MEGA
extern caddr_t calloc();
extern char *heap_alloc();
extern void heap_free();
extern char *heap_realloc();
#endif MEGA
extern unsigned max();
extern void mclear();
extern int memall();
extern struct cmap *mfind();
extern unsigned min();
extern int schar();
#ifdef MEGA
extern short segall();
#endif MEGA
extern swblk_t vtod();
extern struct pte *vtohpte();
extern struct mpte *vtopte();

#ifdef mega
#if LATER
/* space for vmmap defined in locore.s */
char	vmmap[];		/* poor name! */
#endif
int	umbabeg,umbaend;	/* where sensitive vm begins/ends */
extern	int catcher[256];
#endif
int	noproc;			/* no one is running just now */
int	wantin;
int	openi_enable;		/* enable ino_open() */
#endif systm_h
