/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)user.h	1.5"	*/

#ifndef user_h
#define user_h

#include <sys/types.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/dmap.h>
#include <sys/signal.h>
#include <sys/vlimit.h>
#include <sys/dir.h>

/*
 * The user structure.
 * One allocated per process.
 * Contains all per process data that doesn't need to be referenced
 * while the process is swapped.
 * The user block is USIZE*click bytes long; resides at virtual kernel
 * loc 0x70000
 * contains the system stack per user; is cross referenced
 * with the proc structure for the same process.
 */
 
struct	user
{
	label_t	u_rsav;			/* save info when exchanging stacks */
	label_t	u_qsav;			/* label variable for quits and interrupts */
	label_t	u_ssav;			/* label variable for swapping */
	char	u_segflg;		/* IO flag: 0:user D; 1:system; 2:user I */
	char	u_error;		/* return error code */
	ushort	u_uid;			/* effective user id */
	ushort	u_gid;			/* effective group id */
	ushort	u_ruid;			/* real user id */
	ushort	u_rgid;			/* real group id */
	struct proc *u_procp;		/* pointer to proc structure */
	int	*u_ap;			/* pointer to arglist */
	union {				/* syscall return values */
		struct	{
			int	r_val1;
			int	r_val2;
		}r_reg;
		off_t	r_off;
		time_t	r_time;
	} u_r;
	caddr_t	u_base;			/* base address for IO */
	unsigned u_count;		/* bytes remaining for IO */
	union {
		off_t	ow_offset;	/* offset in file for IO */
		wndw_t	ow_wndw;	/* window # for tty IO */
	} u_ow;
#define u_offset u_ow.ow_offset
#define u_wndw u_ow.ow_wndw
	short	u_fmode;		/* file mode for IO */
	ushort	u_pbsize;		/* bytes in block for IO */
	ushort	u_pboff;		/* offset in block for IO */
	dev_t	u_pbdev;		/* real device for IO */
	daddr_t	u_rablock;		/* read ahead block addr */
	short	u_errcnt;		/* syscall error count */
	struct inode *u_cdir;		/* current directory of process */
	struct inode *u_rdir;		/* root directory of process */
	caddr_t	u_dirp;			/* pathname pointer */
	struct direct u_dent;		/* current directory entry */
	struct inode *u_pdir;		/* inode of parent directory of dirp */
	struct file *u_ofile[NOFILE];	/* pointers to file structures of open files */
	char	u_pofile[NOFILE];	/* per-process flags of open files */
	int	u_arg[10];		/* arguments to current system call */
	/* u_tsize u_dsize u_ssize have copies in the proc table */
	unsigned u_tsize;		/* text size (clicks) */
	unsigned u_dsize;		/* data size (clicks) */
	unsigned u_ssize;		/* stack size (clicks) */
	int	u_signal[NSIG];		/* disposition of signals */
	ushort	u_sigevkey;		/* notify user on receiving a signal */
	time_t	u_utime;		/* this process user time */
	time_t	u_stime;		/* this process system time */
	time_t	u_cutime;		/* sum of childs' utimes */
	time_t	u_cstime;		/* sum of childs' stimes */
	int	*u_ar0;			/* address of users saved R0 */
	struct u_prof {			/* profile arguments */
		short	*pr_base;	/* buffer base */
		unsigned pr_size;	/* buffer size */
		unsigned pr_off;	/* pc offset */
		unsigned pr_scale;	/* pc scaling */
	} u_prof;
	short	*u_ttyp;		/* pointer to pgrp in "tty" struct */
	dev_t	u_ttyd;			/* controlling tty dev */
	struct {			/* header of executable file */
		short	ux_mag;		/* magic number */
		short	ux_stamp;	/* stamp */
		unsigned ux_tsize;	/* text size */
		unsigned ux_dsize;	/* data size */
		unsigned ux_bsize;	/* bss size */
		unsigned ux_ssize;	/* symbol table size */
		unsigned ux_entloc;	/* entry location */
		unsigned ux_unused;
		unsigned ux_relflg;
	} u_exdata;
#define	ux_tstart	ux_unused
	char	u_comm[DIRSIZ];
	time_t	u_start;
	time_t	u_ticks;
	long	u_mem;
	long	u_ior;
	long	u_iow;
	long	u_iosw;
	long	u_ioch;
	char	u_acflag;
	short	u_cmask;		/* mask for file creation */
	daddr_t	u_limit[NLIMITS+1];	/* see <sys/vlimit.h> */
#ifdef mc68k
#ifdef MEGA
	struct exch *u_exch[NUEXCH];	/* exchange pointers for this proc. */
	struct exch *u_childexch;	/* used in fork/procdup for new exch */
#endif MEGA
	struct	dmap u_dmap;		/* disk map for data segment */
	struct	dmap u_smap;		/* disk map for stack segment */
	struct	dmap u_cdmap, u_csmap;	/* shadows of u_dmap, u_smap, for
					   use of parent during fork */
					/* hardware specific stuff */
	wndw_t	u_dfltwndw;		/* default window for controlling tty */
	struct	ev_not *u_evnothdr;	/* header for notifications */
#ifdef mini
	struct pt_direct *u_ptd;	/* ptr for direct access to PT */
#endif mini
#endif mc68k

					/* When the process is in memory,
					 * the page table entries for ts+ds+ss
					 * are stored in u in the following
					 * manner:
					 * 	The page table entries start at
					 * start of u page + PTE_OFFSET =
					 * u + 1536 = u + 0x600. u starts at
					 * u page + U_OFFSET (0x600). If the #
					 * of entries is <= 512, only one page
					 * of u structure is allocated.
					 * Otherwise the second page of u is 
					 * allocated(pointed to by p_addr[1]
					 * and p_szpt = 1.)
					 * The rest of the page entries continue
					 * in the second page.
					 */

					/* kernel stack per user
					 * extends from u
					 * backward not to reach u - (1536==0x600)
					 */
	short	u_lock;			/* process/text locking flags */
};
#ifdef KERNEL
extern struct user u;
#endif

#define	u_rval1	u_r.r_reg.r_val1
#define	u_rval2	u_r.r_reg.r_val2
#define	u_roff	u_r.r_off
#define	u_rtime	u_r.r_time

/* ioflag values: Read/Write, User/Kernel, Ins/Data */
#define	U_WUD	0
#define	U_RUD	1
#define	U_WKD	2
#define	U_RKD	3
#define	U_WUI	4
#define	U_RUI	5

#define EXCLOSE 01			/* auto-close on exec */

#endif
