/*	Convergent Technologies - System V - Sep 1984	*/
/*	"@(#)syslocal.h	1.2"	*/

/*
 * valid 'cmds' for syslocal() sys call
 */
#define SYSL_SYSTEM		0	/* identify machine type */
#define SYSL_RESYNC		1	/* re-sync disks */
#define SYSL_OPENI		2	/* set inode open flag */
#define SYSL_CDT		3	/* return CDT (MegaFrame) */
#define SYSL_APNUM		4	/* which AP # */
#define SYSL_TOTAPS		5	/* how many APs */
#define SYSL_CONSOLE		6	/* console mgmt (MegaFrame) */
#define SYSL_MAXUSERS		7	/* maximum allowable users */
#define SYSL_CRASH		8	/* get crash dump (MegaFrame) */
#define SYSL_KADDR		9	/* Kernel addresses (e.g. for ps ) */
#define SYSL_PSTAT		10	/* PILF: */
#define SYSL_PFSTAT		11	/* PILF: */
#define SYSL_GETCLUS		12	/* PILF: */
#define SYSL_SETCLUS		13	/* PILF: */
#define SYSL_REBOOT		14	/* force reboot */
#define SYSL_ALLOCDRV		15	/* dynamic driver allocate */
#define SYSL_BINDDRV		16	/* dynamic driver bind */

/* values for SYSL_KADDR */
#define SLA_V		0	/* return struct var address */
#define SLA_PROC	1	/* return proc struct address */
#define SLA_ERR		2	/* errlog struct */
#define SLA_TIME	3	/* time */
#define SLA_CDT		4	/* CDT */
#define SLA_GDUTAB	5	/* disk driver (MiniFrame) */
#define SLA_USRSTK	6	/* top of user stack */
#define SLA_USIGN	7	/* UNIX signiture */

/*
 * return values for syslocal(SYSL_SYSTEM)
 */
#define	SYSL_MITI	2
#define	SYSL_MINI	1
#define SYSL_MEGA	0

/*
 * used for keeping track of what kind
 * of system we are on
 * __Sflag__ is non-zero after we have done
 *	the syslocal(SYSL_SYSTEM) to find out what we are
 *	running on
 * __Stype__ is { SYSL_MITI, SYSL_MINI, SYSL_MEGA }
 */
int __Sflag__;
int __Stype__;

/*
 * returns a 1 if the that is truly the
 * machine you are running on
 */
#define is_miniframe()	( (__Sflag__ == 0 && \
	(__Sflag__++, __Stype__ = syslocal(SYSL_SYSTEM))), \
	__Stype__ == SYSL_MINI)

#define is_mitiframe()	( (__Sflag__ == 0 && \
	(__Sflag__++, __Stype__ = syslocal(SYSL_SYSTEM))), \
	__Stype__ == SYSL_MITI)

#define is_megaframe()	( (__Sflag__ == 0 && \
	(__Sflag__++, __Stype__ = syslocal(SYSL_SYSTEM))), \
	__Stype__ == SYSL_MEGA)
	
